/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int ALL = 3;
    public static final int ARRAY = 4;
    public static final int CASE = 5;
    public static final int CHECK = 6;
    public static final int CONSTRAINT = 7;
    public static final int CROSS = 8;
    public static final int CURRENT_CATALOG = 9;
    public static final int CURRENT_DATE = 10;
    public static final int CURRENT_SCHEMA = 11;
    public static final int CURRENT_TIME = 12;
    public static final int CURRENT_TIMESTAMP = 13;
    public static final int CURRENT_USER = 14;
    public static final int DISTINCT = 15;
    public static final int EXCEPT = 16;
    public static final int EXISTS = 17;
    public static final int FALSE = 18;
    public static final int FETCH = 19;
    public static final int FOR = 20;
    public static final int FOREIGN = 21;
    public static final int FROM = 22;
    public static final int FULL = 23;
    public static final int GROUP = 24;
    public static final int HAVING = 25;
    public static final int IF = 26;
    public static final int INNER = 27;
    public static final int INTERSECT = 28;
    public static final int INTERSECTS = 29;
    public static final int INTERVAL = 30;
    public static final int IS = 31;
    public static final int JOIN = 32;
    public static final int LEFT = 33;
    public static final int LIKE = 34;
    public static final int LIMIT = 35;
    public static final int LOCALTIME = 36;
    public static final int LOCALTIMESTAMP = 37;
    public static final int MINUS = 38;
    public static final int NATURAL = 39;
    public static final int NOT = 40;
    public static final int NULL = 41;
    public static final int OFFSET = 42;
    public static final int ON = 43;
    public static final int ORDER = 44;
    public static final int PRIMARY = 45;
    public static final int QUALIFY = 46;
    public static final int RIGHT = 47;
    public static final int ROW = 48;
    public static final int _ROWID_ = 49;
    public static final int ROWNUM = 50;
    public static final int SELECT = 51;
    public static final int TABLE = 52;
    public static final int TRUE = 53;
    public static final int UNION = 54;
    public static final int UNIQUE = 55;
    public static final int UNKNOWN = 56;
    public static final int USING = 57;
    public static final int VALUES = 58;
    public static final int WHERE = 59;
    public static final int WINDOW = 60;
    public static final int WITH = 61;
    private static final int UPPER_OR_OTHER_LETTER = 50;
    private static final int UPPER_OR_OTHER_LETTER_OR_DIGIT = 562;
    private static final int LOWER_OR_OTHER_LETTER = 52;
    private static final int LOWER_OR_OTHER_LETTER_OR_DIGIT = 564;
    private static final int LETTER = 62;
    private static final int LETTER_OR_DIGIT = 574;

    private ParserUtil() {
    }

    public static boolean isKeyword(String string2, boolean bl) {
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        return ParserUtil.getSaveTokenType(string2, bl, 0, n, false) != 2;
    }

    public static boolean isSimpleIdentifier(String string2, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = string2.length();
        if (n3 == 0) {
            return false;
        }
        if (bl) {
            if (bl2) {
                throw new IllegalArgumentException("databaseToUpper && databaseToLower");
            }
            n2 = 50;
            n = 562;
        } else if (bl2) {
            n2 = 52;
            n = 564;
        } else {
            n2 = 62;
            n = 574;
        }
        char c = string2.charAt(0);
        if ((n2 >>> Character.getType(c) & 1) == 0 && c != '_') {
            return false;
        }
        for (int j = 1; j < n3; ++j) {
            c = string2.charAt(j);
            if ((n >>> Character.getType(c) & 1) != 0 || c == '_') continue;
            return false;
        }
        return ParserUtil.getSaveTokenType(string2, !bl, 0, n3, true) == 2;
    }

    public static int getSaveTokenType(String string2, boolean bl, int n, int n2, boolean bl2) {
        char c = string2.charAt(n);
        if (bl) {
            c = (char)(c & 0xFFDF);
        }
        switch (c) {
            case 'A': {
                if (ParserUtil.eq("ALL", string2, bl, n, n2)) {
                    return 3;
                }
                if (ParserUtil.eq("ARRAY", string2, bl, n, n2)) {
                    return 4;
                }
                if (bl2 && (ParserUtil.eq("AND", string2, bl, n, n2) || ParserUtil.eq("AS", string2, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'B': {
                if (bl2 && (ParserUtil.eq("BETWEEN", string2, bl, n, n2) || ParserUtil.eq("BOTH", string2, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'C': {
                if (ParserUtil.eq("CASE", string2, bl, n, n2)) {
                    return 5;
                }
                if (ParserUtil.eq("CHECK", string2, bl, n, n2)) {
                    return 6;
                }
                if (ParserUtil.eq("CONSTRAINT", string2, bl, n, n2)) {
                    return 7;
                }
                if (ParserUtil.eq("CROSS", string2, bl, n, n2)) {
                    return 8;
                }
                if (ParserUtil.eq("CURRENT_CATALOG", string2, bl, n, n2)) {
                    return 9;
                }
                if (ParserUtil.eq("CURRENT_DATE", string2, bl, n, n2)) {
                    return 10;
                }
                if (ParserUtil.eq("CURRENT_SCHEMA", string2, bl, n, n2)) {
                    return 11;
                }
                if (ParserUtil.eq("CURRENT_TIME", string2, bl, n, n2)) {
                    return 12;
                }
                if (ParserUtil.eq("CURRENT_TIMESTAMP", string2, bl, n, n2)) {
                    return 13;
                }
                if (ParserUtil.eq("CURRENT_USER", string2, bl, n, n2)) {
                    return 14;
                }
                return 2;
            }
            case 'D': {
                if (ParserUtil.eq("DISTINCT", string2, bl, n, n2)) {
                    return 15;
                }
                return 2;
            }
            case 'E': {
                if (ParserUtil.eq("EXCEPT", string2, bl, n, n2)) {
                    return 16;
                }
                if (ParserUtil.eq("EXISTS", string2, bl, n, n2)) {
                    return 17;
                }
                return 2;
            }
            case 'F': {
                if (ParserUtil.eq("FETCH", string2, bl, n, n2)) {
                    return 19;
                }
                if (ParserUtil.eq("FROM", string2, bl, n, n2)) {
                    return 22;
                }
                if (ParserUtil.eq("FOR", string2, bl, n, n2)) {
                    return 20;
                }
                if (ParserUtil.eq("FOREIGN", string2, bl, n, n2)) {
                    return 21;
                }
                if (ParserUtil.eq("FULL", string2, bl, n, n2)) {
                    return 23;
                }
                if (ParserUtil.eq("FALSE", string2, bl, n, n2)) {
                    return 18;
                }
                if (bl2 && ParserUtil.eq("FILTER", string2, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'G': {
                if (ParserUtil.eq("GROUP", string2, bl, n, n2)) {
                    return 24;
                }
                if (bl2 && ParserUtil.eq("GROUPS", string2, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'H': {
                if (ParserUtil.eq("HAVING", string2, bl, n, n2)) {
                    return 25;
                }
                return 2;
            }
            case 'I': {
                if (ParserUtil.eq("IF", string2, bl, n, n2)) {
                    return 26;
                }
                if (ParserUtil.eq("INNER", string2, bl, n, n2)) {
                    return 27;
                }
                if (ParserUtil.eq("INTERSECT", string2, bl, n, n2)) {
                    return 28;
                }
                if (ParserUtil.eq("INTERSECTS", string2, bl, n, n2)) {
                    return 29;
                }
                if (ParserUtil.eq("INTERVAL", string2, bl, n, n2)) {
                    return 30;
                }
                if (ParserUtil.eq("IS", string2, bl, n, n2)) {
                    return 31;
                }
                if (bl2 && (ParserUtil.eq("ILIKE", string2, bl, n, n2) || ParserUtil.eq("IN", string2, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'J': {
                if (ParserUtil.eq("JOIN", string2, bl, n, n2)) {
                    return 32;
                }
                return 2;
            }
            case 'L': {
                if (ParserUtil.eq("LEFT", string2, bl, n, n2)) {
                    return 33;
                }
                if (ParserUtil.eq("LIMIT", string2, bl, n, n2)) {
                    return 35;
                }
                if (ParserUtil.eq("LIKE", string2, bl, n, n2)) {
                    return 34;
                }
                if (ParserUtil.eq("LOCALTIME", string2, bl, n, n2)) {
                    return 36;
                }
                if (ParserUtil.eq("LOCALTIMESTAMP", string2, bl, n, n2)) {
                    return 37;
                }
                if (bl2 && ParserUtil.eq("LEADING", string2, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'M': {
                if (ParserUtil.eq("MINUS", string2, bl, n, n2)) {
                    return 38;
                }
                return 2;
            }
            case 'N': {
                if (ParserUtil.eq("NOT", string2, bl, n, n2)) {
                    return 40;
                }
                if (ParserUtil.eq("NATURAL", string2, bl, n, n2)) {
                    return 39;
                }
                if (ParserUtil.eq("NULL", string2, bl, n, n2)) {
                    return 41;
                }
                return 2;
            }
            case 'O': {
                if (ParserUtil.eq("OFFSET", string2, bl, n, n2)) {
                    return 42;
                }
                if (ParserUtil.eq("ON", string2, bl, n, n2)) {
                    return 43;
                }
                if (ParserUtil.eq("ORDER", string2, bl, n, n2)) {
                    return 44;
                }
                if (bl2 && (ParserUtil.eq("OR", string2, bl, n, n2) || ParserUtil.eq("OVER", string2, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'P': {
                if (ParserUtil.eq("PRIMARY", string2, bl, n, n2)) {
                    return 45;
                }
                if (bl2 && ParserUtil.eq("PARTITION", string2, bl, n, n2)) {
                    return 1;
                }
                return 2;
            }
            case 'Q': {
                if (ParserUtil.eq("QUALIFY", string2, bl, n, n2)) {
                    return 46;
                }
                return 2;
            }
            case 'R': {
                if (ParserUtil.eq("RIGHT", string2, bl, n, n2)) {
                    return 47;
                }
                if (ParserUtil.eq("ROW", string2, bl, n, n2)) {
                    return 48;
                }
                if (ParserUtil.eq("ROWNUM", string2, bl, n, n2)) {
                    return 50;
                }
                if (bl2 && (ParserUtil.eq("RANGE", string2, bl, n, n2) || ParserUtil.eq("REGEXP", string2, bl, n, n2) || ParserUtil.eq("ROWS", string2, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'S': {
                if (ParserUtil.eq("SELECT", string2, bl, n, n2)) {
                    return 51;
                }
                if (bl2 && (ParserUtil.eq("SYSDATE", string2, bl, n, n2) || ParserUtil.eq("SYSTIME", string2, bl, n, n2) || ParserUtil.eq("SYSTIMESTAMP", string2, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'T': {
                if (ParserUtil.eq("TABLE", string2, bl, n, n2)) {
                    return 52;
                }
                if (ParserUtil.eq("TRUE", string2, bl, n, n2)) {
                    return 53;
                }
                if (bl2 && (ParserUtil.eq("TODAY", string2, bl, n, n2) || ParserUtil.eq("TOP", string2, bl, n, n2) || ParserUtil.eq("TRAILING", string2, bl, n, n2))) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if (ParserUtil.eq("UNION", string2, bl, n, n2)) {
                    return 54;
                }
                if (ParserUtil.eq("UNIQUE", string2, bl, n, n2)) {
                    return 55;
                }
                if (ParserUtil.eq("UNKNOWN", string2, bl, n, n2)) {
                    return 56;
                }
                if (ParserUtil.eq("USING", string2, bl, n, n2)) {
                    return 57;
                }
                return 2;
            }
            case 'V': {
                if (ParserUtil.eq("VALUES", string2, bl, n, n2)) {
                    return 58;
                }
                return 2;
            }
            case 'W': {
                if (ParserUtil.eq("WHERE", string2, bl, n, n2)) {
                    return 59;
                }
                if (ParserUtil.eq("WINDOW", string2, bl, n, n2)) {
                    return 60;
                }
                if (ParserUtil.eq("WITH", string2, bl, n, n2)) {
                    return 61;
                }
                return 2;
            }
            case '_': {
                if (n2 - n != 7 || !"_ROWID_".regionMatches(bl, 0, string2, n, 7)) break;
                return 49;
            }
        }
        return 2;
    }

    private static boolean eq(String string2, String string3, boolean bl, int n, int n2) {
        int n3 = string2.length();
        return n2 - n == n3 && string2.regionMatches(bl, 1, string3, n + 1, n3 - 1);
    }
}

