/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.CharsetCollator;
import org.h2.value.CompareModeDefault;
import org.h2.value.CompareModeIcu4J;
import org.h2.value.Value;

public class CompareMode
implements Comparator<Value> {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    public static final String CHARSET = "CHARSET_";
    public static final String SIGNED = "SIGNED";
    public static final String UNSIGNED = "UNSIGNED";
    private static volatile CompareMode lastUsed;
    private static final boolean CAN_USE_ICU4J;
    private final String name;
    private final int strength;
    private final boolean binaryUnsigned;
    private final boolean uuidUnsigned;

    protected CompareMode(String string2, int n, boolean bl, boolean bl2) {
        this.name = string2;
        this.strength = n;
        this.binaryUnsigned = bl;
        this.uuidUnsigned = bl2;
    }

    public static CompareMode getInstance(String string2, int n) {
        return CompareMode.getInstance(string2, n, SysProperties.SORT_BINARY_UNSIGNED, SysProperties.SORT_UUID_UNSIGNED);
    }

    public static CompareMode getInstance(String string2, int n, boolean bl, boolean bl2) {
        CompareMode compareMode = lastUsed;
        if (compareMode != null && Objects.equals(compareMode.name, string2) && compareMode.strength == n && compareMode.binaryUnsigned == bl && compareMode.uuidUnsigned == bl2) {
            return compareMode;
        }
        if (string2 == null || string2.equals(OFF)) {
            compareMode = new CompareMode(string2, n, bl, bl2);
        } else {
            boolean bl3;
            if (string2.startsWith(ICU4J)) {
                bl3 = true;
                string2 = string2.substring(ICU4J.length());
            } else if (string2.startsWith(DEFAULT)) {
                bl3 = false;
                string2 = string2.substring(DEFAULT.length());
            } else {
                bl3 = string2.startsWith(CHARSET) ? false : CAN_USE_ICU4J;
            }
            compareMode = bl3 ? new CompareModeIcu4J(string2, n, bl, bl2) : new CompareModeDefault(string2, n, bl, bl2);
        }
        lastUsed = compareMode;
        return compareMode;
    }

    public boolean equalsChars(String string2, int n, String string3, int n2, boolean bl) {
        char c = string2.charAt(n);
        char c2 = string3.charAt(n2);
        if (bl) {
            c = Character.toUpperCase(c);
            c2 = Character.toUpperCase(c2);
        }
        return c == c2;
    }

    public int compareString(String string2, String string3, boolean bl) {
        if (bl) {
            return string2.compareToIgnoreCase(string3);
        }
        return string2.compareTo(string3);
    }

    public static String getName(Locale locale) {
        Locale locale2 = Locale.ENGLISH;
        String string2 = locale.getDisplayLanguage(locale2) + ' ' + locale.getDisplayCountry(locale2) + ' ' + locale.getVariant();
        string2 = StringUtils.toUpperEnglish(string2.trim().replace(' ', '_'));
        return string2;
    }

    static boolean compareLocaleNames(Locale locale, String string2) {
        return string2.equalsIgnoreCase(locale.toString()) || string2.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String string2) {
        String string3;
        String string4;
        Locale locale2;
        int n;
        Collator collator = null;
        if (string2.startsWith(ICU4J)) {
            string2 = string2.substring(ICU4J.length());
        } else if (string2.startsWith(DEFAULT)) {
            string2 = string2.substring(DEFAULT.length());
        } else if (string2.startsWith(CHARSET)) {
            return new CharsetCollator(Charset.forName(string2.substring(CHARSET.length())));
        }
        int n2 = string2.length();
        if (n2 == 2) {
            Locale[] localeArray = new Locale(StringUtils.toLowerEnglish(string2), "");
            if (CompareMode.compareLocaleNames((Locale)localeArray, string2)) {
                collator = Collator.getInstance((Locale)localeArray);
            }
        } else if (n2 == 5 && (n = string2.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale2 = new Locale(string4 = StringUtils.toLowerEnglish(string2.substring(0, n)), string3 = string2.substring(n + 1)), string2)) {
            collator = Collator.getInstance(locale2);
        }
        if (collator == null) {
            for (Locale locale2 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale2, string2)) continue;
                collator = Collator.getInstance(locale2);
                break;
            }
        }
        return collator;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isBinaryUnsigned() {
        return this.binaryUnsigned;
    }

    public boolean isUuidUnsigned() {
        return this.uuidUnsigned;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompareMode)) {
            return false;
        }
        CompareMode compareMode = (CompareMode)object;
        if (!this.getName().equals(compareMode.getName())) {
            return false;
        }
        if (this.strength != compareMode.strength) {
            return false;
        }
        if (this.binaryUnsigned != compareMode.binaryUnsigned) {
            return false;
        }
        return this.uuidUnsigned == compareMode.uuidUnsigned;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getName().hashCode();
        n = 31 * n + this.strength;
        n = 31 * n + (this.binaryUnsigned ? 1231 : 1237);
        n = 31 * n + (this.uuidUnsigned ? 1231 : 1237);
        return n;
    }

    @Override
    public int compare(Value value, Value value2) {
        return value.compareTo(value2, null, this);
    }

    static {
        boolean bl = false;
        try {
            Class.forName("com.ibm.icu.text.Collator");
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        CAN_USE_ICU4J = bl;
    }
}

