/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;

public class ValueRow
extends ValueCollectionBase {
    private static final Object EMPTY = ValueRow.get(new Value[0]);

    private ValueRow(Value[] valueArray) {
        super(valueArray);
    }

    public static ValueRow get(Value[] valueArray) {
        return new ValueRow(valueArray);
    }

    public static ValueRow getEmpty() {
        return (ValueRow)EMPTY;
    }

    @Override
    public int getValueType() {
        return 39;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder("ROW (");
        for (int j = 0; j < this.values.length; ++j) {
            if (j > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[j].getString());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        ValueRow valueRow = (ValueRow)value;
        if (this.values == valueRow.values) {
            return 0;
        }
        int n = this.values.length;
        if (n != valueRow.values.length) {
            throw DbException.get(21002);
        }
        for (int j = 0; j < n; ++j) {
            Value value2 = this.values[j];
            Value value3 = valueRow.values[j];
            int n2 = value2.compareTo(value3, castDataProvider, compareMode);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public Object getObject() {
        int n = this.values.length;
        Object[] objectArray = new Object[n];
        for (int j = 0; j < n; ++j) {
            int n2;
            Value value = this.values[j];
            objectArray[j] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((n2 = value.getValueType()) == 2 || n2 == 3) ? Integer.valueOf(value.getInt()) : value.getObject();
        }
        return objectArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        throw this.getUnsupportedExceptionForOperation("PreparedStatement.set");
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("ROW (");
        int n = this.values.length;
        for (int j = 0; j < n; ++j) {
            if (j > 0) {
                stringBuilder.append(", ");
            }
            this.values[j].getSQL(stringBuilder);
        }
        return stringBuilder.append(')');
    }

    @Override
    public String getTraceSQL() {
        StringBuilder stringBuilder = new StringBuilder("ROW (");
        for (int j = 0; j < this.values.length; ++j) {
            Value value;
            if (j > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((value = this.values[j]) == null ? "null" : value.getTraceSQL());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueRow)) {
            return false;
        }
        ValueRow valueRow = (ValueRow)object;
        if (this.values == valueRow.values) {
            return true;
        }
        int n = this.values.length;
        if (n != valueRow.values.length) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            if (this.values[j].equals(valueRow.values[j])) continue;
            return false;
        }
        return true;
    }
}

