/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.util.TimeZone;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.JSR310;
import org.h2.util.JSR310Utils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class ValueTime
extends Value {
    public static final int DEFAULT_PRECISION = 8;
    public static final int MAXIMUM_PRECISION = 18;
    static final int DEFAULT_SCALE = 0;
    public static final int MAXIMUM_SCALE = 9;
    private final long nanos;

    private ValueTime(long l) {
        this.nanos = l;
    }

    public static ValueTime fromNanos(long l) {
        if (l < 0L || l >= 86400000000000L) {
            StringBuilder stringBuilder = new StringBuilder();
            DateTimeUtils.appendTime(stringBuilder, l);
            throw DbException.get(22007, "TIME", stringBuilder.toString());
        }
        return (ValueTime)Value.cache(new ValueTime(l));
    }

    public static ValueTime get(TimeZone timeZone, Time time) {
        long l = time.getTime();
        return ValueTime.fromNanos(DateTimeUtils.nanosFromLocalMillis(l + (long)(timeZone == null ? DateTimeUtils.getTimeZoneOffsetMillis(l) : timeZone.getOffset(l))));
    }

    public static ValueTime parse(String string2) {
        try {
            return ValueTime.fromNanos(DateTimeUtils.parseTimeNanos(string2, 0, string2.length()));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIME", string2);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public Time getTime(TimeZone timeZone) {
        return new Time(DateTimeUtils.getMillis(timeZone, 1008673L, this.nanos));
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIME;
    }

    @Override
    public int getValueType() {
        return 9;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(18);
        DateTimeUtils.appendTime(stringBuilder, this.nanos);
        return stringBuilder.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("TIME '");
        DateTimeUtils.appendTime(stringBuilder, this.nanos);
        return stringBuilder.append('\'');
    }

    @Override
    public boolean checkPrecision(long l) {
        return true;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.nanos;
        long l2 = DateTimeUtils.convertScale(l, n, 86400000000000L);
        if (l2 == l) {
            return this;
        }
        return ValueTime.fromNanos(l2);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Long.compare(this.nanos, ((ValueTime)value).nanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ValueTime && this.nanos == ((ValueTime)object).nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTime(null);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        if (JSR310.PRESENT) {
            try {
                preparedStatement.setObject(n, JSR310Utils.valueToLocalTime(this), 92);
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        preparedStatement.setTime(n, this.getTime(null));
    }

    @Override
    public Value add(Value value) {
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        return ValueTime.fromNanos(this.nanos + valueTime.getNanos());
    }

    @Override
    public Value subtract(Value value) {
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        return ValueTime.fromNanos(this.nanos - valueTime.getNanos());
    }

    @Override
    public Value multiply(Value value) {
        return ValueTime.fromNanos((long)((double)this.nanos * value.getDouble()));
    }

    @Override
    public Value divide(Value value) {
        return ValueTime.fromNanos((long)((double)this.nanos / value.getDouble()));
    }
}

