/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class Collector {
    private Collector() {
    }

    public static Elements collect(Evaluator eval, Element root2) {
        Elements elements = new Elements();
        NodeTraversor.traverse((NodeVisitor)new Accumulator(root2, elements, eval), root2);
        return elements;
    }

    public static Element findFirst(Evaluator eval, Element root2) {
        FirstFinder finder = new FirstFinder(root2, eval);
        NodeTraversor.filter((NodeFilter)finder, root2);
        return finder.match;
    }

    private static class Accumulator
    implements NodeVisitor {
        private final Element root;
        private final Elements elements;
        private final Evaluator eval;

        Accumulator(Element root2, Elements elements, Evaluator eval) {
            this.root = root2;
            this.elements = elements;
            this.eval = eval;
        }

        @Override
        public void head(Node node2, int depth) {
            Element el;
            if (node2 instanceof Element && this.eval.matches(this.root, el = (Element)node2)) {
                this.elements.add(el);
            }
        }

        @Override
        public void tail(Node node2, int depth) {
        }
    }

    private static class FirstFinder
    implements NodeFilter {
        private final Element root;
        private Element match = null;
        private final Evaluator eval;

        FirstFinder(Element root2, Evaluator eval) {
            this.root = root2;
            this.eval = eval;
        }

        @Override
        public NodeFilter.FilterResult head(Node node2, int depth) {
            Element el;
            if (node2 instanceof Element && this.eval.matches(this.root, el = (Element)node2)) {
                this.match = el;
                return NodeFilter.FilterResult.STOP;
            }
            return NodeFilter.FilterResult.CONTINUE;
        }

        @Override
        public NodeFilter.FilterResult tail(Node node2, int depth) {
            return NodeFilter.FilterResult.CONTINUE;
        }
    }
}

