/*
 * Decompiled with CFR 0.152.
 */
package site.starsone.engine;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.starsone.engine.DownloadEngine;
import site.starsone.engine.DownloadTask;
import site.starsone.engine.HasDownloadedObservable;
import site.starsone.listener.DownloadListenerBuilder;
import site.starsone.model.DownloadMessage;
import site.starsone.model.HttpParam;
import site.starsone.util.DownloadUtil;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020$H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lsite/starsone/engine/HttpConnectionEngine;", "Lsite/starsone/engine/DownloadEngine;", "()V", "downloadMessage", "Lsite/starsone/model/DownloadMessage;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "lastDownload", "", "mDownloadListener", "Lsite/starsone/listener/DownloadListenerBuilder;", "maxRetryCount", "observable", "Lsite/starsone/engine/HasDownloadedObservable;", "retryCount", "sizeRead", "speedByte", "speedThread", "Ljava/lang/Thread;", "url", "", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "cancelTask", "", "task", "pauseTask", "taskId", "resumeTask", "startDownload", "Lsite/starsone/engine/DownloadTask;", "KxDownload"})
public final class HttpConnectionEngine
extends DownloadEngine {
    private int retryCount = 1;
    private final int maxRetryCount;
    private Thread speedThread;
    private int lastDownload;
    private int sizeRead;
    private int speedByte;
    private DownloadListenerBuilder mDownloadListener;
    private HasDownloadedObservable observable;
    public String url;
    public File file;
    private DownloadMessage downloadMessage;

    @NotNull
    public final String getUrl() {
        String string2 = this.url;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("url");
        }
        return string2;
    }

    public final void setUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.url = string2;
    }

    @NotNull
    public final File getFile() {
        File file = this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
        }
        return file;
    }

    public final void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.file = file;
    }

    @Override
    @NotNull
    public String startDownload(@NotNull DownloadTask task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
        Function1<DownloadListenerBuilder, Unit> downloadListenerBuilder = task2.getDownloadListenerBuilder();
        String url = task2.getUrl();
        File file = task2.getFile();
        HttpParam httpParam = task2.getHttpParam();
        this.downloadMessage = new DownloadMessage(url, file, task2.getTaskId());
        this.url = url;
        this.file = file;
        DownloadListenerBuilder downloadListenerBuilder2 = new DownloadListenerBuilder();
        int n = 0;
        boolean bl = false;
        downloadListenerBuilder.invoke(downloadListenerBuilder2);
        DownloadListenerBuilder downloadListenerBuilder3 = this.mDownloadListener = downloadListenerBuilder2;
        if (downloadListenerBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
        }
        if (downloadListenerBuilder3.getOnProgressAction$KxDownload() != null) {
            HasDownloadedObservable hasDownloadedObservable = this.observable = new HasDownloadedObservable();
            if (hasDownloadedObservable != null) {
                hasDownloadedObservable.addObserver(new Observer(this){
                    final /* synthetic */ HttpConnectionEngine this$0;

                    public final void update(Observable $noName_0, Object $noName_1) {
                        HttpConnectionEngine.access$setSpeedByte$p(this.this$0, HttpConnectionEngine.access$getSizeRead$p(this.this$0) - HttpConnectionEngine.access$getLastDownload$p(this.this$0));
                        HttpConnectionEngine.access$setLastDownload$p(this.this$0, HttpConnectionEngine.access$getSizeRead$p(this.this$0));
                    }
                    {
                        this.this$0 = httpConnectionEngine;
                    }
                });
            }
        }
        try {
            InputStream inputStream2;
            DownloadListenerBuilder downloadListenerBuilder4 = this.mDownloadListener;
            if (downloadListenerBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
            }
            Function1<DownloadMessage, Unit> function1 = downloadListenerBuilder4.getOnBeforeAction$KxDownload();
            if (function1 != null) {
                DownloadMessage downloadMessage = this.downloadMessage;
                if (downloadMessage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                function1.invoke(downloadMessage);
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            URL url2 = new URL(url);
            URLConnection uRLConnection = url2.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection httpConnection = (HttpURLConnection)uRLConnection;
            httpConnection.setConnectTimeout(5000);
            httpConnection.setReadTimeout(5000);
            HashMap<String, String> headers = httpParam.getHeaders();
            if (headers == null) {
                httpConnection.addRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36");
            } else {
                Map $this$forEach$iv = headers;
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl2 = false;
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl3 = false;
                    httpConnection.addRequestProperty((String)it.getKey(), ((String)it.getValue()).toString());
                }
            }
            int completeFileSize = httpConnection.getContentLength();
            DownloadMessage downloadMessage = this.downloadMessage;
            if (downloadMessage == null) {
                Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
            }
            downloadMessage.setFileSize(Long.valueOf(completeFileSize));
            boolean isResume = false;
            if (file.exists()) {
                if (file.length() == (long)completeFileSize) {
                    DownloadMessage downloadMessage2 = this.downloadMessage;
                    if (downloadMessage2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    downloadMessage2.setProgress(1.0);
                    DownloadListenerBuilder downloadListenerBuilder5 = this.mDownloadListener;
                    if (downloadListenerBuilder5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                    }
                    Function1<DownloadMessage, Unit> function12 = downloadListenerBuilder5.getOnFinishAction$KxDownload();
                    if (function12 != null) {
                        DownloadMessage downloadMessage3 = this.downloadMessage;
                        if (downloadMessage3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                        }
                        function12.invoke(downloadMessage3);
                    }
                    return task2.getTaskId();
                }
                if (file.length() < (long)completeFileSize) {
                    isResume = true;
                }
            }
            if (isResume) {
                URLConnection uRLConnection2 = url2.openConnection();
                if (uRLConnection2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                HttpURLConnection conn = (HttpURLConnection)uRLConnection2;
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.116 Safari/537.36");
                this.sizeRead = (int)file.length();
                HasDownloadedObservable hasDownloadedObservable = this.observable;
                if (hasDownloadedObservable != null) {
                    hasDownloadedObservable.change();
                }
                conn.setRequestProperty("RANGE", "bytes=" + (long)this.sizeRead + "-");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                conn.disconnect();
                conn.connect();
                inputStream2 = conn.getInputStream();
            } else {
                inputStream2 = httpConnection.getInputStream();
            }
            InputStream inputStream3 = inputStream2;
            byte[] bufferArray = new byte[10240];
            int length = 0;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(this.sizeRead);
            while (true) {
                length = inputStream3.read(bufferArray);
                this.sizeRead += length;
                if (length == -1) break;
                DownloadMessage downloadMessage4 = this.downloadMessage;
                if (downloadMessage4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                downloadMessage4.setHasDownloadSize(Long.valueOf(this.sizeRead));
                DownloadMessage downloadMessage5 = this.downloadMessage;
                if (downloadMessage5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                downloadMessage5.setProgress((double)this.sizeRead / (double)completeFileSize);
                DownloadMessage downloadMessage6 = this.downloadMessage;
                if (downloadMessage6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                DownloadMessage downloadMessage7 = this.downloadMessage;
                if (downloadMessage7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                Double d = downloadMessage7.getProgress();
                downloadMessage6.setPercent(d != null ? Double.valueOf(d * (double)100) : null);
                DownloadMessage downloadMessage8 = this.downloadMessage;
                if (downloadMessage8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                downloadMessage8.setSpeed(DownloadUtil.Companion.speedToString(this.speedByte));
                DownloadListenerBuilder downloadListenerBuilder6 = this.mDownloadListener;
                if (downloadListenerBuilder6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                }
                Function1<DownloadMessage, Unit> function13 = downloadListenerBuilder6.getOnProgressAction$KxDownload();
                if (function13 != null) {
                    DownloadMessage downloadMessage9 = this.downloadMessage;
                    if (downloadMessage9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    function13.invoke(downloadMessage9);
                }
                byte[] byArray = bufferArray;
                int n2 = 0;
                boolean bl4 = false;
                randomAccessFile.write(ArraysKt.copyOfRange(byArray, n2, length));
            }
            randomAccessFile.close();
            DownloadListenerBuilder downloadListenerBuilder7 = this.mDownloadListener;
            if (downloadListenerBuilder7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
            }
            Function1<DownloadMessage, Unit> function14 = downloadListenerBuilder7.getOnFinishAction$KxDownload();
            if (function14 != null) {
                DownloadMessage downloadMessage10 = this.downloadMessage;
                if (downloadMessage10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                function14.invoke(downloadMessage10);
            }
            Thread thread2 = this.speedThread;
            if (thread2 != null) {
                thread2.interrupt();
            }
        }
        catch (Exception e) {
            n = this.retryCount;
            this.retryCount = n + 1;
            if (this.retryCount == this.maxRetryCount) {
                Thread thread3 = this.speedThread;
                if (thread3 != null) {
                    thread3.interrupt();
                }
                String string2 = "\u51fa\u73b0\u5f02\u5e38,\u5df2\u91cd\u8bd5" + this.maxRetryCount + '\u6b21';
                bl = false;
                System.out.println((Object)string2);
                DownloadListenerBuilder downloadListenerBuilder8 = this.mDownloadListener;
                if (downloadListenerBuilder8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                }
                Function2<DownloadMessage, Exception, Unit> function2 = downloadListenerBuilder8.getOnErrorAction$KxDownload();
                if (function2 != null) {
                    DownloadMessage downloadMessage = this.downloadMessage;
                    if (downloadMessage == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    function2.invoke(downloadMessage, e);
                }
            }
            this.startDownload(url, file, httpParam, downloadListenerBuilder);
        }
        return task2.getTaskId();
    }

    @Override
    public void cancelTask(@NotNull String task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
        String string2 = "httpconnection\u4e0b\u8f7d\u4e0d\u652f\u6301\u53d6\u6d88\u4efb\u52a1\u64cd\u4f5c";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public void pauseTask(@NotNull String taskId2) {
        Intrinsics.checkNotNullParameter(taskId2, "taskId");
        String string2 = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public void resumeTask(@NotNull String taskId2) {
        Intrinsics.checkNotNullParameter(taskId2, "taskId");
        String string2 = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    public HttpConnectionEngine() {
        this.maxRetryCount = 3;
    }

    public static final /* synthetic */ int access$getSpeedByte$p(HttpConnectionEngine $this) {
        return $this.speedByte;
    }

    public static final /* synthetic */ void access$setSpeedByte$p(HttpConnectionEngine $this, int n) {
        $this.speedByte = n;
    }

    public static final /* synthetic */ int access$getSizeRead$p(HttpConnectionEngine $this) {
        return $this.sizeRead;
    }

    public static final /* synthetic */ void access$setSizeRead$p(HttpConnectionEngine $this, int n) {
        $this.sizeRead = n;
    }

    public static final /* synthetic */ int access$getLastDownload$p(HttpConnectionEngine $this) {
        return $this.lastDownload;
    }

    public static final /* synthetic */ void access$setLastDownload$p(HttpConnectionEngine $this, int n) {
        $this.lastDownload = n;
    }
}

