/*
 * Decompiled with CFR 0.152.
 */
package site.starsone.engine;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import site.starsone.engine.DownloadEngine;
import site.starsone.engine.DownloadStatus;
import site.starsone.engine.DownloadTask;
import site.starsone.engine.HasDownloadedObservable;
import site.starsone.engine.OkhttpEngine$DownloadRunnable$WhenMappings;
import site.starsone.listener.DownloadListenerBuilder;
import site.starsone.model.DownloadMessage;
import site.starsone.model.HttpParam;
import site.starsone.util.DownloadUtil;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lsite/starsone/engine/OkhttpEngine;", "Lsite/starsone/engine/DownloadEngine;", "()V", "cancelTask", "", "task", "", "pauseTask", "taskId", "resumeTask", "startDownload", "Lsite/starsone/engine/DownloadTask;", "DownloadRunnable", "KxDownload"})
public final class OkhttpEngine
extends DownloadEngine {
    @Override
    @NotNull
    public String startDownload(@NotNull DownloadTask task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
        this.getDownloadQueue().add(task2);
        this.getThreadPool().submit(new DownloadRunnable(task2));
        return task2.getTaskId();
    }

    @Override
    public void cancelTask(@NotNull String task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
    }

    @Override
    public void pauseTask(@NotNull String taskId2) {
        block2: {
            DownloadTask task2;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(taskId2, "taskId");
                Iterable iterable = this.getDownloadQueue();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    DownloadTask it = (DownloadTask)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getTaskId(), taskId2)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            DownloadTask downloadTask = task2 = (DownloadTask)v0;
            if (downloadTask == null) break block2;
            downloadTask.setDownloadStatus(DownloadStatus.PAUSED);
        }
    }

    @Override
    public void resumeTask(@NotNull String taskId2) {
        block2: {
            DownloadTask task2;
            Object v0;
            boolean bl;
            Object object;
            block1: {
                Intrinsics.checkNotNullParameter(taskId2, "taskId");
                object = this.getDownloadQueue();
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    DownloadTask it = (DownloadTask)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getTaskId(), taskId2)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            DownloadTask downloadTask = task2 = (DownloadTask)v0;
            if (downloadTask == null) break block2;
            object = downloadTask;
            bl = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            ((DownloadTask)it).setDownloadStatus(DownloadStatus.WAITING);
            this.startDownload((DownloadTask)it);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\b\u0002\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001fH\u0002J\b\u0010 \u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lsite/starsone/engine/OkhttpEngine$DownloadRunnable;", "Ljava/lang/Runnable;", "task", "Lsite/starsone/engine/DownloadTask;", "(Lsite/starsone/engine/OkhttpEngine;Lsite/starsone/engine/DownloadTask;)V", "downloadMessage", "Lsite/starsone/model/DownloadMessage;", "httpParam", "Lsite/starsone/model/HttpParam;", "lastDownload", "", "mDownloadListener", "Lsite/starsone/listener/DownloadListenerBuilder;", "maxRetryCount", "observable", "Lsite/starsone/engine/HasDownloadedObservable;", "retryCount", "sizeRead", "speedByte", "getTask", "()Lsite/starsone/engine/DownloadTask;", "calculatorDownloadSpeed", "", "changeTaskStatus", "downloadStatus", "Lsite/starsone/engine/DownloadStatus;", "createRequest", "Lokhttp3/Request;", "url", "", "pair", "Lkotlin/Pair;", "run", "KxDownload"})
    public final class DownloadRunnable
    implements Runnable {
        private int lastDownload;
        private int sizeRead;
        private int speedByte;
        private DownloadListenerBuilder mDownloadListener;
        private HasDownloadedObservable observable;
        private int retryCount;
        private final int maxRetryCount;
        private HttpParam httpParam;
        private DownloadMessage downloadMessage;
        @NotNull
        private final DownloadTask task;

        @Override
        public void run() {
            Unit unit;
            Function1<DownloadListenerBuilder, Unit> downloadListenerBuilder = this.task.getDownloadListenerBuilder();
            String url = this.task.getUrl();
            File file = this.task.getFile();
            this.httpParam = this.task.getHttpParam();
            this.changeTaskStatus(DownloadStatus.DOWNLOADING);
            this.downloadMessage = new DownloadMessage(url, file, this.task.getTaskId());
            DownloadListenerBuilder downloadListenerBuilder2 = new DownloadListenerBuilder();
            boolean bl = false;
            boolean bl2 = false;
            downloadListenerBuilder.invoke(downloadListenerBuilder2);
            DownloadListenerBuilder downloadListenerBuilder3 = this.mDownloadListener = downloadListenerBuilder2;
            if (downloadListenerBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
            }
            if (downloadListenerBuilder3.getOnProgressAction$KxDownload() != null) {
                this.calculatorDownloadSpeed();
            }
            DownloadListenerBuilder downloadListenerBuilder4 = this.mDownloadListener;
            if (downloadListenerBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
            }
            Function1<DownloadMessage, Unit> function1 = downloadListenerBuilder4.getOnBeforeAction$KxDownload();
            if (function1 != null) {
                DownloadMessage downloadMessage = this.downloadMessage;
                if (downloadMessage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                unit = function1.invoke(downloadMessage);
            } else {
                unit = null;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Request request = DownloadRunnable.createRequest$default(this, url, null, 2, null);
            OkHttpClient client = new OkHttpClient();
            try {
                Unit unit2;
                InputStream inputStream2;
                Object object;
                String string2;
                InputStream byteStream;
                long completeFileSize;
                Call call2 = client.newCall(request);
                Response response = call2.execute();
                ResponseBody responseBody = response.body();
                long l = completeFileSize = responseBody != null ? responseBody.contentLength() : 0L;
                if (completeFileSize == 0L) {
                    OkhttpEngine.this.log("\u94fe\u63a5\u6d41\u957f\u5ea6\u4e3a0,\u505c\u6b62\u4e0b\u8f7d!");
                    this.changeTaskStatus(DownloadStatus.ERROR);
                    return;
                }
                DownloadMessage downloadMessage = this.downloadMessage;
                if (downloadMessage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                }
                downloadMessage.setFileSize(completeFileSize);
                ResponseBody responseBody2 = response.body();
                InputStream inputStream3 = byteStream = responseBody2 != null ? responseBody2.byteStream() : null;
                if (byteStream == null) {
                    Unit unit3;
                    DownloadListenerBuilder downloadListenerBuilder5 = this.mDownloadListener;
                    if (downloadListenerBuilder5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                    }
                    Function2<DownloadMessage, Exception, Unit> function2 = downloadListenerBuilder5.getOnErrorAction$KxDownload();
                    if (function2 != null) {
                        DownloadMessage downloadMessage2 = this.downloadMessage;
                        if (downloadMessage2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                        }
                        unit3 = function2.invoke(downloadMessage2, new Exception("\u94fe\u63a5\u6d41\u4e3a\u7a7a,\u4e0b\u8f7d\u5931\u8d25!"));
                    } else {
                        unit3 = null;
                    }
                    this.changeTaskStatus(DownloadStatus.ERROR);
                    return;
                }
                Headers headers = response.headers();
                OkhttpEngine.this.log("\u54cd\u5e94\u5934Accept-Ranges: " + headers.get("Accept-Ranges"));
                String string3 = headers.get("Accept-Ranges");
                if (string3 != null) {
                    String string4 = string3;
                    boolean bl3 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase();
                    string2 = string6;
                    Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).toLowerCase()");
                } else {
                    string2 = null;
                }
                boolean isSupportResume = Intrinsics.areEqual(string2, "bytes");
                boolean isResume = false;
                if (file.exists()) {
                    if (file.length() == completeFileSize) {
                        Unit unit4;
                        DownloadMessage downloadMessage3 = this.downloadMessage;
                        if (downloadMessage3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                        }
                        downloadMessage3.setProgress(1.0);
                        DownloadListenerBuilder downloadListenerBuilder6 = this.mDownloadListener;
                        if (downloadListenerBuilder6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                        }
                        Function1<DownloadMessage, Unit> function12 = downloadListenerBuilder6.getOnFinishAction$KxDownload();
                        if (function12 != null) {
                            DownloadMessage downloadMessage4 = this.downloadMessage;
                            if (downloadMessage4 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                            }
                            unit4 = function12.invoke(downloadMessage4);
                        } else {
                            unit4 = null;
                        }
                        this.changeTaskStatus(DownloadStatus.FINISH);
                        return;
                    }
                    if (file.length() < completeFileSize) {
                        this.sizeRead = (int)file.length();
                        isResume = true;
                    }
                }
                if (isResume && isSupportResume) {
                    Object newCall;
                    Request request2 = this.createRequest(url, new Pair<String, String>("RANGE", "bytes=" + this.sizeRead + '-'));
                    try {
                        newCall = client.newCall(request2);
                        ResponseBody responseBody3 = newCall.execute().body();
                        newCall = responseBody3 != null ? responseBody3.byteStream() : null;
                    }
                    catch (Exception e) {
                        Unit unit5;
                        DownloadListenerBuilder downloadListenerBuilder7 = this.mDownloadListener;
                        if (downloadListenerBuilder7 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                        }
                        Function2<DownloadMessage, Exception, Unit> function2 = downloadListenerBuilder7.getOnErrorAction$KxDownload();
                        if (function2 != null) {
                            DownloadMessage downloadMessage5 = this.downloadMessage;
                            if (downloadMessage5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                            }
                            unit5 = function2.invoke(downloadMessage5, e);
                        } else {
                            unit5 = null;
                        }
                        this.changeTaskStatus(DownloadStatus.ERROR);
                        return;
                    }
                    object = newCall;
                } else {
                    object = inputStream2 = byteStream;
                }
                if (inputStream2 == null) {
                    Unit unit6;
                    DownloadListenerBuilder downloadListenerBuilder8 = this.mDownloadListener;
                    if (downloadListenerBuilder8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                    }
                    Function2<DownloadMessage, Exception, Unit> function2 = downloadListenerBuilder8.getOnErrorAction$KxDownload();
                    if (function2 != null) {
                        DownloadMessage downloadMessage6 = this.downloadMessage;
                        if (downloadMessage6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                        }
                        unit6 = function2.invoke(downloadMessage6, new Exception("\u65ad\u70b9\u7684\u6d41\u4e3a\u7a7a,\u4e0b\u8f7d\u5931\u8d25!"));
                    } else {
                        unit6 = null;
                    }
                    this.changeTaskStatus(DownloadStatus.ERROR);
                    return;
                }
                byte[] bufferArray = new byte[10240];
                int length = 0;
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.seek(this.sizeRead);
                while (true) {
                    Unit unit7;
                    length = inputStream2.read(bufferArray);
                    this.sizeRead += length;
                    if (length == -1) break;
                    DownloadMessage downloadMessage7 = this.downloadMessage;
                    if (downloadMessage7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    downloadMessage7.setDownloadStatus(this.task.getDownloadStatus());
                    switch (OkhttpEngine$DownloadRunnable$WhenMappings.$EnumSwitchMapping$0[this.task.getDownloadStatus().ordinal()]) {
                        case 1: {
                            Unit unit8;
                            inputStream2.close();
                            randomAccessFile.close();
                            response.close();
                            OkhttpEngine.this.getDownloadQueue().remove(this.task);
                            file.deleteOnExit();
                            DownloadListenerBuilder downloadListenerBuilder9 = this.mDownloadListener;
                            if (downloadListenerBuilder9 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                            }
                            Function1<DownloadMessage, Unit> function13 = downloadListenerBuilder9.getOnProgressAction$KxDownload();
                            if (function13 != null) {
                                DownloadMessage downloadMessage8 = this.downloadMessage;
                                if (downloadMessage8 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                                }
                                unit8 = function13.invoke(downloadMessage8);
                            } else {
                                unit8 = null;
                            }
                            return;
                        }
                        case 2: {
                            Unit unit9;
                            inputStream2.close();
                            randomAccessFile.close();
                            response.close();
                            OkhttpEngine.this.getPauseList().add(this.task);
                            DownloadListenerBuilder downloadListenerBuilder10 = this.mDownloadListener;
                            if (downloadListenerBuilder10 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                            }
                            Function1<DownloadMessage, Unit> function14 = downloadListenerBuilder10.getOnProgressAction$KxDownload();
                            if (function14 != null) {
                                DownloadMessage downloadMessage9 = this.downloadMessage;
                                if (downloadMessage9 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                                }
                                unit9 = function14.invoke(downloadMessage9);
                            } else {
                                unit9 = null;
                            }
                            return;
                        }
                    }
                    DownloadMessage downloadMessage10 = this.downloadMessage;
                    if (downloadMessage10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    downloadMessage10.setHasDownloadSize(Long.valueOf(this.sizeRead));
                    DownloadMessage downloadMessage11 = this.downloadMessage;
                    if (downloadMessage11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    downloadMessage11.setProgress((double)this.sizeRead / (double)completeFileSize);
                    DownloadMessage downloadMessage12 = this.downloadMessage;
                    if (downloadMessage12 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    DownloadMessage downloadMessage13 = this.downloadMessage;
                    if (downloadMessage13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    Double d = downloadMessage13.getProgress();
                    downloadMessage12.setPercent(d != null ? Double.valueOf(d * (double)100) : null);
                    DownloadListenerBuilder downloadListenerBuilder11 = this.mDownloadListener;
                    if (downloadListenerBuilder11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                    }
                    Function1<DownloadMessage, Unit> function15 = downloadListenerBuilder11.getOnProgressAction$KxDownload();
                    if (function15 != null) {
                        DownloadMessage downloadMessage14 = this.downloadMessage;
                        if (downloadMessage14 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                        }
                        unit7 = function15.invoke(downloadMessage14);
                    } else {
                        unit7 = null;
                    }
                    byte[] byArray = bufferArray;
                    int n = 0;
                    boolean bl4 = false;
                    randomAccessFile.write(ArraysKt.copyOfRange(byArray, n, length));
                }
                inputStream2.close();
                randomAccessFile.close();
                response.close();
                DownloadListenerBuilder downloadListenerBuilder12 = this.mDownloadListener;
                if (downloadListenerBuilder12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                }
                Function1<DownloadMessage, Unit> function16 = downloadListenerBuilder12.getOnFinishAction$KxDownload();
                if (function16 != null) {
                    DownloadMessage downloadMessage15 = this.downloadMessage;
                    if (downloadMessage15 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                    }
                    unit2 = function16.invoke(downloadMessage15);
                } else {
                    unit2 = null;
                }
            }
            catch (Exception e) {
                this.changeTaskStatus(DownloadStatus.ERROR);
                int n = this.retryCount;
                this.retryCount = n + 1;
                if (this.retryCount == this.maxRetryCount) {
                    Unit unit10;
                    String string7 = "\u51fa\u73b0\u5f02\u5e38,\u5df2\u91cd\u8bd5" + this.maxRetryCount + '\u6b21';
                    boolean bl5 = false;
                    System.out.println((Object)string7);
                    DownloadListenerBuilder downloadListenerBuilder13 = this.mDownloadListener;
                    if (downloadListenerBuilder13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("mDownloadListener");
                    }
                    Function2<DownloadMessage, Exception, Unit> function2 = downloadListenerBuilder13.getOnErrorAction$KxDownload();
                    if (function2 != null) {
                        DownloadMessage downloadMessage = this.downloadMessage;
                        if (downloadMessage == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
                        }
                        unit10 = function2.invoke(downloadMessage, e);
                    } else {
                        unit10 = null;
                    }
                }
                HttpParam httpParam = this.httpParam;
                if (httpParam == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("httpParam");
                }
                OkhttpEngine.this.startDownload(url, file, httpParam, downloadListenerBuilder);
            }
        }

        private final void calculatorDownloadSpeed() {
            this.observable = new HasDownloadedObservable();
            DownloadMessage downloadMessage = this.downloadMessage;
            if (downloadMessage == null) {
                Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
            }
            downloadMessage.setSpeed(DownloadUtil.Companion.speedToString(this.speedByte));
            HasDownloadedObservable hasDownloadedObservable = this.observable;
            if (hasDownloadedObservable != null) {
                hasDownloadedObservable.addObserver(new Observer(this){
                    final /* synthetic */ DownloadRunnable this$0;

                    public final void update(Observable $noName_0, Object $noName_1) {
                        block1: {
                            Long lastTime;
                            HasDownloadedObservable hasDownloadedObservable = DownloadRunnable.access$getObservable$p(this.this$0);
                            Long l = lastTime = hasDownloadedObservable != null ? Long.valueOf(hasDownloadedObservable.getLastTime()) : null;
                            if (l == null) break block1;
                            Long l2 = l;
                            boolean bl = false;
                            boolean bl2 = false;
                            long it = ((Number)l2).longValue();
                            boolean bl3 = false;
                            long currentTime = System.currentTimeMillis();
                            long mills = (currentTime - lastTime) / (long)1000;
                            DownloadRunnable.access$setSpeedByte$p(this.this$0, DownloadRunnable.access$getSizeRead$p(this.this$0) - DownloadRunnable.access$getLastDownload$p(this.this$0));
                            DownloadRunnable.access$setLastDownload$p(this.this$0, DownloadRunnable.access$getSizeRead$p(this.this$0));
                            if (mills != 0L) {
                                long result2 = (long)DownloadRunnable.access$getSpeedByte$p(this.this$0) / mills;
                                DownloadRunnable.access$setSpeedByte$p(this.this$0, (int)result2);
                            }
                            DownloadRunnable.access$getDownloadMessage$p(this.this$0).setSpeed(DownloadUtil.Companion.speedToString(DownloadRunnable.access$getSpeedByte$p(this.this$0)));
                        }
                    }
                    {
                        this.this$0 = downloadRunnable;
                    }
                });
            }
            OkhttpEngine.this.getSpeendThreadPool().submit(new Runnable(this){
                final /* synthetic */ DownloadRunnable this$0;

                public final void run() {
                    while (this.this$0.getTask().getDownloadStatus() == DownloadStatus.DOWNLOADING) {
                        HasDownloadedObservable hasDownloadedObservable = DownloadRunnable.access$getObservable$p(this.this$0);
                        if (hasDownloadedObservable != null) {
                            hasDownloadedObservable.change();
                        }
                        Thread.sleep(1000L);
                    }
                }
                {
                    this.this$0 = downloadRunnable;
                }
            });
        }

        private final void changeTaskStatus(DownloadStatus downloadStatus) {
            this.task.setDownloadStatus(downloadStatus);
        }

        /*
         * WARNING - void declaration
         */
        private final Request createRequest(String url, Pair<String, String> pair) {
            Request.Builder requestBuilder = new Request.Builder().url(url);
            HttpParam httpParam = this.httpParam;
            if (httpParam == null) {
                Intrinsics.throwUninitializedPropertyAccessException("httpParam");
            }
            HashMap<String, String> headerMap = httpParam.getHeaders();
            Map map2 = headerMap;
            boolean bl = false;
            boolean bl2 = false;
            if (!(map2 == null || map2.isEmpty())) {
                Map $this$forEach$iv = headerMap;
                boolean $i$f$forEach = false;
                Map map3 = $this$forEach$iv;
                boolean bl3 = false;
                Iterator iterator2 = map3.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void t;
                    Map.Entry element$iv;
                    Map.Entry $dstr$t$u = element$iv = iterator2.next();
                    boolean bl4 = false;
                    Map.Entry entry = $dstr$t$u;
                    boolean bl5 = false;
                    String string2 = (String)entry.getKey();
                    entry = $dstr$t$u;
                    bl5 = false;
                    String u = (String)entry.getValue();
                    requestBuilder.addHeader((String)t, u);
                }
            }
            if (pair != null) {
                requestBuilder.addHeader(pair.getFirst(), pair.getSecond());
            }
            return requestBuilder.build();
        }

        static /* synthetic */ Request createRequest$default(DownloadRunnable downloadRunnable, String string2, Pair pair, int n, Object object) {
            if ((n & 2) != 0) {
                pair = null;
            }
            return downloadRunnable.createRequest(string2, pair);
        }

        @NotNull
        public final DownloadTask getTask() {
            return this.task;
        }

        public DownloadRunnable(DownloadTask task2) {
            Intrinsics.checkNotNullParameter(task2, "task");
            this.task = task2;
            this.retryCount = 1;
            this.maxRetryCount = 3;
        }

        public static final /* synthetic */ HasDownloadedObservable access$getObservable$p(DownloadRunnable $this) {
            return $this.observable;
        }

        public static final /* synthetic */ void access$setObservable$p(DownloadRunnable $this, HasDownloadedObservable hasDownloadedObservable) {
            $this.observable = hasDownloadedObservable;
        }

        public static final /* synthetic */ int access$getSpeedByte$p(DownloadRunnable $this) {
            return $this.speedByte;
        }

        public static final /* synthetic */ void access$setSpeedByte$p(DownloadRunnable $this, int n) {
            $this.speedByte = n;
        }

        public static final /* synthetic */ int access$getSizeRead$p(DownloadRunnable $this) {
            return $this.sizeRead;
        }

        public static final /* synthetic */ void access$setSizeRead$p(DownloadRunnable $this, int n) {
            $this.sizeRead = n;
        }

        public static final /* synthetic */ int access$getLastDownload$p(DownloadRunnable $this) {
            return $this.lastDownload;
        }

        public static final /* synthetic */ void access$setLastDownload$p(DownloadRunnable $this, int n) {
            $this.lastDownload = n;
        }

        public static final /* synthetic */ DownloadMessage access$getDownloadMessage$p(DownloadRunnable $this) {
            DownloadMessage downloadMessage = $this.downloadMessage;
            if (downloadMessage == null) {
                Intrinsics.throwUninitializedPropertyAccessException("downloadMessage");
            }
            return downloadMessage;
        }

        public static final /* synthetic */ void access$setDownloadMessage$p(DownloadRunnable $this, DownloadMessage downloadMessage) {
            $this.downloadMessage = downloadMessage;
        }
    }
}

