/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tornadofx.AuthContext;
import tornadofx.FX;
import tornadofx.Rest;
import tornadofx.RestKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010-\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR\u001a\u0010 \u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\b\"\u0004\b\"\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\b\u00a8\u0006/"}, d2={"Ltornadofx/DigestAuthContext;", "Ltornadofx/AuthContext;", "username", "", "password", "(Ljava/lang/String;Ljava/lang/String;)V", "algorithm", "getAlgorithm", "()Ljava/lang/String;", "setAlgorithm", "(Ljava/lang/String;)V", "digest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "getDigest", "()Ljava/security/MessageDigest;", "setDigest", "(Ljava/security/MessageDigest;)V", "nonce", "getNonce", "setNonce", "nonceCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getNonceCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "opaque", "getOpaque", "setOpaque", "getPassword", "qop", "getQop", "setQop", "realm", "getRealm", "setRealm", "getUsername", "extractNextNonce", "", "response", "Ltornadofx/Rest$Response;", "generateAuthHeader", "request", "Ltornadofx/Rest$Request;", "generateCnonce", "interceptRequest", "interceptResponse", "Companion", "tornadofx"})
public final class DigestAuthContext
implements AuthContext {
    @NotNull
    private final AtomicLong nonceCounter;
    @NotNull
    private String nonce;
    @NotNull
    private String realm;
    @NotNull
    private String qop;
    @NotNull
    private String opaque;
    @NotNull
    private String algorithm;
    private MessageDigest digest;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @NotNull
    private static final List<String> QuotedStringParameters;
    public static final Companion Companion;

    @NotNull
    public final AtomicLong getNonceCounter() {
        return this.nonceCounter;
    }

    @NotNull
    public final String getNonce() {
        return this.nonce;
    }

    public final void setNonce(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull(string2, "<set-?>");
        this.nonce = string2;
    }

    @NotNull
    public final String getRealm() {
        return this.realm;
    }

    public final void setRealm(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull(string2, "<set-?>");
        this.realm = string2;
    }

    @NotNull
    public final String getQop() {
        return this.qop;
    }

    public final void setQop(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull(string2, "<set-?>");
        this.qop = string2;
    }

    @NotNull
    public final String getOpaque() {
        return this.opaque;
    }

    public final void setOpaque(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull(string2, "<set-?>");
        this.opaque = string2;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull(string2, "<set-?>");
        this.algorithm = string2;
    }

    public final MessageDigest getDigest() {
        return this.digest;
    }

    public final void setDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    @Override
    public void interceptRequest(@NotNull Rest.Request request) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        CharSequence charSequence = this.nonce;
        boolean bl = false;
        if (!StringsKt.isBlank(charSequence) && request.getHeader("Authorization") == null) {
            request.addHeader("Authorization", this.generateAuthHeader(request, null));
        }
    }

    private final String generateCnonce(MessageDigest digest) {
        return RestKt.concat(digest, String.valueOf(System.nanoTime()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Rest.Response interceptResponse(@NotNull Rest.Response response) {
        block11: {
            void $this$sortedBy$iv;
            List list2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean bl;
            Object object;
            Map<String, String> params;
            block12: {
                Intrinsics.checkParameterIsNotNull(response, "response");
                this.extractNextNonce(response);
                if (response.getStatusCode() != 401 || response.getRequest().getProperties().get("Authorization-Retried") != null) {
                    return response;
                }
                params = RestKt.getDigestParams(response);
                if (params == null) break block11;
                String string2 = params.get("stale");
                if (string2 == null) break block12;
                object = string2;
                bl = false;
                if (!Boolean.parseBoolean((String)object)) break block11;
            }
            FX.Companion.getLog().fine(new Supplier<String>(params){
                final /* synthetic */ Map $params;

                @NotNull
                public final String get() {
                    return "Digest Challenge: " + this.$params;
                }
                {
                    this.$params = map2;
                }
            });
            String string3 = params.get("algorithm");
            if (string3 == null) {
                string3 = "MD5";
            }
            this.algorithm = string3;
            this.digest = MessageDigest.getInstance(StringsKt.removeSuffix(this.algorithm, (CharSequence)"-sess"));
            String string4 = params.get("realm");
            if (string4 == null) {
                object = "Realm is not present in response digest parameters";
                DigestAuthContext digestAuthContext = this;
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            this.realm = string4;
            String string5 = params.get("nonce");
            if (string5 == null) {
                object = "Nonce is not present in response digest parameters";
                DigestAuthContext digestAuthContext = this;
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            this.nonce = string5;
            String string6 = params.get("opaque");
            if (string6 == null) {
                string6 = "";
            }
            this.opaque = string6;
            this.nonceCounter.set(0L);
            String string7 = params.get("qop");
            if (string7 == null) {
                string7 = "";
            }
            object = StringsKt.split$default((CharSequence)string7, new String[]{","}, false, 0, 6, null);
            DigestAuthContext digestAuthContext = this;
            boolean $i$f$map = false;
            void var5_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string8 = (String)item$iv$iv;
                list2 = destination$iv$iv;
                boolean bl2 = false;
                void var12_17 = p1;
                boolean bl3 = false;
                void v6 = var12_17;
                if (v6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string9 = ((Object)StringsKt.trim((CharSequence)v6)).toString();
                list2.add(string9);
            }
            list2 = (List)destination$iv$iv;
            $this$map$iv = list2;
            boolean $i$f$sortedBy = false;
            var5_8 = $this$sortedBy$iv;
            boolean bl4 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    String it = (String)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.length());
                    it = (String)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.length();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)n);
                }
            };
            list2 = CollectionsKt.sortedWith(var5_8, comparator);
            digestAuthContext.qop = (String)CollectionsKt.last(list2);
            Rest.Request request = response.getRequest();
            request.reset();
            request.addHeader("Authorization", this.generateAuthHeader(request, response));
            request.getProperties().put("Authorization-Retried", true);
            return request.execute();
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final void extractNextNonce(Rest.Response response) {
        String authInfo = response.header("Authentication-Info");
        if (authInfo != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = StringsKt.split$default((CharSequence)authInfo, new String[]{","}, false, 0, 6, null);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                void name;
                Map map2 = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Object object = new String[]{"="};
                boolean bl2 = false;
                int n = 2;
                List list2 = StringsKt.split$default((CharSequence)it, (String[])object, bl2, n, 2, null);
                object = list2;
                bl2 = false;
                String string2 = (String)object.get(0);
                object = list2;
                bl2 = false;
                String value = (String)object.get(1);
                Pair<void, String> pair = TuplesKt.to(name, value);
                boolean bl3 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map params = destination$iv$iv;
            String nextNonce = (String)params.get("nextnonce");
            if (nextNonce != null) {
                this.nonceCounter.set(0L);
                this.nonce = nextNonce;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final String generateAuthHeader(Rest.Request request, Rest.Response response) {
        block14: {
            v0 = this.digest;
            Intrinsics.checkExpressionValueIsNotNull(v0, "digest");
            cnonce = this.generateCnonce(v0);
            path = request.getUri().getPath();
            v1 = Integer.toHexString((int)this.nonceCounter.incrementAndGet());
            Intrinsics.checkExpressionValueIsNotNull(v1, "Integer.toHexString(nonc\u2026ncrementAndGet().toInt())");
            nc = StringsKt.padStart(v1, 8, '0');
            var7_6 = this.algorithm;
            switch (var7_6.hashCode()) {
                case -1459419359: {
                    if (var7_6.equals("MD5-sess")) {
                        v2 = this.digest;
                        Intrinsics.checkExpressionValueIsNotNull(v2, "digest");
                        v3 = new String[3];
                        v4 = this.digest;
                        Intrinsics.checkExpressionValueIsNotNull(v4, "digest");
                        v3[0] = RestKt.concat(v4, new String[]{this.username, this.realm, this.password});
                        v3[1] = this.nonce;
                        v3[2] = cnonce;
                        v5 = RestKt.concat(v2, v3);
                        break;
                    }
                }
                default: {
                    v6 = this.digest;
                    Intrinsics.checkExpressionValueIsNotNull(v6, "digest");
                    v5 = RestKt.concat(v6, new String[]{this.username, this.realm, this.password});
                }
            }
            ha1 = v5;
            var8_8 = this.qop;
            switch (var8_8.hashCode()) {
                case 1431098954: {
                    if (var8_8.equals("auth-int")) {
                        v7 = this.digest;
                        Intrinsics.checkExpressionValueIsNotNull(v7, "digest");
                        v8 = new String[3];
                        v8[0] = request.getMethod().name();
                        v9 = path;
                        Intrinsics.checkExpressionValueIsNotNull(v9, "path");
                        v8[1] = v9;
                        v10 = this.digest;
                        Intrinsics.checkExpressionValueIsNotNull(v10, "digest");
                        v11 = new String[1];
                        v12 = response;
                        if (v12 == null || (v12 = v12.text()) == null) {
                            v12 = "";
                        }
                        v11[0] = v12;
                        v8[2] = RestKt.concat(v10, v11);
                        v13 = RestKt.concat(v7, v8);
                        break;
                    }
                }
                default: {
                    v14 = this.digest;
                    Intrinsics.checkExpressionValueIsNotNull(v14, "digest");
                    v15 = new String[2];
                    v15[0] = request.getMethod().name();
                    v16 = path;
                    Intrinsics.checkExpressionValueIsNotNull(v16, "path");
                    v15[1] = v16;
                    v13 = RestKt.concat(v14, v15);
                }
            }
            ha2 = v13;
            var9_9 = this.qop;
            switch (var9_9.hashCode()) {
                case 3005864: {
                    if (!var9_9.equals("auth")) break;
                    ** GOTO lbl65
                }
                case 1431098954: {
                    if (!var9_9.equals("auth-int")) break;
lbl65:
                    // 2 sources

                    v17 = this.digest;
                    Intrinsics.checkExpressionValueIsNotNull(v17, "digest");
                    v18 = RestKt.concat(v17, new String[]{ha1, this.nonce, String.valueOf(this.nonceCounter.incrementAndGet()), cnonce, this.qop, ha2});
                    break block14;
                }
            }
            v19 = this.digest;
            Intrinsics.checkExpressionValueIsNotNull(v19, "digest");
            v18 = RestKt.concat(v19, new String[]{ha1, this.nonce, ha2});
        }
        encoded = v18;
        var11_10 = authParams = MapsKt.mapOf(new Pair[]{TuplesKt.to("username", this.username), TuplesKt.to("realm", this.realm), TuplesKt.to("nonce", this.nonce), TuplesKt.to("uri", path), TuplesKt.to("response", encoded), TuplesKt.to("opaque", this.opaque), TuplesKt.to("algorithm", this.algorithm), TuplesKt.to("nc", nc)});
        var23_11 = new StringBuilder().append("Digest ");
        $i$f$map = false;
        var13_13 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
        $i$f$mapTo = false;
        var16_16 = $this$mapTo$iv$iv;
        var17_17 = false;
        var18_18 = var16_16.entrySet().iterator();
        while (var18_18.hasNext()) {
            var20_20 = item$iv$iv = var18_18.next();
            var24_23 = destination$iv$iv;
            $i$a$-map-DigestAuthContext$generateAuthHeader$header$1 = false;
            q = DigestAuthContext.QuotedStringParameters.contains(it.getKey()) != false ? "\"" : "";
            var25_24 = (String)it.getKey() + '=' + q + (String)it.getValue() + q;
            var24_23.add(var25_24);
        }
        var24_23 = (List)destination$iv$iv;
        header = var23_11.append(CollectionsKt.joinToString$default(var24_23, null, null, null, 0, null, null, 63, null)).toString();
        FX.Companion.getLog().fine(new Supplier<String>(header){
            final /* synthetic */ String $header;

            @NotNull
            public final String get() {
                return "Digest Response: " + this.$header;
            }
            {
                this.$header = string2;
            }
        });
        return header;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public DigestAuthContext(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull(username, "username");
        Intrinsics.checkParameterIsNotNull(password, "password");
        this.username = username;
        this.password = password;
        this.nonceCounter = new AtomicLong(0L);
        this.nonce = "";
        this.realm = "";
        this.qop = "";
        this.opaque = "";
        this.algorithm = "";
        this.digest = MessageDigest.getInstance("MD5");
    }

    static {
        Companion = new Companion(null);
        QuotedStringParameters = CollectionsKt.listOf("username", "realm", "nonce", "uri", "response", "cnonce", "opaque");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltornadofx/DigestAuthContext$Companion;", "", "()V", "QuotedStringParameters", "", "", "getQuotedStringParameters", "()Ljava/util/List;", "tornadofx"})
    public static final class Companion {
        @NotNull
        public final List<String> getQuotedStringParameters() {
            return QuotedStringParameters;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

