/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import tornadofx.KeyboardKey;
import tornadofx.KeyboardLayout;
import tornadofx.KeyboardRow;
import tornadofx.SpacerKeyboardKey;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J0\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J0\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J0\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0014J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Ltornadofx/KeyboardSkin;", "Ljavafx/scene/control/SkinBase;", "Ltornadofx/KeyboardLayout;", "control", "(Ltornadofx/KeyboardLayout;)V", "keyboard", "getKeyboard", "()Ltornadofx/KeyboardLayout;", "computeMinHeight", "", "width", "topInset", "rightInset", "bottomInset", "leftInset", "computeMinWidth", "height", "computePrefHeight", "computePrefWidth", "layoutChildren", "", "contentX", "contentY", "contentWidth", "contentHeight", "tornadofx"})
public final class KeyboardSkin
extends SkinBase<KeyboardLayout> {
    @NotNull
    private final KeyboardLayout keyboard;

    @NotNull
    public final KeyboardLayout getKeyboard() {
        return this.keyboard;
    }

    /*
     * WARNING - void declaration
     */
    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        Ref.DoubleRef doubleRef = new Ref.DoubleRef();
        double currentY = contentY;
        ObservableList<KeyboardRow> observableList = this.keyboard.getRows();
        Intrinsics.checkExpressionValueIsNotNull(observableList, "keyboard.rows");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<Double> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KeyboardRow row2 = (KeyboardRow)element$iv;
            boolean bl = false;
            doubleRef.element = contentX;
            ObservableList<KeyboardKey> observableList2 = row2.getKeys();
            Intrinsics.checkExpressionValueIsNotNull(observableList2, "row.keys");
            Iterable $this$forEach$iv2 = (Iterable)observableList2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KeyboardKey key2 = (KeyboardKey)((Object)element$iv2);
                boolean bl2 = false;
                if (!(key2 instanceof SpacerKeyboardKey)) {
                    double d = doubleRef.element;
                    KeyboardKey keyboardKey = key2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)keyboardKey, "key");
                    key2.resizeRelocate(d, currentY, keyboardKey.getPrefWidth(), key2.getPrefHeight());
                }
                doubleRef.element += key2.getPrefWidth();
            }
            ObservableList<KeyboardKey> observableList3 = row2.getKeys();
            Intrinsics.checkExpressionValueIsNotNull(observableList3, "row.keys");
            $this$forEach$iv2 = (Collection)observableList3;
            $i$f$forEach2 = false;
            if (!(!$this$forEach$iv2.isEmpty())) continue;
            ObservableList<KeyboardKey> observableList4 = row2.getKeys();
            Intrinsics.checkExpressionValueIsNotNull(observableList4, "row.keys");
            $this$forEach$iv2 = (Iterable)observableList4;
            double d = currentY;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KeyboardKey keyboardKey = (KeyboardKey)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl3 = false;
                Double d2 = it.prefHeight(-1.0);
                collection.add(d2);
            }
            collection = (List)destination$iv$iv;
            Object t = CollectionsKt.min((Iterable)collection);
            currentY = d + (t != null ? (Double)t : 0.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        ObservableList<KeyboardRow> observableList = this.keyboard.getRows();
        Intrinsics.checkExpressionValueIsNotNull(observableList, "keyboard.rows");
        Iterable $this$sumByDouble$iv = (Iterable)observableList;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            double d;
            void row2;
            KeyboardRow keyboardRow = (KeyboardRow)element$iv;
            double d2 = sum$iv;
            boolean bl = false;
            if (row2.getKeys().isEmpty()) {
                d = 0.0;
            } else {
                void $this$mapTo$iv$iv;
                ObservableList<KeyboardKey> observableList2 = row2.getKeys();
                Intrinsics.checkExpressionValueIsNotNull(observableList2, "row.keys");
                Iterable $this$map$iv = (Iterable)observableList2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KeyboardKey keyboardKey = (KeyboardKey)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Double d3 = it.prefHeight(width);
                    collection.add(d3);
                }
                Object t = CollectionsKt.min((List)destination$iv$iv);
                d = t != null ? (Double)t : 0.0;
            }
            double d4 = d;
            sum$iv = d2 + d4;
        }
        return sum$iv + topInset + bottomInset;
    }

    /*
     * WARNING - void declaration
     */
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        void $this$mapTo$iv$iv;
        ObservableList<KeyboardRow> observableList = this.keyboard.getRows();
        Intrinsics.checkExpressionValueIsNotNull(observableList, "keyboard.rows");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d;
            void row2;
            KeyboardRow keyboardRow = (KeyboardRow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (row2.getKeys().isEmpty()) {
                d = 0.0;
            } else {
                ObservableList<KeyboardKey> observableList2 = row2.getKeys();
                Intrinsics.checkExpressionValueIsNotNull(observableList2, "row.keys");
                Iterable $this$sumByDouble$iv = (Iterable)observableList2;
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (Object element$iv : $this$sumByDouble$iv) {
                    void it;
                    KeyboardKey keyboardKey = (KeyboardKey)((Object)element$iv);
                    double d2 = sum$iv;
                    boolean bl2 = false;
                    double d3 = it.prefWidth(height);
                    sum$iv = d2 + d3;
                }
                d = sum$iv;
            }
            Double d4 = d;
            collection.add(d4);
        }
        Object t = CollectionsKt.max((List)destination$iv$iv);
        return (t != null ? (Double)t : 0.0) + leftInset + rightInset;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    public KeyboardSkin(@NotNull KeyboardLayout control) {
        Intrinsics.checkParameterIsNotNull((Object)control, "control");
        super((Control)control);
        this.keyboard = control;
    }
}

