local assets=
{
	Asset("ANIM", "anim/octopus.zip"),
	Asset("MINIMAP_IMAGE", "octopus"),
}

local specialoot = 
{
	specialoot1 = 1,
	specialoot2 = 1,
	specialoot3 = 1,
	specialoot4 = 1,
	specialoot5 = 1,
	specialoot6 = 1,
}

local specialoot1 =
{
	"seaweed",
	"seaweed",
	"seaweed",
	"seaweed",
	"seaweed",
	"coral",
	"coral",
	"blubber",
}

local specialoot2 =
{
	"seashell",
	"seashell",
	"seashell",
	"seashell",
	"seashell",
	"tropical_fish",
	"tropical_fish",
	"shark_fin",
}

local specialoot3 =
{
	"coral",
	"coral",
	"coral",
	"coral",
	"coral",
	"fish",
	"fish",
	"coral_brain",
}

local specialoot4 =
{
	"goldnugget",
	"goldnugget",
	"goldnugget",
	"goldnugget",
	"goldnugget",
	"fish_med",
	"fish_med",
	"bluegem",
}

local specialoot5 =
{
	"goldnugget",
	"goldnugget",
	"goldnugget",
	"goldnugget",
	"goldnugget",
	"fish_med",
	"fish_med",
	"redgem",
}

local specialoot6 =
{
	"limpets",
	"limpets",
	"limpets",
	"limpets",
	"limpets",
	"lobster_dead",
	"lobster_dead",
	"dead_swordfish",
}

local specialoot7 =
{
	"mussel",
	"mussel",
	"mussel",
	"mussel",
	"mussel",
	"eel",
	"eel",
	"dragoonheart",
}

local specialoot8 =
{
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"obsidian",
	"obsidian",
	"greengem",
}

local specialoot9 =
{
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"obsidian",
	"obsidian",
	"obsidian",
	"orangegem",
}

local specialoot10 =
{
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"nightmarefuel",
	"obsidian",
	"obsidian",
	"yellowgem",
}

local randomchestloot = 
{
	"seaweed",
	"seaweed",
	"seaweed",
	"seaweed",
	"seaweed",
	"seashell",
	"seashell",
	"seashell",
	"coral",
	"coral",
	"coral",
	"shark_fin",
	"blubber",
}

local chestloot =
{
	californiaroll = "sail",
	seafoodgumbo = "clothsail",
	bisque = "trawlnet",
	jellyopop = "seatrap",
	ceviche = "telescope",
	surfnturf = "boat_lantern",
	lobsterbisque = "piratehat",
	lobsterdinner = "boatcannon",
}

-- only accept 1 trinket per day and pull up a chest that has multiple  dubloons + items (that we set per trinket)
-- only accept 1 seafood meal per day and pull up a chest with 1 dubloon + rando cheap items that come from a loot list
-- only accept 1 seafood crockpot meal per day and pull up a chest that has 1 dubloon + items (that we set per dish)

local function StartTrading(inst)
	if not inst.components.trader.enabled then
		inst.components.trader:Enable()
		inst.AnimState:PlayAnimation("sleep_pst")
		inst.AnimState:PushAnimation("idle", true)

		inst:RemoveEventCallback("animover", inst.sleepfn)
	end
end

local function FinishedTrading(inst)
	inst.components.trader:Disable()
	inst.AnimState:PlayAnimation("sleep_pre")

	if inst.sleepfn then
		inst:RemoveEventCallback("animover", inst.sleepfn)
	end
	
	inst.sleepfn = function(inst)
		inst.AnimState:PlayAnimation("sleep_loop")
		inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/octopus_king/sleep")
	end

	inst:ListenForEvent("animover", inst.sleepfn)
end

-- chest style
local function OnGetItemFromPlayer(inst, giver, item)	
	local istrinket = item:HasTag("trinket") -- cache this, the item is destroyed by the time the reward is created.
	inst.components.trader:Disable()
	inst.AnimState:PlayAnimation("happy")
	inst.AnimState:PushAnimation("grabchest")
	inst.AnimState:PushAnimation("idle", true)
	inst:DoTaskInTime(13*FRAMES, function(inst)	inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/octopus_king/happy") end)
	inst:DoTaskInTime(53*FRAMES, function(inst)	inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/octopus_king/tenticle_out_water") end)
	inst:DoTaskInTime(71*FRAMES, function(inst)	inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/octopus_king/tenticle_in_water") end)
	inst:DoTaskInTime(78*FRAMES, function(inst)	inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/seacreature_movement/splash_small") end)
	inst:DoTaskInTime(109*FRAMES, function(inst)
		inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/octopus_king/tenticle_out_water")
		local down = TheCamera:GetDownVec()
		local spawnangle = math.atan2(down.z, down.x) + -50*DEGREES
		local angle = math.atan2(down.z, down.x) + (math.random()*60-30)*DEGREES
		local sp = math.random()*3+2		
		local chest = SpawnPrefab("octopuschest")
		local pt = Vector3(inst.Transform:GetWorldPosition()) + Vector3(2*math.cos(spawnangle), 2, 2*math.sin(spawnangle))
		chest.Transform:SetPosition(pt:Get())
		chest.Physics:SetVel(sp*math.cos(angle), math.random()*2+9, sp*math.sin(angle))
		chest.components.inventoryitem:OnStartFalling()
		chest.AnimState:PlayAnimation("air_loop", true)
		chest.components.floatable:SetOnHitWaterFn(function()
			chest.AnimState:PlayAnimation("land")
			chest.AnimState:PushAnimation("closed", true)
		end)
		if not istrinket then
			local single = SpawnPrefab("dubloon")
			chest.components.container:GiveItem(single, nil, nil, true, false)
			if chestloot[item.prefab] then
				local goodreward = SpawnPrefab(chestloot[item.prefab])
				chest.components.container:GiveItem(goodreward, nil, nil, true, false)
			else
				local dubloonvalue = math.min(item.components.tradable.dubloonvalue, 2)
				for i = 1, dubloonvalue do
					local loot = SpawnPrefab(randomchestloot[math.random(1, #randomchestloot)])
					chest.components.container:GiveItem(loot, nil, nil, true, false)
				end
			end
		else
			local list = math.random(1,7)
			local lootlist = specialoot1 
			if list == 1 then lootlist = specialoot1
			elseif list == 2 then lootlist = specialoot2
			elseif list == 3 then lootlist = specialoot3
			elseif list == 4 then lootlist = specialoot4
			elseif list == 5 then lootlist = specialoot5
			elseif list == 6 then lootlist = specialoot6
			elseif list == 7 then lootlist = specialoot7
			end
			if math.random() > 0.95 then
				list = math.random(8,10)
				if list == 8 then lootlist = specialoot8
				elseif list == 9 then lootlist = specialoot9
				elseif list == 10 then lootlist = specialoot10
				end
			end		
			local amount = item.components.tradable.dubloonvalue + math.random(0,item.components.tradable.dubloonvalue)
			for i = 1, amount do
				local loot = SpawnPrefab("dubloon")
				chest.components.container:GiveItem(loot, nil, nil, true, false)
				if math.random() > 0.55 then
					loot = SpawnPrefab(lootlist[math.random(1, #lootlist)])
					chest.components.container:GiveItem(loot, nil, nil, true, false)
				end	
			end
		end
		if not TheSim:FindFirstEntityWithTag("woodlegs_key2") and not Profile:IsCharacterUnlocked("woodlegs") then
			if math.random() < 0.1 then
	        	local loot = SpawnPrefab("woodlegs_key2")
	        	chest.components.container:GiveItem(loot, nil, nil, true, false)
	        end
        end
	end)
		inst.happy = true
	if inst.endhappytask then
		inst.endhappytask:Cancel()
	end
	inst.endhappytask = inst:DoTaskInTime(5, function(inst)
		inst.happy = false
		inst.endhappytask = nil
		inst.components.trader:Enable()
		--FinishedTrading(inst)
	end)
end

local function OnRefuseItem(inst, giver, item)
	inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/octopus_king/reject")
	inst.AnimState:PlayAnimation("unimpressed")
	inst.AnimState:PushAnimation("idle", true)
	inst.happy = false
end

local function OnLoad(inst,data)
	if not inst.components.trader.enabled then
		FinishedTrading(inst)
	end
end

local function fn(Sim)
	
	local inst = CreateEntity()

	inst.OnLoad = OnLoad

	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetPriority( 5 )
	minimap:SetIcon( "octopus.png" )
	minimap:SetPriority( 1 )

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 10, 5 )
	
	MakeObstaclePhysics(inst, 2, .5)
	
	inst:AddTag("king")
	inst.AnimState:SetBank("octopus")
	inst.AnimState:SetBuild("octopus")
	inst.AnimState:PlayAnimation("idle", true)

	inst:AddComponent("inspectable")

	inst:AddComponent("trader")

	inst.components.trader:SetAcceptTest(
		function(inst, item)
			return (item.components.tradable.dubloonvalue and item.components.tradable.dubloonvalue > 0) or chestloot[item.prefab] ~= nil
		end)

	inst.components.trader.onaccept = OnGetItemFromPlayer
	inst.components.trader.onrefuse = OnRefuseItem

	inst:ListenForEvent( "nighttime", function(global, data)  
		FinishedTrading(inst)
	end, GetWorld())
	
	inst:ListenForEvent( "daytime", function(global, data)
		StartTrading(inst)
	end, GetWorld())
	
	return inst
end

return Prefab( "common/objects/octopusking", fn, assets, prefabs) 
