local assets =
{	
	Asset("ANIM", "anim/bloodsword.zip"),
	Asset("ANIM", "anim/swap_bloodsword.zip"),
	Asset ("ATLAS", "images/inventoryimages/bloodsword.xml")
}

local function onfinished(inst)
	inst:Remove()
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_bloodsword", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

--Sacrifice Life
local function onattack(inst, owner, target)
	owner.components.health:DoDelta(2.5)
	
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()	
    MakeInventoryPhysics(inst)
    
    anim:SetBank("nightmaresword")
    anim:SetBuild("bloodsword")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE *1.5)
	inst.components.weapon.onattack = onattack

    -------
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
    inst.components.finiteuses:SetOnFinished( onfinished)
    -------
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/bloodsword.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip)

    
    return inst
end

return Prefab( "common/inventory/bloodsword", fn, assets)