
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/seras.zip" ),
		Asset( "ANIM", "anim/seras_fed.zip" ),
		Asset( "ANIM", "anim/seras_starved.zip" ),
		Asset( "ANIM", "anim/seras_sunlight.zip" ),
		Asset( "ANIM", "anim/seras_nightmare.zip" ),
}
local prefabs = {}


--starregen parameters: first parameter = tick size. second parameter = tick frequency

-- stat differences night/day
local function updatestats(inst)
	local health_percent = inst.components.health:GetPercent()

    if GetClock():IsDay() then
		if inst.strength == "mighty" then
			
			inst.components.health.maxhealth = 160
			inst.components.health:StopRegen()
			inst.components.combat.damagemultiplier = 1
			inst.components.hunger:SetRate(1.5*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
			inst.components.temperature.inherentinsulation = 30*6
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1)
			inst.AnimState:SetBuild("seras")
		elseif inst.strength == "normal" then
			inst.components.health.maxhealth = 120
			inst.components.health:StopRegen()
			inst.components.combat.damagemultiplier = 0.8
			inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)	
			inst.components.sanity.dapperness = 0
			inst.components.temperature.inherentinsulation = 30*4
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.3)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)
			inst.AnimState:SetBuild("seras_sunlight")
		elseif inst.strength == "wimpy" then
			inst.components.health.maxhealth = 60
			inst.components.health:StopRegen()
			inst.components.combat.damagemultiplier = 0.4
			inst.components.hunger:SetRate(0.5*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL*-1
			inst.components.temperature.inherentinsulation = 30*2
			inst.AnimState:SetBuild("seras_starved")
			
		end		
		inst.components.health:SetPercent(health_percent)
		inst.Light:Enable(false)
		
	elseif GetClock():IsDusk() then
        if inst.strength == "mighty" then
			inst.components.health.maxhealth = 250 
			inst.components.health:StartRegen(1, 5) 			--regeneration speed 1hp/ 3sec
			inst.components.combat.damagemultiplier = 1.5
			inst.components.hunger:SetRate(1*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
			inst.components.temperature.inherentinsulation = 30*6
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.3)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)
			inst.AnimState:SetBuild("seras_fed")
		elseif inst.strength == "normal" then
			inst.components.health.maxhealth = 	200
			inst.components.health:StopRegen()
			inst.components.combat.damagemultiplier = 1.2
			inst.components.hunger:SetRate(0.5*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = 0
			inst.components.temperature.inherentinsulation = 30*4
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1)
			inst.AnimState:SetBuild("seras")
		elseif inst.strength == "wimpy" then
			inst.components.health.maxhealth = 70
			inst.components.health:StopRegen()
			inst.components.combat.damagemultiplier = 0.7
			inst.components.hunger:SetRate(0.3*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = TUNING.DAPPERNESS_MED*-1
			inst.components.temperature.inherentinsulation = 30*2
			inst.AnimState:SetBuild("seras_starved")
			
		end
		inst.components.health:SetPercent(health_percent)
		inst.Light:Enable(false)
		
    elseif GetClock():IsNight() then
		if GetClock():GetMoonPhase() == "full" then
			inst.components.health.maxhealth = 500
			inst.components.health:StartRegen(2, 0.5) 			--regeneration speed 2hp/ 1sec
			inst.components.combat.damagemultiplier = 1.5
			inst.components.hunger:SetRate(-5*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = TUNING.DAPPERNESS_HUGE*-5
			inst.components.temperature.inherentinsulation = 30*20
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.8)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.8)
			inst.AnimState:SetBuild("seras_nightmare")
			
        elseif inst.strength == "mighty" then
			inst.components.health.maxhealth = 260
			inst.components.health:StartRegen(1, 2) 			--regeneration speed 1hp/ 2sec
			inst.components.combat.damagemultiplier = 2.0
			inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
			inst.components.temperature.inherentinsulation = 30*6
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.4)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.4)
			inst.AnimState:SetBuild("seras_fed")
		elseif inst.strength == "normal" then
			inst.components.health.maxhealth = 250		
			inst.components.health:StartRegen(1, 3) 			--regeneration speed 1hp/ 3sec
			inst.components.combat.damagemultiplier = 1.5
			inst.components.hunger:SetRate(0.5*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = 0
			inst.components.temperature.inherentinsulation = 30*4
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.3)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)
			inst.AnimState:SetBuild("seras_fed")
		elseif inst.strength == "wimpy" then
			inst.components.health.maxhealth = 80
			inst.components.health:StopRegen()
			inst.components.combat.damagemultiplier = 1.1
			inst.components.hunger:SetRate(0.3*TUNING.WILSON_HUNGER_RATE)
			inst.components.sanity.dapperness = TUNING.DAPPERNESS_LARGE*-1
			inst.components.temperature.inherentinsulation = 30*2
			inst.AnimState:SetBuild("seras_starved")
			
		end
		inst.components.health:SetPercent(health_percent)
		inst.Light:Enable(true)
		

    end
	
	
	--[[
		--update model
	if inst.strength == "mighty" then
		if GetClock():IsDay() then
			inst.AnimState:SetBuild("seras")
		else
			inst.AnimState:SetBuild("seras_fed")
		end
		
	elseif inst.strength == "normal" then
		if GetClock():IsDay() then
			inst.AnimState:SetBuild("seras_sunlight")
		else
			inst.AnimState:SetBuild("seras")
		end
	
	elseif inst.strength == "wimpy" then
		if GetClock():IsDay() then
			inst.AnimState:SetBuild("seras_starved")
		else
			inst.AnimState:SetBuild("seras_starved")
		end
		
	end
	--]]

end

local function onhungerchange(inst, data)

	if inst.strength == "mighty" then
		if inst.components.hunger.current < 130 then
			
			inst.strength = "normal"
			inst.components.talker:Say("ֻܿ...")

		end
	elseif inst.strength == "wimpy" then
		if inst.components.hunger.current > 60 then

			inst.strength = "normal"
			inst.components.talker:Say(",!")

		end
	else
		if inst.components.hunger.current > 145 then
			inst.strength = "mighty"
			inst.components.talker:Say("Ҹо!")


		elseif inst.components.hunger.current < 55 then
			inst.strength = "wimpy"
			inst.components.talker:Say("ҵѪҺɺ...ʹ.")

		end
	end
	
	
	updatestats(inst)
end


local fn = function(inst)

	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wendy.png" )

	-- default hunger level
	inst.strength = "normal"
	inst.components.hunger.current = 125
	
	-- Emit light at night
	local light = inst.entity:AddLight()
    inst.Light:Enable(false)
	inst.Light:SetRadius(10)
    inst.Light:SetFalloff(0.75)
    inst.Light:SetIntensity(.6)
    inst.Light:SetColour(235/255,12/255,12/255)
	
	-- Stats varies day/night
	inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
    inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
    updatestats(inst)
	
	-- Sanity Changes
	inst.components.sanity.night_drain_mult = 0.5
	inst.components.sanity.neg_aura_mult = 1.1
	inst.components.sanity:SetMax(TUNING.WILLOW_SANITY)
		
	
	--Update hunger status
	inst:ListenForEvent("hungerdelta", onhungerchange)
	
	--Carnivore, can only eat meat. Can Eat Monster Meat.
	inst.components.eater:SetCarnivore()
	inst.components.eater.strongstomach = true

	

	
    return inst
	
end
	
	


-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.seras = "ѪŮ"
STRINGS.CHARACTER_NAMES.seras = "˹.ά"
STRINGS.CHARACTER_DESCRIPTIONS.seras = "*ӵ   Ѫ     \n*       \n*   ʳ  ʳ "
STRINGS.CHARACTER_QUOTES.seras = "\"     һ   \""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.SERAS = {}
STRINGS.CHARACTERS.SERAS.ACTIONFAIL_GENERIC  = "     "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_ADVENTUREFAIL  = "       "

ANNOUNCE_BOOMERANG  = "   Ӧ  ץ ס  "
ANNOUNCE_CHARLIE  = "  ʲ ô  "
ANNOUNCE_CHARLIE_ATTACK = "    ҧ    "
ANNOUNCE_MOSQUITOS  = "     "

STRINGS.CHARACTERS.SERAS.ANNOUNCE_COLD  = "       "
ANNOUNCE_CRAFTING_FAIL  = "  ӵ     "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_DUSK = "          "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_CRAFTING_FAIL  = "  û    Ҫ   Դ  "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_Hungry  = "     ̫    "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_HUNT_BEAST_NEARBY = "       "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_HUNT_LOST_TRAIL  = "    ʧ ȥ      "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_INV_FULL  = " װ     "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_KNOCKEDOUT  = "  "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_NODANGERSLEEP  = "       ˯       "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_NOHUNGERSLEEP  = "     ˯       "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_NODAYSLEEP  = " ϣ        û  һ         ̫      "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_NO_TRAP  = "      "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_PECKED  = "   ס   "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_QUAKE = "ʲ ô   "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_RESEARCH  = " ѧ   һ Щ    "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_THORNS  = "     ̫    "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_TORCH_OUT  = "     "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_TRAP_WENT_OFF  = "  ˹  "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_WORMHOLE  = "             "

STRINGS.CHARACTERS.SERAS.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.SERAS.ANNOUNCE_EAT.GENERIC  = " ζ  ̫    "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_EAT.PAINFULL = "ζ  ̫     "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_EAT.SPOILED = " Ѫ Һ  ʪ   "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_EAT.STALE  = "    "


-- Battle
STRINGS.CHARACTERS.SERAS.ANNOUNCE_HOUNDS  = "      Ȯ "
STRINGS.CHARACTERS.SERAS.ANNOUNCE_DEERCLOPS  = "   ʲ ô  һ      "

STRINGS.CHARACTERS.SERAS.BATTLECRY = {}
STRINGS.CHARACTERS.SERAS.BATTLECRY.GENERIC  = "     ŭ   "
STRINGS.CHARACTERS.SERAS.BATTLECRY.PIG = "ҧ   "
STRINGS.CHARACTERS.SERAS.BATTLECRY.PREY  = "       "
STRINGS.CHARACTERS.SERAS.BATTLECRY.SPIDER  = "        ̿ "
STRINGS.CHARACTERS.SERAS.BATTLECRY.SPIDER_WARRIOR  = "  ȥ   "
STRINGS.CHARACTERS.SERAS.BATTLECRY.HOUND  = "Ѫ     ͷ "
STRINGS.CHARACTERS.SERAS.BATTLECRY.LEIF  = " Ҫ   ȥ    "

STRINGS.CHARACTERS.SERAS.COMBAT_QUIT = {}
STRINGS.CHARACTERS.SERAS.COMBAT_QUIT.GENERIC  = " Ҳ        "
STRINGS.CHARACTERS.SERAS.COMBAT_QUIT.PIG = "     "
STRINGS.CHARACTERS.SERAS.COMBAT_QUIT.PREY  = "     "
STRINGS.CHARACTERS.SERAS.COMBAT_QUIT.SPIDER  = "       "
STRINGS.CHARACTERS.SERAS.COMBAT_QUIT.SPIDER_WARRIOR  = "   ׷  "

-- Description
STRINGS.CHARACTERS.SERAS.DESCRIBE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.SLURPER  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ORANGEAMULET  = "   ̬       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.YELLOWSTAFF  = "ĳ   ʽ   Ӱ ħ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.YELLOWGEM  = "һ    ʯ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ORANGEGEM  = "һ    ʯ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STAFFLIGHT  = "    Σ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RESEARCHLAB4  = " Ŷ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ANCIENT_ALTAR  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAVE_BANANA  = "    һ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAVE_BANANA_COOKED  = "  û    ը    ϣ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.Cave_BANANA_TREE  = "      û       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCKY  = "  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.GENERIC  = " ĳ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.N  = " " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.S  = " " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.E  = " " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.W  = " " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.NE  = "  " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.SE  = "  " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.NW  = "  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COMPASS.SW  = "  " 

STRINGS.CHARACTERS.SERAS.DESCRIBE.HOUNDSTOOTH  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ARMORSNURTLESHELL  = "ϣ  û     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BAT = " Ѫ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BATBAT  = "ǡ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BATWING  = " Щ    ĳ   Ѫ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BATWING_COOKED = " ֪       ȫ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEDROLL_FURRY = "    ǡ"
STRINGS.CHARACTERS.SERAS.DESCRIBE.BUNNYMAN = " ͦ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FLOWER_CAVE  = "                 "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FLOWER_CAVE_DOUBLE  = "                 "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FLOWER_CAVE_TRIPLE  = "                 "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GUANO = "   ̫    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LANTERN  = "һ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LIGHTBULB  = "                 "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MANRABBIT_TAIL  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MUSHTREE_TALL  = "       ˿   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.MUSHTREE_MEDIUM  = "    Ģ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MUSHTREE_SMALL = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RABBITHOUSE  = "   ʵ  ̫     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SLURTLE = "  ë "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SLURTLE_SHELLPIECES  = "Ϊ ʲ ô  Ҫ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SLURTLEHAT  = "    һ  ʿ   ͷ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SLURTLEHOLE  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SLURTLESLIME  = "   ˹       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SNURTLE = "ճ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER_HIDER  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER_SPITTER  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDERHOLE = "а    Ѩ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE  = "  һ     ʯ ͷ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE_FULL  = "ʯ ͷ   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE_LOW  = "ʯ ͷ   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE_MED  = "ʯ ͷ   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE_TALL  = "  һ     ʯ ͷ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE_TALL_FULL  = "  һ     ʯ ͷ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE_TALL_LOW  = "  һ     ʯ ͷ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STALAGMITE_TALL_MED  = "  һ     ʯ ͷ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.POWCAKE  = "  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CAVE_ENTRANCE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAVE_ENTRANCE.GENERIC  = " ֪       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAVE_ENTRANCE.OPEN  = "      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CAVE_EXIT  = "   ~ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MAXWELLPHONOGRAPH  = " ͦ ϲ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BOOMERANG  = "            " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGGUARD  = "  Ϊ   ϲ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ABIGAIL  = "   ͦ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ADVENTURE_PORTAL  = "    ʹ         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.AMULET  = "Ҳ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ANIMAL_TRACK  = "      Ŀ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ARMORGRASS  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ARMORMARBLE  = "   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.ARMORWOOD  = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ARMOR_SANITY = "       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.ASH = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.ASH.GENERIC  = " 룬            "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ASH.REMAINS_EYE_BONE  = "ת    Ϊ   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.ASH.REMAINS_THINGIE  = "ת    Ϊ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.AXE  = " Ϊ һ     Ҳ    ȥ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BABYBEEFALO  = "  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BACKPACK  = "һ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BACONEGGS = "Ӣ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BANDAGE  = " Ӧ     һ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BASALT = "һ Щ           "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEARDHAIR = "  һ Щ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEDROLL_STRAW  = "       "
-- paste here
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEE.GENERIC  = "        һ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEE.HELD  = "  Ϊ  ϲ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEBOX = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEBOX.FULLHONEY  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEBOX.GENERIC  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEBOX.NOHONEY  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEBOX.SOMEHONEY  = "Ӧ    һ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEFALO = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEFALO.FOLLOWER  = "     ƽ   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEFALO.GENERIC  = "    ĳ  ţ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEFALO.NAKED  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEFALO.SLEEPING  = "      ľ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEFALOHAT = " ̫    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEFALOWOOL  = "    һ Щ  ů     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEHAT  = "Ѫ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEHIVE  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BEEMINE_MAXWELL  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BERRIES  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BERRIES_COOKED = "      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BERRYBUSH = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.BERRYBUSH.BARREN = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BERRYBUSH.GENERIC  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BERRYBUSH.PICKED  = "  Ҳ         "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BIRDCAGE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.BIRDCAGE.GENERIC  = "  ץ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BIRDCAGE.OCCUPIED  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BIRDCAGE.SLEEPING = "   ˯   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BIRDTRAP  = "      ׽  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BIRD_EGG = "һ ֻ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BIRD_EGG_COOKED  = "ζ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BISHOP  = "  е  ʦ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLOWDART_FIRE  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLOWDART_SLEEP = "  ӵ            ţ " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUEAMULET  = "   ͦ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUEGEM  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUEPRINT  = "ĳ           ϣ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUE_CAP  = " Ӧ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUE_CAP_COOKED  = "   Ҫ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUE_MUSHROOM = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUE_MUSHROOM.GENERIC  = "һ  Ģ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUE_MUSHROOM.INGROUND = "  ˯  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BLUE_MUSHROOM.PICKED  = " ֪         "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BOARDS  = "ľ             "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BUGNET  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BUSHHAT  = "       Զ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BUTTER  = "      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BUTTERFLY = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.BUTTERFLY.GENERIC  = "ֻ  һ ֻ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.BUTTERFLY.HELD  = " ֪  Ϊ ʲ ô     ϲ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.BUTTERFLYWINGS  = "    һ  С Ů   ʱ    ϲ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CAMPFIRE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAMPFIRE.EMBERS  = " Ӧ     Ϩ  ֮ ǰ ȥ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAMPFIRE.GENERIC  = "һ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAMPFIRE.HIGH  = "   С   Ҫ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAMPFIRE.LOW = "   С   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAMPFIRE.NORMAL  = " ů    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAMPFIRE.OUT  = "    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CANE  = "   ħ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CARROT  = "  һ   Ѫ          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CARROT_COOKED  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CARROT_PLANTED  = "  ϲ   Щ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CAVE_FERN  = "һ  ާ  ֲ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CHARCOAL  = "     ľ ͷ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CHESSJUNK1 = "һ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CHESSJUNK2 = " һ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CHESSJUNK3  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CHESTER  = "        ʽ     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CHESTER_EYEBONE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.CHESTER_EYEBONE.GENERIC  = "      ë   Ȼ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CHESTER_EYEBONE.WAITING = "   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKEDMANDRAKE  = "   Ǹ    ֪   Ϊ ʲ ô      ʲ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKEDMEAT  = "  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKEDMONSTERMEAT  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKEDSMALLMEAT = " ֪      ԭ     û    Ѫ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKPOT = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKPOT.COOKING_LONG = " Ҫ һ  ʱ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKPOT.COOKING_SHORT  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKPOT.DONE  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.COOKPOT.EMPTY  = "        "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CUTGRASS = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CUTREEDS  = "« έ " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.CUTSTONE  = "   ȡ           "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CROW = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.CROW.GENERIC  = "        ѻ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.CROW.HELD  = "    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.CORN  = "     Ȼ  һ   Ѫ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DEERCLOPS_EYEBALL  = "Ī         "

STRINGS.CHARACTERS.SERAS.DESCRIBE.DEPLETED_GRASS = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.DEPLETED_GRASS.GENERIC  = "һ   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.DEVTOOL = "    ζ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DEVTOOL_NODEV  = "         Ц "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIRTPILE  = "       ͨ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGROD = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGROD.COLD = "    ΢   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGROD.GENERIC  = "  ĳ  Ѱ  װ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGROD.HOT  = " ô       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGROD.WARM  = " ȷ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGROD.WARMER  = "         "

STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGRODBASE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGRODBASE.GENERIC  = " ֪     ʲ ô  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGRODBASE.READY  = "     Ҫ     Կ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGRODBASE.UNLOCKED  = "     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.DIVININGRODSTART  = "  ֪          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DRAGONFRUIT  = "  ֪  Ϊ ʲ ô    Ϊ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DRAGONFRUIT_COOKED  = "          Ѫ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DRUMSTICK  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DRUMSTICK_COOKED  = "  ʥ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DDUG_BERRYBUSH  = " Ӧ      ȥ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DDUG_GRASS  = " Ӧ      ȥ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DDUG_MARSH_BUSH  = " Ӧ      ȥ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DDUG_SAPLING = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DURIAN  = "       Ѫ         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.DURIAN_COOKED  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EARMUFFSHAT  = "           "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EGGPLANT  = "   û         Զ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EGGPLANT_COOKED  = "    һ     һ   Ѫ          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EYEPLANT = "       ³   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN.BURNING  = "   С      ̫   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN.BURNT  = "   һ    Ч   ʽ    ľ ̿ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN.CHOPPED  = "һ   ׮ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN.GENERIC  = "һ       Ҷ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN_SPARSE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN_SPARSE.BURNING  = "   С      ̫   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN_SPARSE.BURNT  = "   һ    Ч   ʽ    ľ ̿ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN_SPARSE.CHOPPED = "ʼ  ٸ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.EVERGREEN_SPARSE.GENERIC  = "       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FARMPLOT = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.FARMPLOT.GENERIC  = "   ֲ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FARMPLOTGROWING  = "   Ҫ    ʱ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FARMPLOT.NEEDSFERTILIZER  = "          "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FEATHERHAT  = " һ    ԭ ס  ͷ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FEATHER_CROW  = " ɫ  ë  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FEATHER_ROBIN  = " ɫ   ë  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FEATHER_ROBIN_WINTER  = "ѩ    ë  ѩ  ɫ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREFLIES = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.GENERIC = "    Ư   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HELD  = "             "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREHOUND  = "ʮ       Ȯ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREPIT = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREPIT.EMBERS  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREPIT.GENERIC  = "  ܰ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREPIT.HIGH  = "   ӵ          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREPIT.LOW = " Խ  Խ С  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREPIT.NORMAL  = " ů     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FIREPIT.OUT  = "һ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FIRESTAFF  = "  С    Ҫ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FISH = "     ʳ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FISH_COOKED  = "ͦ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FLINT  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FLOWER  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FLOWERHAT  = " ³   һ   ȡ Ц   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FLOWER_EVIL  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FOLIAGE  = "      Ҷ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FOOTBALLHAT  = "   Ǹ С   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FROG = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.DEAD  = "    ˻    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GENERIC  = "       һ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SLEEPING  = "    ʱ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.FROGLEGS  = "   ϲ   Щ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.FROGLEGS_COOKED = "  ֪         Ȩ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GEARS = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GHOST  = "        ס"
STRINGS.CHARACTERS.SERAS.DESCRIBE.GOLDENAXE  = " ϲ    ɫ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GOLDENPICKAXE  = "     ֪  Ҫ  ô    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GOLDENPITCHFORK  = "  ħ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GOLDENSHOVEL  = " ɫ  Ѫ   Ĺ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GOLDNUGGET  = " ϣ      һ            "

STRINGS.CHARACTERS.SERAS.DESCRIBE.GRASS = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.GRASS.BARREN  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GRASS.BURNING  = "  ȼ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GRASS.GENERIC  = "             "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GRASS.PICKED  = "  ʱ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.GREEN_CAP  = " Ӧ  ʹ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GREEN_CAP_COOKED = " Ҫ  Ϊ  Ӧ     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.GREEN_MUSHROOM = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.GREEN_MUSHROOM.GENERIC  = "һ  Ģ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GREEN_MUSHROOM.INGROUND = "    ȥ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GREEN_MUSHROOM.PICKED  = "  ʱ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.GUNPOWDER  = "        һ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HAMBAT  = "  Ϊ    һ  һ  ˫      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HAMMER  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HEALINGSALVE  = " û  ȥ ҩ      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.HEATROCK = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.HEATROCK.COLD  = "̫   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HEATROCK.GENERIC  = "  Ҫ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HEATROCK.HOT  = "    ܰ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HEATROCK.WARM  = "ů ů  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.HOME = "    ס     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HOMESIGN  = " ˵ ,       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HONEY = "  ̫   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HONEYCOMB  = "  ס    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HORN  = "   һ    ӡ          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HOUND  = "  Ȯ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HOUNDBONE  = "  ë   Ȼ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.HOUNDMOUND  = "  Ȯ ס     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ICEBOX  = " һ  ԭ ʼ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ICEHOUND  = "      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.INSANITYROCK = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.INSANITYROCK.ACTIVE  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.INSANITYROCK.INACTIVE  = "  һ        "

STRINGS.CHARACTERS.SERAS.DESCRIBE.KILLERBEE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.KILLERBEE.GENERIC  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.KILLERBEE.HELD  = " Ҫ ƽ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.KNIGHT  = "Ӣ      һ      ʿ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.KOALEFANT_SUMMER = "       ζ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.KOALEFANT_WINTER  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.KRAMPUS  = "С ͵    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.KRAMPUS_SACK  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LEIF = "    ÿ һ   Ѫ      ج   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LEIF_SPARSE  = "    ÿ һ   Ѫ      ج  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.LIGHTNING_ROD = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.LIGHTNING_ROD.CHARGED = " ϣ   ʹ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LIGHTNING_ROD.GENERIC  = " ϣ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.LITTLE_WALRUS  = "  ׷ ɱ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LIVINGLOG  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LOCKEDWES  = "  ˹ Τ   ȥ     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.LOG = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.LOG.BURNING = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LOG.GENERIC  = "       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.LUREPLANT = "  а       а   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.LUREPLANTBULB  = "        ũ   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MANDRAKE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.MANDRAKE.DEAD  = "Ŷ         Ǹ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MANDRAKE.GENERIC  = "  Ī       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MANDRAKE.PICKED  = "   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MANDRAKESOUP  = "       Ϊ ʲ ô Ҫ  ô   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MANDRAKE_COOKED  = "   Ǹ    ֪   Ϊ ʲô            "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARBLE  = "    һ   ɫ   ʯ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARBLEPILLAR  = "һ    ʯ    ֧   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARBLETREE  = "   һ      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_BUSH = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_BUSH.BURNING  = "  ȼ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_BUSH.GENERIC  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_BUSH.PICKED  = "  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_PLANT  = "һ     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_TREE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_TREE.BURNING = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_TREE.BURNT  = "         ƽ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_TREE.CHOPPED  = " ׮   ô    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MARSH_TREE.GENERIC  = "һ  а     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MAXWELL  = "            ԭ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MAXWELLHEAD  = "       ë   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MAXWELLLIGHT  = "   ħ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MAXWELLLOCK  = "    һ  Կ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MAXWELLTHRONE  = "     ס "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MEAT  = "ʳ Ʒ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MEATRACK = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.MEATRACK.DONE  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MEATRACK.DRYING  = "  Ҫ һ Щ ʱ    ɹ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MEATRACK.GENERIC  = "        "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MEAT_DRIED  = "ζ            "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MERM = "      а       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MERMHEAD  = "       а   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MERMHOUSE  = "Ϊ ʲ ô    ס    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MINERHAT  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MONKEY  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MONKEYBARREL  = "  Ͱ Ҳ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MONSTERLASAGNA  = "  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MONSTERMEAT  = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MONSTERMEAT_DRIED  = "а          ɬ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MOSQUITO = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.MOSQUITO.GENERIC  = "     С  Ѫ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MOSQUITO.HELD  = "   û       Ѫ "

STRINGS.CHARACTERS.SERAS.DESCRIBE.MOUND = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.MOUND.DUG = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.MOUND.GENERIC  = " Ӧ  ʹ  Ĺ    Զ     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.NIGHTLIGHT  = " ɢ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.NIGHTMAREFUEL  = " ³        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.NIGHTSWORD = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.NITRE  = "   ʹ ը ҩ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ONEMANBAND  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PANDORASCHEST  = "            "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PANFLUTE  = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PAPYRUS  = "  ǰ    д   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PENGUIN  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PERD  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PETALS  = "    ժ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PETALS_EVIL  = "    ͣ      ج    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PICKAXE  = " ־   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGGYBACK  = "    ̫   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGHEAD  = "    ͷ ­    ȥ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGHOUSE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGHOUSE.FULL  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGHOUSE.GENERIC = "һ              "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGHOUSE.LIGHTSOUT  = "˳           "

STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGKING = "      ζ "

STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGMAN = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGMAN.DEAD = "Ӧ           "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGMAN.FOLLOWER  = "  ϣ   û   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGMAN.GENERIC  = " ʦ   ʦ     ץ   ~ ~          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGMAN.GUARD  = "    Ϊ  ϲ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGMAN.WEREPIG = " ͷ   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGSKIN = "  Ƥ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGTENT  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PIGTORCH  = "    ܰ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.PINECONE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.PINECONE.GENERIC  = "  Ȼ    ϣ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PINECONE.PLANTED = "    һ     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.PITCHFORK  = "  ֪        ħ   Щ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PLANTMEAT  = "    һ  ֲ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PLANTMEAT_COOKED  = "  Ӧ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.PLANT_NORMAL = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.PLANT_NORMAL.GENERIC  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PLANT_NORMAL.GROWING  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PLANT_NORMAL.READY = "      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.POMEGRANATE  = "  Ϊ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.POMEGRANATE_COOKED  = " ϣ       Ѫ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.POND  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.POOP  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PUMPKIN  = "      һ յ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PUMPKIN_COOKED = "  Ȼ  һ   Ѫ   Ѫ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PUMPKIN_LANTERN  = "ʵ   ̫   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PURPLEAMULET = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.PURPLEGEM  = "     ˽  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.RABBIT = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.RABBIT.GENERIC  = "ʳ    Դ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RABBIT.HELD  = "    һ    Ҫ      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.RABBITHOLE  = "             "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RAINOMETER  = "        ʪ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RAZOR  = "    Ѫ    ʱ Ҫ С  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.REDGEM  = "  ů     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RED_CAP  = "    Щ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RED_CAP_COOKED = "          "

STRINGS.CHARACTERS.SERAS.DESCRIBE.RED_MUSHROOM = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.RED_MUSHROOM.GENERIC  = "һ  Ģ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RED_MUSHROOM.INGROUND  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RED_MUSHROOM.PICKED  = "   Ҫ     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.REEDS = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.REEDS.BURNING  = "ȼ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.REEDS.GENERIC  = "һ  « έ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.REEDS.PICKED  = "          "

STRINGS.CHARACTERS.SERAS.DESCRIBE.RESEARCHLAB  = "һ     ѧ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RESEARCHLAB2 = "  ֪         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RESEARCHLAB3 = " ʲ ô     ġ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RESURRECTIONSTATUE  = "      ħ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.RESURRECTIONSTONE  = " ɢ   а      "

STRINGS.CHARACTERS.SERAS.DESCRIBE.ROBIN = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROBIN.GENERIC  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROBIN.HELD = "     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.ROBIN_WINTER = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROBIN_WINTER.GENERIC  = "  һ   ΰ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROBIN_WINTER.HELD  = " ʹ       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCK_LIGHT = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCK_LIGHT.GENERIC  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCK_LIGHT.OUT  = "   ʮ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCK_LIGHT.LOW = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCK_LIGHT.NORMAL  = "   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.ROBOT_PUPPET  = "   ס   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCK = "            "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROCKS  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROOK  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROPE  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.ROTTENEGG  = "  ϣ   Ѫ     Ҫ  ô   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SANITYROCK = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.SANITYROCK.ACTIVE  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SANITYROCK.INACTIVE  = " ȥ  Ϣ ȥ   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SAPLING = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.SAPLING.BURNING  = "  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SAPLING.GENERIC  = "  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SAPLING.PICKED  = "     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SEEDS  = "   ֲ  Ҳ     ץ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SEEDS_COOKED = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SEWING_KIT  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SHOVEL  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SILK  = "   ˿  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SKELETON  = " Ȼ             "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SKULLCHEST  = " ֪        ʲ ô  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SMALLBIRD = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.SMALLBIRD.GENERIC  = "һ          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SMALLBIRD.HUNGRY  = "  Ҫ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SMALLBIRD.STARVING = "     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SMALLMEAT  = "ζ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SMALLMEAT_DRIED  = "  ɬ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPEAR  = "     " 

STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER.DEAD  = "   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER.GENERIC  = "һ     ֩  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER.SLEEPING  = "  ˯  ʱ        "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDERDEN  = "Ī    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDEREGGSACK  = "   Ҫ          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDERGLAND  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDERQUEEN  = "          "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER_WARRIOR = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER_WARRIOR.DEAD  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER_WARRIOR.GENERIC  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SPIDER_WARRIOR.SLEEPING = "      Ҫ  һ   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SPOILED_FOOD  = "   ʳ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STATUEHARP  = "     ʲ ô  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STATUEMAXWELL  = "      ³   " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.STINGER  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STRAWHAT  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.STUFFEDEGGPLANT  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.SUNKBOAT  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TAFFY  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRD  = "ĳ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDEGG = "Ҫ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDEGG_COOKED  = "       "

STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDEGG_CRACKED = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDEGG_CRACKED.COLD  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDEGG_CRACKED.GENERIC  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDEGG_CRACKED.HOT  = "  ̫    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDEGG_CRACKED.LONG = "     "

STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDNEST = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDNEST.GENERIC  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRDNEST.PICKED  = "  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.TEENBIRD = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.TEENBIRD.GENERIC  = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TEENBIRD.HUNGRY  = "    һ Щ ʳ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TEENBIRD.STARVING  = "       Σ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEBASE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEBASE.SVALID  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEBASE.SGEMS  = " Ҫ      ʯ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.GEMSOCKET = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.GEMSOCKET.VALID  = "  ׼     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.GEMSOCKET.GEMS  = " Ҫ һ   ʯ  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_BASE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_BASE.ACTIVE  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_BASE.GENERIC  = "    һ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_BASE.LOCKED = "  ȱ  Щ ʲ ô "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_BASE.PARTIAL  = "  ©  һ Щ "

STRINGS.CHARACTERS.SERAS.DESCRIBE.SPOILED_FOOD  = "   ʳ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TALLBIRD  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_BOX  = "һ    " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_CRANK  = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_POTATO  = "  һ     а     " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELEPORTATO_RING = "     Ԥ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TELESTAFF  = "          "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TENT  = "   ج     ʵ  ج        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TENTACLE  = "             "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TENTACLESPIKE  = "  Ȼ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TENTACLESPOTS = "   Ƥ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TENTACLE_PILLAR = "   ȥ ˼            "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TENTACLE_PILLAR_ARM = "    ɫ      ͬ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TENTACLE_GARDEN = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TOPHAT = "  ʵ û   װ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TORCH  = " ϲ         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRAP = "   ת "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRAP_TEETH = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRAP_TEETH_MAXWELL  = "    ɱ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TREASURECHEST  = "  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TREASURECHEST_TRAP  = "     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_1 = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_10 = " Ѫ    ʧ ȥ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_11 = "      Ҫ ƭ   ɵ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_12  = "һ       Ӧ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_2  = "         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_3 = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_4 = " Щ   ë   Ȼ    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_5 = "      һ  ΢ С  Һ  ȼ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_6 = "  Ҷ            "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_7 = "      ʱ     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_8 = " ô        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRINKET_9 = "        ɫ Ū   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRUNKVEST_SUMMER  = "   һ  ΰ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRUNKVEST_WINTER  = "    Ҳ     ȹ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRUNK_COOKED  = "    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRUNK_SUMMER  = "  ϰ ϰ   ֦  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TRUNK_WINTER  = "    ë    "
STRINGS.CHARACTERS.SERAS.DESCRIBE.TWIGS  = " Щ  ֦         "
STRINGS.CHARACTERS.SERAS.DESCRIBE.UMBRELLA  = "    Ϊ һ  ʪ   Ѫ  " 
STRINGS.CHARACTERS.SERAS.DESCRIBE.UNIMPLEMENTED = "    û   С  һ      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WASPHIVE  = "  ǰ   û     һ  а     "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WETGOOP  = " Ҫ  Ϊ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_STONE  = "          ǽ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_STONE_ITEM  = "ʯ ͷ   ǽ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_RUINS  = "     ǽ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_RUINS_ITEM  = "       ʵ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_HAY  = "     ȥ  "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_HAY_ITEM  = "  ֪        Ȩ   "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_WOOD  = "     Asterix  Obelix "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALL_WOOD_ITEM  = "      һ     ǽ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALRUS  = "     ˭  ˭ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALRUS_TUSK  = "             Щ  ɱ "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALRUSHAT  = " ϲ           һ   Ա  "

STRINGS.CHARACTERS.SERAS.DESCRIBE.WALRUS_CAMP = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALRUS_CAMP.EMPTY  = "        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WALRUS_CAMP.GENERIC = " ϣ    һ    "

STRINGS.CHARACTERS.SERAS.DESCRIBE.WASPHIVE  = "  Ϊ  Щ       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WINTERHAT  = "      һ        "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WINTEROMETER  = "        ԭ   "

STRINGS.CHARACTERS.SERAS.DESCRIBE.WORMHOLE = {}
STRINGS.CHARACTERS.SERAS.DESCRIBE.WORMHOLE.GENERIC = "      "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WORMHOLE.OPEN  = "       "
STRINGS.CHARACTERS.SERAS.DESCRIBE.WORMHOLE_LIMITED  = "          "

--endpaste



STRINGS.CHARACTERS.SERAS.DESCRIBE_GENERIC  = "˵ ʵ    ֪  "
STRINGS.CHARACTERS.SERAS.DESCRIBE_TOODARK  = "         "








return MakePlayerCharacter("seras", prefabs, assets, fn)
