﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Un4seen.Bass;
using Un4seen.Bass.Misc;

namespace XMplayer
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public class IOpath
        {
            public string In_path;
            public string Out_path;
            public int cindex; 
        }

        int index_play = 0;
        string Path_out = "";
        DataTable table;
        List<string> Path_Allmusic = new List<string>();

        private void PlayMusic(string Path_playmusic,int ct)
        {
            Bass.BASS_Init(-1, 44100, BASSInit.BASS_DEVICE_DEFAULT, IntPtr.Zero);

            //if (Bass.BASS_Init(-1, 44100, BASSInit.BASS_DEVICE_DEFAULT, IntPtr.Zero))
            //{
            int Stream_playmusic = Bass.BASS_MusicLoad(Path_playmusic, 0L, 0, BASSFlag.BASS_DEFAULT, 0);
            if (ct == 1)
            {
                try
                {
                    dataGridView1.Rows[index_play].Cells[2].Value = "停止";
                }
                catch (Exception ex)
                {

                    MessageBox.Show(ex.Message);
                }
                Bass.BASS_Free();
                Bass.BASS_StreamFree(Stream_playmusic);
                
                return;
            }
            if (Stream_playmusic!=0)
                {
                    Bass.BASS_ChannelPlay(Stream_playmusic,false);
                }
                else
                {
                    MessageBox.Show(Bass.BASS_ErrorGetCode().ToString());
                }
            
                
            //}
        }

        private void TransCode(IOpath path)
        {
            dataGridView1.Rows[path.cindex].Cells[2].Value = "操作";
            Bass.BASS_Init(-1, 44100, BASSInit.BASS_DEVICE_DEFAULT, IntPtr.Zero);
            int Stream_trans = Bass.BASS_MusicLoad(path.In_path, 0L, 0, BASSFlag.BASS_MUSIC_PRESCAN | BASSFlag.BASS_MUSIC_DECODE, 0);
            if (Stream_trans != 0)
            {
                long lenOfmusic = Bass.BASS_ChannelGetLength(Stream_trans);

                EncoderLAME lame = new EncoderLAME(Stream_trans);
                lame.InputFile = null;
                lame.OutputFile = path.Out_path;//带后缀
                lame.LAME_Bitrate = (int)EncoderLAME.BITRATE.kbps_320;
                lame.LAME_Mode = EncoderLAME.LAMEMode.Default;
                lame.LAME_Quality = EncoderLAME.LAMEQuality.Quality;
                lame.Start(null,IntPtr.Zero,false);

                byte[] encBuffer = new byte[65536];
                int tLen = 0;
                while (Bass.BASS_ChannelIsActive(Stream_trans) == BASSActive.BASS_ACTIVE_PLAYING) 
                {
                    double cacl = (double)tLen / lenOfmusic;
                    double schedule = cacl * 100;
                    int num = path.cindex + 1;
                    this.Invoke(new Action(() =>
                    {
                        label1.Text = "进度：" + (int)schedule + "%  -  " + num + "| " + Path_Allmusic.Count;
                    }));
                    
                    if (tLen > lenOfmusic) 
                    {
                        break;
                    }
                    int len = Bass.BASS_ChannelGetData(Stream_trans, encBuffer, encBuffer.Length);
                    tLen += len;
                }
                lame.Stop();
                Bass.BASS_Free();
                Bass.BASS_StreamFree(Stream_trans);
                dataGridView1.Rows[path.cindex].Cells[2].Value = "完成";

            }
            else
            {
                MessageBox.Show(Bass.BASS_ErrorGetCode().ToString());
            }
        }


        private void loopfile()
        {
            for (int i = 0; i < Path_Allmusic.Count; i++)
            {
                if (dataGridView1.Rows[i].Cells[2].Value.ToString() == "完成")
                {
                    continue;
                }
                IOpath iop = new IOpath();
                iop.cindex = i;
                iop.In_path = Path_Allmusic[i];
                iop.Out_path = Path_out + @"\" + Path.GetFileNameWithoutExtension(Path_Allmusic[i]) + ".mp3";

                TransCode(iop);
                
            }
            MessageBox.Show("全部完成！！");
            this.Invoke(new Action(() =>
            {
                button1.Enabled = true;
                button3.Enabled = true;
                button2.Text = "全部开始";
            }));
        }

        private void Createlist()
        {
            table = new DataTable();

            table.Columns.Add("num",Type.GetType("System.Int32"));
            table.Columns[0].AutoIncrement = true;
            table.Columns[0].AutoIncrementSeed = 1;
            table.Columns[0].AutoIncrementStep = 1;

            DataColumn co ;

            co = new DataColumn();
            co.DataType = Type.GetType("System.String");
            co.ColumnName = "文件";
            table.Columns.Add(co);

            co = new DataColumn();
            co.DataType = Type.GetType("System.String");
            co.ColumnName = "状态";
            table.Columns.Add(co);

        }

        private void ReadFilePath(string folderpath, int n)
        {
            DirectoryInfo folder = new DirectoryInfo(folderpath);

            if (n == 0) 
            {
                Createlist();
                dataGridView1.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
                dataGridView1.DataSource = table;
                dataGridView1.Columns[0].Width = 30;
                dataGridView1.Columns[1].Width = 200;
                dataGridView1.Columns[2].Width = 50;
                dataGridView1.RowHeadersVisible = false;
                
                dataGridView1.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.DisplayedCells;
                return;
            }
            
            
            foreach (FileInfo files in folder.GetFiles("*.xm")) 
            {
                table.Rows.Add(null, files.Name, "停止");
                Path_Allmusic.Add(files.FullName); 
            }
            //dataGridView1.DataSource = table;
            //dataGridView1.Columns[0].Width = 30;
            //dataGridView1.Columns[1].Width = 200;
            //dataGridView1.Columns[2].Width = 40;
            //dataGridView1.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.DisplayedCells;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //PlayMusic();
            //IOpath i = new IOpath();
            //i.In_path = "test.xm";
            //i.Out_path = "out.mp3";
            //TransCode(i);
            Createlist();
            string p = @"C:\Users\杨思英\Desktop\project\XMplayer\XMplayer\XMplayer\bin\Debug";
            ReadFilePath(p, 0);
            //MessageBox.Show(Path_Allmusic[dataGridView1.CurrentCell.RowIndex]);
        }

        private void dataGridView1_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop)) 
            {
                e.Effect = DragDropEffects.Link;
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }
        }

        private void dataGridView1_DragDrop(object sender, DragEventArgs e)
        {
            string[] tpath = (string[])e.Data.GetData(DataFormats.FileDrop);
            foreach (string item in tpath)
            {
                FileInfo fa = new FileInfo(item);

                if ((fa.Attributes & FileAttributes.Directory) == FileAttributes.Directory) 
                {
                    ReadFilePath(item, 1);
                }
                else
                {
                    //MO3 / IT / XM / S3M / MTM / MOD / UMX 
                    string ep = Path.GetExtension(item);
                    if (ep == ".xm" || ep == ".mo3" || ep == ".it" || ep == ".s3m" || ep == ".mod" || ep == ".umx") 
                    {
                        table.Rows.Add(null, fa.Name, "停止");
                        Path_Allmusic.Add(fa.FullName);
                    }
                    
                }
                
            }
            
        }

        private void button1_Click(object sender, EventArgs e)
        {

            if (String.IsNullOrEmpty(Path_out)) 
            {
                MessageBox.Show("请选择输出路径");
                return;
            }
            try
            {
                IOpath transpath = new IOpath();
                int nindex = dataGridView1.CurrentCell.RowIndex;
                transpath.In_path = Path_Allmusic[nindex];
                transpath.Out_path = Path_out + @"\" + Path.GetFileNameWithoutExtension(Path_Allmusic[nindex]) + ".mp3";
                transpath.cindex = nindex;

                Thread t1 = new Thread(() => { TransCode(transpath); });
                t1.Start();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }


        }

        private void miniToolStrip_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }

        private void 导入文件ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog opf = new OpenFileDialog();
            opf.Filter = "(files)|*.xm;*.mod;*.MO3";/// / IT / XM / S3M / MTM / MOD / UMX
            opf.ShowDialog();
            string[] opfpath = opf.FileNames;
            foreach (string item in opfpath)
            {
                table.Rows.Add(null, Path.GetFileName(item), "停止");
                Path_Allmusic.Add(item);
            }
        }

        private void 导入文件夹ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dfg = new FolderBrowserDialog();
            dfg.ShowDialog();
            string dfgpathj = dfg.SelectedPath;
            ReadFilePath(dfgpathj, 1);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.ShowDialog();
            Path_out = fbd.SelectedPath;
            textBox1.Text = Path_out;
        }

        Thread td_all;
        private void button2_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(Path_out))
            {
                MessageBox.Show("请选择输出路径");
                return;
            }
            if (button2.Text == "停止") 
            {
                this.Invoke(new Action(() =>
                {
                    button1.Enabled = true;
                    button3.Enabled = true;
                    button2.Text = "全部开始";                  
                }));
                td_all.Abort();
                return;
            }
            try
            {
                this.Invoke(new Action(() =>
                {
                    button1.Enabled = false;
                    button3.Enabled = false;
                    button2.Text = "停止";
                }));
                td_all= new Thread(() => { loopfile(); });
                td_all.Start();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
           
        }
        //Thread td_play;
        private void 播放当前选择ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {               
                string playpath = Path_Allmusic[dataGridView1.CurrentCell.RowIndex];
                //td_play = new Thread(() =>
                //{
                PlayMusic("", 1);
                PlayMusic(playpath,0);
                //});
                //td_play.Start();
                dataGridView1.Rows[dataGridView1.CurrentCell.RowIndex].Cells[2].Value = "播放";
                index_play = dataGridView1.CurrentCell.RowIndex;
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
        }

        private void 停止播放ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // td_play.Abort();
            //Bass.BASS_Stop();
            PlayMusic("", 1);
            
        }

        private void 打开输出文件夹ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("Explorer.exe", Path_out);
        }

        private void 访问博客ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://xianka.luobotou.org/");
        }

        private void 访问论坛ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://bbs.luobotou.org/");
        }

        private void 意见反馈ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://bbs.luobotou.org/thread-16416-1-1.html");
        }

        private void 获取帮助ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://bbs.luobotou.org/thread-16416-1-1.html");
        }
    }
}
