﻿<%@ page language="C#" autoeventwireup="true" inherits="ebook_bill_add, ZS.CashBook" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="../style/init.css" rel="stylesheet" />
    <link href="../style/zsbook.css" rel="stylesheet" />
    <link href="../style/plugin.css" rel="stylesheet" />
    <link href="../../js/artdialog/ui-dialog.css" rel="stylesheet" />
    <script src="../../js/jquery/jquery-1.7.2.min.js"></script>
    <script src="../../js/jquery/jquery.easing.1.3.js"></script>
    <script src="../../js/jquery/jquery.zsweb.js"></script>
    <script src="../../js/artdialog/dialog-plus-min.js"></script>
    <script src="../../js/jquery/jquery.validate.js"></script>
    <script src="../../js/jquery/jquery.datetimepicker.js"></script>
    <script src="../../js/jquery/jquery.tipTip.js"></script>
    <script src="../js/zs.ebook.js"></script>
    <script type="text/javascript">
        $(function () {
            $("#form_main").Validform(); //表单检测
            $("input.date").datetimepicker({
                lang: 'ch',
                timepicker: false,
                format: 'Y-m-d',
                formatDate: 'Y-m-d'
            });
        })
        function closeDialog() {
            var api = top.dialog.get(window); //获取父窗体对象
            api.remove();
        }
    </script>
</head>
<body>
    <form id="form_main" runat="server">
       <div class="zs-operation">
            <div class="zs-form">
                <b>
                    <label for="">名称</label>
                    <asp:TextBox ID="tbTitle" runat="server" class="zs-input" style="width: 250px;" datatype="*" nullmsg="请输入名称"></asp:TextBox>
                </b>
                <b>
                    <label for="">金额</label>
                    <asp:TextBox ID="tbAmount" runat="server" class="zs-input" style="width: 250px;" datatype="/^(([1-9]\d{0,9})|0)(\.\d{1,2})?$/" nullmsg="请输入金额" errormsg="输入的金额不合法"></asp:TextBox>
                </b>
                <b>
                    <label for="">类别</label>
                    <div class="zs-ddl"><asp:DropDownList ID="ddlCategoryID" CssClass="zs-hidden" runat="server" datatype="*"></asp:DropDownList></div>  
                </b>
                <b>
                    <label for="">账户</label>
                    <div class="zs-ddl"><asp:DropDownList ID="ddlAccountID" CssClass="zs-hidden" runat="server" datatype="*"></asp:DropDownList></div>  
                </b>
                <b>
                    <label for="">日期</label>
                    <asp:TextBox ID="tbPostTime" runat="server" class="zs-input short date" datatype="*"></asp:TextBox>
                </b>
                <b>
                    <label for="">经手人</label>
                    <asp:TextBox ID="tbUserName" runat="server" class="zs-input short" datatype="*"></asp:TextBox>
                </b>
                <b>
                    <label for="">备注</label>
                    <asp:TextBox ID="tbRemark" runat="server" class="zs-textarea" TextMode="MultiLine" placeholder="备注内容支持搜索"></asp:TextBox>
                </b>
                <b> <label for=""></label>
                    <asp:Button ID="btnSubmit" runat="server" Text="提交" OnClick="btnSubmit_Click"  class="zs-btn"/>
                </b>
            </div>
       </div>
    </form>
</body>
</html>
