﻿<%@ page language="C#" autoeventwireup="true" inherits="ebook_bill_list, ZS.CashBook" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="../style/init.css" rel="stylesheet" />
    <link href="../style/zsbook.css" rel="stylesheet" />
    <link href="../style/plugin.css" rel="stylesheet" />
    <link href="../../js/artdialog/ui-dialog.css" rel="stylesheet" />
    <script src="../../js/jquery/jquery-1.7.2.min.js"></script>
    <script src="../../js/jquery/jquery.easing.1.3.js"></script>
    <script src="../../js/jquery/jquery.zsweb.js"></script>
    <script src="../../js/artdialog/dialog-plus-min.js"></script>
    <script src="../../js/jquery/jquery.validate.js"></script>
    <script src="../../js/jquery/jquery.datetimepicker.js"></script>
    <script src="../../js/jquery/jquery.nicescroll.js"></script>
    <script src="../../js/jquery/jquery.tipTip.js"></script>
    <script src="../js/zs.ebook.js"></script>
    <script type="text/javascript">
        $(function () {
            $(".nicescroll").niceScroll(); //滚动条
            $("input.date").datetimepicker({
                lang: 'ch',
                timepicker: false,
                format: 'Y-m-d',
                formatDate: 'Y-m-d'
            });
        });
    </script>

</head>
<body class="zs-page">
    <form id="form_main" runat="server">
    <div class="zs-content clear">
        <div class="zs-module search fixed nicescroll" style="width: 380px;">
        	<h2 class="title">账单筛选与搜索</h2>
        	<div class="list">
        		<span>类型</span>
				<div class="zs-radio-list">
                    <asp:RadioButtonList ID="rblCategoryID" CssClass="zs-hidden" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" AutoPostBack="true" OnSelectedIndexChanged="rblCategoryID_SelectedIndexChanged"></asp:RadioButtonList>
				</div>
        	</div>
        	<div class="list">
        		<span>账户</span>
				<div class="zs-radio-list">
                    <asp:RadioButtonList ID="rblAccountID" CssClass="zs-hidden" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" AutoPostBack="true" OnSelectedIndexChanged="rblAccountID_SelectedIndexChanged"></asp:RadioButtonList>
				</div>
        	</div>
            <div class="list">
        		<span>团队</span>
				<div class="zs-radio-list">
                    <asp:RadioButtonList ID="rblUserID" CssClass="zs-hidden" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" AutoPostBack="true" OnSelectedIndexChanged="rblUserID_SelectedIndexChanged"></asp:RadioButtonList>
				</div>
        	</div>
        	<div class="list">
        		<span>搜索</span>
        		<div class="form">
					<b>
						<div class="calendar-select">
                            <asp:TextBox ID="tbST" CssClass="zs-input short date" runat="server"></asp:TextBox>
						</div>
						<i class="space"></i>
						<div class="calendar-select">
                            <asp:TextBox ID="tbET" CssClass="zs-input short date" runat="server"></asp:TextBox>
						</div>
					</b>
                    <b><asp:TextBox ID="tbSearchWord" CssClass="zs-input long" runat="server" placeholder="支持搜索备注"></asp:TextBox></b>
					<b><asp:Button ID="btnSubmit" runat="server" Text="搜索" CssClass="zs-btn" OnClick="btnSubmit_Click"/></b>
	        	</div>
        	</div>
        </div>
        <div class="zs-module bill-list" style="margin-left:381px; min-width: 550px;">
        	<h2 class="title">账单列表<i><a href="list.aspx">所有账单</a></i></h2>
            <asp:Repeater ID="rptList" runat="server" OnItemDataBound="rptList_ItemDataBound" OnItemCommand="rptList_ItemCommand">
                <HeaderTemplate>
                    <ul id="record-list">
                </HeaderTemplate>
                <ItemTemplate>
                    <li>
					    <b><asp:LinkButton runat="server" ID="lbDel" CommandName="btnDel" CssClass="zs-btn-del" CommandArgument=<%#Eval("ID")%>></asp:LinkButton></b>
                        <asp:Literal ID="ltIcon" runat="server"></asp:Literal>
					    <h3 class="clear"><asp:Literal ID="ltAmount" runat="server"></asp:Literal></h3>
					    <p><%#Eval("CategoryTitle")%><i class="line"></i><%#Eval("AccountTitle")%><i class="line"></i><%#Eval("UserName")%><i class="line"></i><%#Convert.ToDateTime(Eval("PostTime")).ToString("yyyy-MM-dd")%><i class="line"></i><asp:LinkButton runat="server" ID="lbCheck" CommandName="btnCheck" CssClass='<%# Convert.ToInt32(Eval("isCheck")) == 1 ? "zs-btn-check itip" : "zs-btn-uncheck itip" %>'  ToolTip='<%# Convert.ToInt32(Eval("isCheck")) == 1 ? "取消审核" : "通过审核"%>' CommandArgument=<%#Eval("ID")%> ></asp:LinkButton></p>
        		    </li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                </FooterTemplate>
            </asp:Repeater>
            <div id="pageList" runat="server" class="zs-page-list"></div>
        </div>
    </div>
    </form>
</body>
</html>
