﻿<%@ page language="C#" autoeventwireup="true" inherits="ebook_count_list, ZS.CashBook" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="../style/init.css" rel="stylesheet" />
    <link href="../style/zsbook.css" rel="stylesheet" />
    <link href="../style/plugin.css" rel="stylesheet" />
    <link href="../../js/artdialog/ui-dialog.css" rel="stylesheet" />
    <script src="../../js/jquery/jquery-1.7.2.min.js"></script>
    <script src="../../js/jquery/jquery.easing.1.3.js"></script>
    <script src="../../js/jquery/jquery.zsweb.js"></script>
    <script src="../../js/artdialog/dialog-plus-min.js"></script>
    <script src="../../js/jquery/jquery.datetimepicker.js"></script>
    <script src="../../js/jquery/jquery.nicescroll.js"></script>
    <script src="../../js/jquery/jquery.tipTip.js"></script>
    <script src="../../js/charts/amCharts.js"></script>
    <script src="../js/zs.ebook.js"></script>
    <script type="text/javascript">
        $(function () {
            $(".nicescroll").niceScroll(); //滚动条
            $("input.date").datetimepicker({
                lang: 'ch',
                timepicker: false,
                format: 'Y-m-d',
                formatDate: 'Y-m-d'
            });
        })
    </script>
</head>
<body class="zs-page">
    <form id="form_main" runat="server">

    <div class="zs-content clear">
        <div class="zs-module fixed nicescroll" style="width: 170px">
			<h2 class="title">常用统计</h2>
			<div class="list">
                <div class="zs-subnav-list">
                    <asp:RadioButtonList ID="rblCountType" CssClass="zs-hidden" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" AutoPostBack="true" OnSelectedIndexChanged="rblCountType_SelectedIndexChanged"></asp:RadioButtonList>
				</div>
			</div>
			<h2 class="title">自定义统计</h2>
			<div class="list">
				<div class="form">
					<b><asp:TextBox ID="tbST" CssClass="zs-input short date" runat="server"></asp:TextBox></b>
					<b><asp:TextBox ID="tbET" CssClass="zs-input short date" runat="server"></asp:TextBox></b>
					<b><asp:Button ID="btnSubmit" runat="server" Text="统计" OnClick="btnSubmit_Click" CssClass="zs-btn"/></b>
	        	</div>
			</div>
		</div>
        <div class="zs-module bill-board" style="margin-left: 171px; width: 680px">
			<h2 class="title">财务看板 <asp:Literal ID="ltDay" runat="server"></asp:Literal><i><div class="zs-radio-list"><asp:RadioButtonList ID="rblIsCheck" CssClass="zs-hidden" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" AutoPostBack="true" OnSelectedIndexChanged="rblIsCheck_SelectedIndexChanged"></asp:RadioButtonList></div></i></h2>
			<div class="data clear">
                <h3 class="data-in">
                    <span>收入</span>
                    <asp:Literal ID="ltIn" runat="server"></asp:Literal>
                </h3>
                <h3 class="data-out">
                    <span>支出</span>
                    <asp:Literal ID="ltOut" runat="server"></asp:Literal>
                </h3>
                <h3 class="data-balance">
                    <span>余额</span>
                    <asp:Literal ID="ltBalance" runat="server"></asp:Literal>
                </h3>
            </div>
			<h2 class="title">统计报表</h2>
            <div class="zs-itab-list">
                <asp:RadioButtonList ID="rblChartType" CssClass="zs-hidden" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" AutoPostBack="true" OnSelectedIndexChanged="rblChartType_SelectedIndexChanged"></asp:RadioButtonList>
			</div>
            <div id="chartdiv" style="margin: 0 auto; text-align:center; width: 100%; height: 380px"></div>
		</div>
        <asp:Literal ID="ltChartData" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
