﻿<%@ page language="C#" autoeventwireup="true" inherits="ebook_system_book, ZS.CashBook" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="../style/init.css" rel="stylesheet" />
    <link href="../style/zsbook.css" rel="stylesheet" />
    <link href="../style/plugin.css" rel="stylesheet" />
    <link href="../../js/artdialog/ui-dialog.css" rel="stylesheet" />
    <script src="../../js/jquery/jquery-1.7.2.min.js"></script>
    <script src="../../js/jquery/jquery.easing.1.3.js"></script>
    <script src="../../js/jquery/jquery.zsweb.js"></script>
    <script src="../../js/artdialog/dialog-plus-min.js"></script>
    <script src="../../js/jquery/jquery.validate.js"></script>
    <script src="../../js/jquery/jquery.datetimepicker.js"></script>
    <script src="../../js/jquery/jquery.tipTip.js"></script>
    <script src="../js/zs.ebook.js"></script>
    <script type="text/javascript">
        $(function () {
            $("#form_main").Validform(); //表单检测
            $("input.date").datetimepicker({
                lang: 'ch',
                timepicker: false,
                format: 'Y-m-d',
                formatDate: 'Y-m-d'
            });
        })
    </script>
</head>
<body class="zs-page">
    <form id="form_main" runat="server">
    <div class="zs-content clear">
		<div class="zs-module system fixed">
			<h2 class="title">账单设置</h2>
			<div class="list">
				<ul class="zs-subnav">
					<li><a href="category.aspx">分类管理</a></li>
                    <li><a href="account.aspx">收支账户</a></li>
					<li><a href="user.aspx">团队管理</a></li>
                    <li><a href="role.aspx">角色管理</a></li>
					<li><a href="log.aspx">操作日志</a></li>
                    <li><a href="book.aspx" class="selected">账本管理</a></li>
				</ul>
			</div>
		</div>
		<div class="zs-module account-book" style="margin-left: 151px;">
        	<h2 class="title">账本管理<i><asp:LinkButton ID="lbAdd" runat="server" CssClass="zs-btn-add" OnClick="lbAdd_Click"></asp:LinkButton></i></h2>
            <asp:Repeater ID="rptList" runat="server" OnItemDataBound="rptList_ItemDataBound" OnItemCommand="rptList_ItemCommand">
                <HeaderTemplate>
                    <ul class="account-book-list" id="record-list">
                </HeaderTemplate>
                <ItemTemplate>
                    <li>
                        <div class="bg">
						    <div class="item">
                                <i><asp:LinkButton runat="server" ID="lbCheck" CommandName="btnCheck" CssClass='<%# Convert.ToInt32(Eval("isCheck")) == 1 ? "zs-btn-check itip" : "zs-btn-uncheck itip" %>'  ToolTip='<%# Convert.ToInt32(Eval("isCheck")) == 1 ? "该账本记账不需要审核" : "该账本记账需要审核"%>' CommandArgument=<%#Eval("ID")%> ></asp:LinkButton></i>
                                <asp:HyperLink ID="hlEdit" runat="server"><span class="icon"></span><h3 class="book-name"><%#Eval("BookName")%></h3></asp:HyperLink>
							    <p class="btn-box"><asp:LinkButton runat="server" ID="lbDel" CommandName="btnDel" CssClass="zs-btn-del" CommandArgument=<%#Eval("ID")%> ></asp:LinkButton><asp:HyperLink ID="hlExcel" runat="server" CssClass="zs-btn-excel"></asp:HyperLink></p>
						    </div>
                        </div>
                    </li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <asp:Panel ID="pnBookEdit" runat="server">
        <div class="zs-module fixed" style="margin-left: 332px; width: 550px;">
            <h2 class="title">账本编辑<i><a href="book.aspx">清空表单</a></i></h2>
            <div class="zs-form clear">
                <b>
                    <label for="">名称</label>
                    <asp:TextBox ID="tbBookName" runat="server" class="zs-input normal" datatype="*"></asp:TextBox>
                </b>
                <b>
                    <label for="">记账是否共享</label>
                    <div class="zs-single-checkbox"><asp:CheckBox ID="cbIsShare" runat="server"/></div>
                </b>
                <b>
                    <label for="">是否需要审核</label>
                    <div class="zs-single-checkbox"><asp:CheckBox ID="cbIsCheck" runat="server"/></div>
                </b>
                <b>
                    <label for="">备注</label>
                    <asp:TextBox ID="tbSummary" runat="server" class="zs-textarea" TextMode="MultiLine"></asp:TextBox>
                </b>
                <b>
                    <label for=""></label>
                    <asp:Button ID="btnSubmit" runat="server" Text="提交" class="zs-btn" OnClick="btnSubmit_Click" />
                </b>
            </div>
        </div>
        </asp:Panel>
        <asp:Panel ID="pnBookExcel" runat="server" Visible="false">
        <div class="zs-module fixed" style="margin-left: 332px; width: 550px;">
            <h2 class="title">账本导出Excel<i><a href="javascript:window.history.back()">返回上一页</a></i></h2>
            <div class="zs-form clear">
                <b>
                    <label for="">账本名称</label>
                    <asp:TextBox ID="tbBName" runat="server" class="zs-input normal" Enabled="false"></asp:TextBox>
                </b>
                <b>
                    <label for="">起始日期</label>
                    <asp:TextBox ID="tbST" runat="server" class="zs-input date" datatype="*"></asp:TextBox>
                </b>
                <b>
                    <label for="">结束日期</label>
                    <asp:TextBox ID="tbET" runat="server" class="zs-input date" datatype="*"></asp:TextBox>
                </b>
                <b>
                    <label for=""></label>
                    <asp:Button ID="btnExcel" runat="server" Text="导出Excel" class="zs-btn" OnClick="btnExcel_Click" />
                </b>
            </div>
        </div>
        </asp:Panel>
    </div>
    </form>
</body>
</html>