﻿<%@ page language="C#" autoeventwireup="true" inherits="cms_system_role_value, ZS.CashBook" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="../style/init.css" rel="stylesheet" />
    <link href="../style/zsbook.css" rel="stylesheet" />
    <link href="../style/plugin.css" rel="stylesheet" />
    <script src="../../js/jquery/jquery-1.7.2.min.js"></script>
    <script src="../../js/jquery/jquery.zsweb.js"></script>
    <script src="../../js/jquery/jquery.nicescroll.js"></script>
    <script src="../../js/jquery/jquery.tipTip.js"></script>
    <script src="../js/zs.ebook.js"></script>
    <script type="text/javascript">
        $(function () {
            //权限全选
            $("input[name='checkAll']").click(function () {
                if ($(this).prop("checked") == true) {
                    $("input[name!='checkAll']").prop("checked", true);
                } else {
                    $("input[name!='checkAll']").prop("checked", false);
                }
            })
            //权限全选[模块]
            $("input[name='checkModule']").click(function () {
                if ($(this).prop("checked") == true) {
                    $(this).parent().siblings("td").find("input[type='checkbox']").prop("checked", true);
                } else {
                    $(this).parent().siblings("td").find("input[type='checkbox']").prop("checked", false);
                }
            });

        });
    </script>
</head>
<body class="zs-page">
    <form id="form_main" runat="server">
    <div class="zs-content clear">
		<div class="zs-module system fixed">
			<h2 class="title">账单设置</h2>
			<div class="list">
				<ul class="zs-subnav">
					<li><a href="category.aspx">分类管理</a></li>
                    <li><a href="account.aspx">收支账户</a></li>
					<li><a href="user.aspx">团队管理</a></li>
                    <li><a href="role.aspx" class="selected">角色管理</a></li>
                    <li><a href="log.aspx">操作日志</a></li>
                    <li><a href="book.aspx">账本管理</a></li>
				</ul>
			</div>
		</div>
		<div class="zs-module system" style="margin-left: 151px; width: 700px;">
        	<h2 class="title">权限配置 - <asp:Literal ID="ltRoleName" runat="server"></asp:Literal> <i><a href="javascript:window.history.back()">返回上一页</a></i></h2>
            <table class="zs-data-table">
                <thead>
                    <tr>
                    <th align="center" width="40%">模块名称</th>
                    <th align="center">权限分配</th>
                    <th align="center" width="10%"><input name="checkAll" type="checkbox" /></th>
                    </tr>
                </thead>
                <tbody>
                    <asp:Repeater ID="rptList" runat="server" onitemdatabound="rptList_ItemDataBound">
                        <ItemTemplate>
                        <tr>
                        <td>
                            <asp:TextBox ID="tbID" runat="server" Text='<%#Eval("ID") %>' Visible="False"></asp:TextBox><asp:TextBox ID="tbLayer" runat="server" Text='<%#Eval("Layer") %>' Visible="False"></asp:TextBox><asp:TextBox ID="tbActionList" runat="server" Text='<%#Eval("ActionList") %>' Visible="False"></asp:TextBox>
                            <asp:Literal ID="litSpan" runat="server"></asp:Literal><%#Eval("Title")%>
                        </td>
                        <td>
                            <asp:CheckBoxList ID="cblActionList" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" CssClass="cbllist"></asp:CheckBoxList>
                        </td>
                        <td class="center"><input name="checkModule" type="checkbox" /></td>
                        </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                    <tr><td colspan="3" class="center"><asp:Button ID="btnSubmit" runat="server" Text="提交" CssClass="zs-btn" OnClick="btnSubmit_Click" /></td></tr>
                </tbody>
            </table>
        </div>
    </div>
    </form>
</body>
</html>