﻿<%@ page language="C#" autoeventwireup="true" inherits="cms_system_user, ZS.CashBook" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="../style/init.css" rel="stylesheet" />
    <link href="../style/zsbook.css" rel="stylesheet" />
    <link href="../style/plugin.css" rel="stylesheet" />
    <link href="../../js/artdialog/ui-dialog.css" rel="stylesheet" />
    <script src="../../js/jquery/jquery-1.7.2.min.js"></script>
    <script src="../../js/jquery/jquery.easing.1.3.js"></script>
    <script src="../../js/jquery/jquery.zsweb.js"></script>
    <script src="../../js/artdialog/dialog-plus-min.js"></script>
    <script src="../../js/jquery/jquery.validate.js"></script>
    <script src="../../js/jquery/jquery.tipTip.js"></script>
    <script src="../js/zs.ebook.js"></script>
    <script type="text/javascript">
        $(function () {
            $("#form_main").Validform(); //表单检测
        })
    </script>
</head>
<body class="zs-page">
    <form id="form_main" runat="server">
    <div class="zs-content clear">
		<div class="zs-module system fixed">
			<h2 class="title">账单设置</h2>
			<div class="list">
				<ul class="zs-subnav">
					<li><a href="category.aspx">分类管理</a></li>
                    <li><a href="account.aspx">收支账户</a></li>
					<li><a href="user.aspx" class="selected">团队管理</a></li>
                    <li><a href="role.aspx">角色管理</a></li>
					<li><a href="log.aspx">操作日志</a></li>
                    <li><a href="book.aspx">账本管理</a></li>
				</ul>
			</div>
		</div>
		<div class="zs-module system" style="margin-left: 151px; width: 360px;">
        	<h2 class="title">团队管理<i><asp:LinkButton ID="lbAdd" runat="server" CssClass="zs-btn-add" OnClick="lbAdd_Click"></asp:LinkButton></i></h2>
            <asp:Repeater ID="rptList" runat="server" OnItemDataBound="rptList_ItemDataBound" OnItemCommand="rptList_ItemCommand">
                <HeaderTemplate>
                    <ul class="zs-data-list" id="record-list">
                </HeaderTemplate>
                <ItemTemplate>
                    <li><asp:HyperLink ID="hlEdit" runat="server"><%#Eval("UserName")%></asp:HyperLink><span class="line"></span><%#Eval("NickName")%><span class="line"></span><%#Eval("RoleName")%><span class="line"></span><asp:LinkButton runat="server" ID="lbCheck" CommandName="btnCheck" CssClass='<%# Convert.ToInt32(Eval("isCheck")) == 1 ? "zs-btn-check itip" : "zs-btn-uncheck itip" %>' ToolTip='<%# Convert.ToInt32(Eval("isCheck")) == 1 ? "禁用" : "启用"%>' CommandArgument=<%#Eval("ID")%> ></asp:LinkButton><i><asp:LinkButton runat="server" ID="lbDel" CommandName="btnDel" CssClass="zs-btn-del" CommandArgument=<%#Eval("ID")%> ></asp:LinkButton></i><br /><asp:Literal ID="ltLastLoginTime" runat="server"></asp:Literal><span class="line"></span><asp:Literal ID="ltLastLoginIP" runat="server"></asp:Literal></li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <div class="zs-module fixed" style=" margin-left: 512px; width: 490px;">
            <h2 class="title">用户编辑</h2>
            <div class="zs-form clear">
                <b>
                    <label for="">所属角色</label>
                    <div class="zs-ddl">
                        <asp:DropDownList ID="ddlRoleID" runat="server"></asp:DropDownList>
                    </div>  
                </b>
                <b>
                    <label for="">名称</label>
                    <asp:TextBox ID="tbUserName" runat="server" class="zs-input normal" datatype="*2-20" ajaxurl="/ashx/ajax_check.ashx?action=checkUserName"></asp:TextBox>
                </b>
                <b>
                    <label for="">昵称</label>
                    <asp:TextBox ID="tbNickName" runat="server" class="zs-input normal" datatype="*2-10"></asp:TextBox>
                </b>
                <b>
                    <label for="">密码</label>
                    <asp:TextBox ID="tbUserPwd" runat="server" TextMode="Password " CssClass="zs-input normal" datatype="*4-20"></asp:TextBox>
                </b>
                <b>
                    <label for="">确认密码</label>
                    <asp:TextBox ID="tbCheckPwd" runat="server" TextMode="Password" CssClass="zs-input normal" datatype="*4-20" recheck="tbUserPwd" errormsg="密码与确认密码不一致！"></asp:TextBox>
                </b>
                <b>
                    <label for="">状态</label>
                    <div class="zs-radiobutton-list">
                        <asp:RadioButtonList ID="rblIsCheck" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="0">禁用</asp:ListItem>
                            <asp:ListItem Selected="True" Value="1">启用</asp:ListItem>
                        </asp:RadioButtonList>
                    </div>
                </b>
                <b>
                    <label for=""></label>
                    <asp:Button ID="btnSubmit" runat="server" Text="提交" class="zs-btn" OnClick="btnSubmit_Click"/>
                </b>
            </div>
       </div>
    </div>
    </form>
</body>
</html>

