<?php


namespace app\admin\controller;


use think\Controller;
use think\exception\HttpResponseException;

class Admin extends Controller
{

    protected function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        $admin = session('admin');
        // 这里的session 是当用户登录成功后创建的一个session 如果没有的话就代表没有用户登录
        // var_dump($uid);
        if($admin == null || $admin == "" || $admin == "null" || $admin == 0){
            throw new HttpResponseException(error("未登录"));
        }
        if(!$this->auth($admin)){
            throw new HttpResponseException(error("没有权限",1));
        }

    }
    private function auth($admin){
        $request= \think\Request::instance();

//        $module = $request->module();//模块名

        $controller = $request->controller();//控制器名

        $action = $request->action();//方法名
        $authGroup = [
            0=>[
                'Advert'=>[
                    'getlist'=>true,
                    'add'=>true,
                    'update'=>true,
                    'delete'=>true,
                ],
                'Api'=>[
                    'upload_qiniu'=>true,
                    'upload'=>true
                ],
                'Comment'=>[
                    'getlist'=>true,
                    'del'=>true,
                ],
                'Config'=>[
                    'getconfig'=>true,
                    'setconfig'=>true,
                ],
                'Manager'=>[
                    'getlist'=>true,
                    'adduser'=>true,
                    'updateuser'=>true,
                    'deleteuser'=>true,
                    'log'=>true,

                ],
                'Type'=>[
                    'getlist'=>true,
                    'addtype'=>true,
                    'updatetype'=>true,
                    'delete'=>true,
                ],
                'Update'=>[
                    'getlist'=>true,
                    'add'=>true,
                    'update'=>true,
                    'delete'=>true,
                ],
                'User'=>[
                    'getlist'=>true,
                    'deleteuser'=>true,
                    'updateuser'=>true,
                    'userlog'=>true,
                ],
                'Video'=>[
                    'getlist'=>true,
                    'deletevideo'=>true,
                    'updatevideo'=>true,
                ]
            ],
            1=>[
                'Advert'=>[
                    'getlist'=>true,
                    'add'=>false,
                    'update'=>false,
                    'delete'=>false,
                ],
                'Api'=>[
                    'upload_qiniu'=>false,
                    'upload'=>false
                ],
                'Comment'=>[
                    'getlist'=>true,
                    'del'=>false,
                ],
                'Config'=>[
                    'getconfig'=>false,
                    'setconfig'=>false,
                ],
                'Manager'=>[
                    'getlist'=>false,
                    'adduser'=>false,
                    'updateuser'=>false,
                    'deleteuser'=>false,
                    'log'=>false,

                ],
                'Type'=>[
                    'getlist'=>true,
                    'addtype'=>false,
                    'updatetype'=>false,
                    'delete'=>false,
                ],
                'Update'=>[
                    'getlist'=>true,
                    'add'=>false,
                    'update'=>false,
                    'delete'=>false,
                ],
                'User'=>[
                    'getlist'=>true,
                    'deleteuser'=>false,
                    'updateuser'=>false,
                    'userlog'=>false,
                ],
                'Video'=>[
                    'getlist'=>true,
                    'deletevideo'=>false,
                    'updatevideo'=>false,
                ]
            ],2=>[
                'Advert'=>[
                    'getlist'=>true,
                    'add'=>true,
                    'update'=>true,
                    'delete'=>true,
                ],
                'Api'=>[
                    'upload_qiniu'=>true,
                    'upload'=>true
                ],
                'Comment'=>[
                    'getlist'=>true,
                    'del'=>true,
                ],
                'Config'=>[
                    'getconfig'=>false,
                    'setconfig'=>false,
                ],
                'Manager'=>[
                    'getlist'=>false,
                    'adduser'=>false,
                    'updateuser'=>false,
                    'deleteuser'=>false,
                    'log'=>false,

                ],
                'Type'=>[
                    'getlist'=>true,
                    'addtype'=>true,
                    'updatetype'=>true,
                    'delete'=>true,
                ],
                'Update'=>[
                    'getlist'=>true,
                    'add'=>false,
                    'update'=>false,
                    'delete'=>false,
                ],
                'User'=>[
                    'getlist'=>true,
                    'deleteuser'=>true,
                    'updateuser'=>true,
                    'userlog'=>true,
                ],
                'Video'=>[
                    'getlist'=>true,
                    'deletevideo'=>true,
                    'updatevideo'=>true,
                ]
            ]
        ];
        if(!$admin['group']||!in_array($admin['group']['role'],[0,1,2])){
            return false;
        }
        $role = $admin['group']['role'];

        $controllerRole = $authGroup[$role][$controller];

        if(!$controllerRole)
        {
            return false;
        }

        $actionRole = $controllerRole[$action];

        if(!$actionRole){
            return false;
        }

        return true;
    }

}