
function show_produce_bill(json)
{
	$("#produce_detail").find("tr:not(:first)").remove();
	if (!json)
	{
		return;
	}	
	data = json.data;
	if(!data || data.length == 0)
	{
		return;
	}
	g_token = json.token;
	for (var i = 0; i < data.length; i++) 
	{
		var tr = "<tr>";
		if (i % 2 == 0)
		{
			tr = "<tr class='alt'>";
		}

		var td = "<td>" + (i+1) + "</td>"
				+ "<td>" + data[i]["code"] + "</td>"
				+ "<td>" + data[i]["name"] + "</td>"
				+ "<td>" + data[i]["spec"] + "</td>"
				+ "<td>" + data[i]["amount"] + "</td>"
				+ "<td>" + data[i]["unit"] + "</td>"
				+ "<td>" + data[i]["notes"] + "</td>"
				+ "</tr>";
		$('#produce_detail').append(tr+td);
	}
}

function get_produce_bill_json(produce_id) 
{
	var token = get_token();
    var json = {
        "service": "web_produce/get_produce_bill",
		"token": token,
		"params":
		{
			"produce_id": produce_id,
		}
    };
    return json;
}

function get_produce_bill(produce_id) 
{
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_produce_bill_json(produce_id)),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			show_produce_bill(json);
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}

function get_produce_auth_json(produce_id) 
{
	var token = get_token();
	var user_name = get_user_name();
    var json = {
        "service": "web_produce/auth_produce",
		"token": token,
		"params":
		{
			"produce_id": produce_id,
			"auditor": user_name
		}
    };
    return json;
}

function do_produce_auth(produce_id) 
{
	if(!confirm("Ҫ󽫲޸"))
	{
		return;
	}
	var user_name = get_user_name();
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_produce_auth_json(produce_id)),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			$("#"+produce_id).html("");	
			$("#A_"+produce_id).text(user_name);
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}

function show_produce(json)
{
	$("#customers").find("tr:not(:first)").remove();
	if (!json)
	{
		return;
	}	
	data = json.data;
	if(!data || data.length == 0)
	{
		return;
	}
	g_token = json.token;
	for (var i = 0; i < data.length; i++) 
	{
		var tr = "<tr>";
		if (i % 2 == 0)
		{
			tr = "<tr class='alt'>";
		}
		var id = data[i]["id"];
		var num = data[i]["num"];
		var start_time = data[i]["sc_start_time"];
		var end_time = data[i]["sc_end_time"];

		var warn = "";
		var percent = data[i]["progress"];
		var cur_percent = get_cur_percent(get_date(start_time), get_date(end_time));
		var dif_str = "";
		if(cur_percent <=0 || cur_percent > 100) //ûʼѾ
		{
			if(cur_percent > 100 && percent < 99.5) //û
			{
				warn = " class='warn' ";
			}
		}
		else
		{
			dif = cur_percent - percent;
			if(dif >=10) //10%
			{
				warn = " class='warn' ";
			}
			dif_str = " / " + (-dif).toFixed(1);			
		}
		
		var td = "<td>" + (i+1) + "</td>"
				+ "<td><a href='#' onclick=\"show_dlg(" + id + ",'" + num + "')\">" + num + "</a>" + "</td>"
				+ "<td>" + data[i]["order_num"] + "</td>"
				+ "<td>" + date_part(start_time) + "</td>"
				+ "<td>" + date_part(end_time) + "</td>"
				+ "<td" + warn +">" + percent.toFixed(1) + dif_str + "%</td>"
				+ "<td>" + data[i]["producer"] + "</td>"
				+ "<td>" + data[i]["auditor"] + "</td>"
				+ "<td>" + data[i]["notes"] + "</td>"
				+ "</tr>";
		$('#customers').append(tr+td);
	}
}

function get_sch_produce_json() 
{
	var token = get_token();
//	var val=get_opt_val("ord_status");
	var service = "web_produce/get_produce_list";
	var end_time = $("#e_day").val() + " 23:59:59"; //ʱ
	
    var json = {
        "service": service,
		"token": token,
		"params":
		{
			"begin_time": $("#s_day").val(),
			"end_time": end_time
		}
    };
    return json;
}

function search_produce() 
{
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_sch_produce_json()),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			show_produce(json);
			
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}

function show_rpt(json)
{
	$("#customers").find("tr:not(:first)").remove();
	if (!json)
	{
		return;
	}	
	var opt=get_opt_val("ord_status");	
	var chart_title = "Ʒͳ";
	if(opt == "1")
	{
		chart_title = "ԭͳ";
	}
	data = json.data;
	if(!data || data.length == 0)
	{
		$('#customers').append("<tr><td colspan='18' align='center'>û</td></tr>");
		rpt_chart("rpt_chart", chart_title, new Array(0,0,0,0,0,0,0,0,0,0,0,0));
		return;
	}
	
	g_token = json.token;
	for (var i = 0; i < data.length; i++) 
	{
		var tr = "<tr>";
		if (i % 2 == 0)
		{
			tr = "<tr class='alt'>";
		}

		var td = "<td>" + (i+1) + "</td>"
				+ "<td>" + data[i]["code"] + "</td>"
				+ "<td>" + data[i]["name"] + "</td>"
				+ "<td>" + data[i]["spec"] + "</td>"
				+ "<td>" + data[i]["unit"] + "</td>"
				+ "<td>" + data[i]["m1"] + "</td>"
				+ "<td>" + data[i]["m2"] + "</td>"
				+ "<td>" + data[i]["m3"] + "</td>"
				+ "<td>" + data[i]["m4"] + "</td>"
				+ "<td>" + data[i]["m5"] + "</td>"
				+ "<td>" + data[i]["m6"] + "</td>"
				+ "<td>" + data[i]["m7"] + "</td>"
				+ "<td>" + data[i]["m8"] + "</td>"
				+ "<td>" + data[i]["m9"] + "</td>"
				+ "<td>" + data[i]["m10"] + "</td>"
				+ "<td>" + data[i]["m11"] + "</td>"
				+ "<td>" + data[i]["m12"] + "</td>"
				+ "<td>" + data[i]["t_amount"] + "</td>"
				+ "</tr>";
		$('#customers').append(tr+td);
	}
	var sum_data = sum_cols("customers", 5, 13);
	rpt_chart("rpt_chart", chart_title, sum_data);
}

function get_rpt_produce_json() 
{
	var token = get_token();

	var val=get_opt_val("ord_status");	
	var year = $("#rpt_year").val();
	
	var service = "web_produce/rpt_produce_year";
	if(val == "1")
	{
		service = "web_produce/rpt_produce_mat";
	}
    var json = {
        "service": service,
		"token": token,
		"params":
		{
			"year": year
		}
    };
    return json;
}

function rpt_produce() 
{
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_rpt_produce_json()),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			show_rpt(json);
			
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}

