Scriptname aaaLanifBannerToggleScript extends ObjectReference

ObjectReference[] Property displayObjects auto
; 00 Whiterun       75
; 01 Stormcloak     -
; 02 Imperial       10
; 03 Dawnguard      16
; 04 WinterholdC    5
; 05 TG             8
; 06 Nightingale    25
; 07 DB             50
; 08 SOV            40
; 09 Dwe            0

; 10 Sol            85
; 11 Rif            15
; 12 Fal            33
; 13 Dawn           33
; 14 Mor            33
; 15 Win            33

auto State Ready
	Event OnActivate(ObjectReference akActionRef)
		GoToState("Busy")
		If (displayObjects)
			displayBanner()
		EndIf
		GoToState("Ready")
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState

Function displayBanner()
	Int iElementLength = displayObjects.Length
	Int i = 0
	While (i < iElementLength)
		If (displayObjects[i].IsEnabled())
			displayObjects[i].Disable()
			If (i >= iElementLength - 1)
				; Do Nothing
			Else
				displayObjects[i + 1].Enable()
			EndIf
			Return
		EndIf
		i += 1
	EndWhile
	displayObjects[0].Enable()
	Return
EndFunction
