Scriptname aaaLanifDisplayArmorScript extends ObjectReference

ObjectReference Property toggleMarker auto
Armor Property displayItem auto
Message Property failMessage auto
Bool property fadeFlg = False auto
Float property waitTime = 1.0 auto

Event OnInit()
	If (toggleMarker.IsDisabled())
		GoToState("WaitingForPlacement")
	Else
		GoToState("WaitingForPickup")
	EndIf
EndEvent

; Disable -> Enable
auto State WaitingForPlacement
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			If (Game.GetPlayer().GetItemCount(displayItem) >= 1)
				Game.GetPlayer().RemoveItem(displayItem, 1)
				toggleMarker.Enable()
				GetLinkedRef().EnableNoWait(fadeFlg)
				Utility.Wait(waitTime)
				GoToState("WaitingForPickup")
			Else
				failMessage.Show()
				Utility.Wait(waitTime)
				GoToState("WaitingForPlacement")
			EndIf
		EndIf
	EndEvent
EndState

; Enable -> Disable
State WaitingForPickup
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			Game.GetPlayer().AddItem(displayItem, 1)
			toggleMarker.Disable()
			GetLinkedRef().DisableNoWait(fadeFlg)
			Utility.Wait(waitTime)
			GoToState("WaitingForPlacement")
		EndIf
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState