Scriptname aaaLanifDisplayBookScript02 extends ObjectReference

ObjectReference[] Property toggleMarkers auto
Book[] Property displayItems auto
Message Property failMessage auto
Bool property fadeFlg = False auto
Float property waitTime = 1.0 auto

Event OnInit()
	If (checkMarker())
		GoToState("WaitingForPickup")
	Else
		GoToState("WaitingForPlacement")
	EndIf
EndEvent

; Disable -> Enable
auto State WaitingForPlacement
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			If (checkItemCount())
				GetLinkedRef().EnableNoWait(fadeFlg)
				Utility.Wait(waitTime)
				GoToState("WaitingForPickup")
			Else
				failMessage.Show()
				Utility.Wait(waitTime)
				GoToState("WaitingForPlacement")
			EndIf
		EndIf
	EndEvent
EndState

; Enable -> Disable
State WaitingForPickup
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			getPlaceItem()
			GetLinkedRef().DisableNoWait(fadeFlg)
			Utility.Wait(waitTime)
			GoToState("WaitingForPlacement")
		EndIf
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState

Bool Function checkMarker()
	Int iElementLength = toggleMarkers.Length
	Int i = 0
	While (i < iElementLength)
		If (toggleMarkers[i].isEnabled())
			Return True
		EndIf
		i += 1
	EndWhile
	Return False
EndFunction

Bool Function checkItemCount()
	Int iElementLength = displayItems.Length
	Int i = 0
	While (i < iElementLength)
		If (Game.GetPlayer().GetItemCount(displayItems[i]) >= 1)
			Game.GetPlayer().RemoveItem(displayItems[i], 1)
			toggleMarkers[i].Enable()
			Return True
		EndIf
		i += 1
	EndWhile
	Return False
EndFunction

Function getPlaceItem()
	Int iElementLength = toggleMarkers.Length
	Int i = 0
	While (i < iElementLength)
		If (toggleMarkers[i].isEnabled())
			Game.GetPlayer().AddItem(displayItems[i], 1)
			toggleMarkers[i].Disable()
			Return
		EndIf
		i += 1
	EndWhile
EndFunction