Scriptname aaaLanifDisplayDTBQuestScript extends ObjectReference

ObjectReference Property toggleMarker_1 auto
ObjectReference Property toggleMarker_2 auto
ObjectReference[] Property displayObjects_1 auto
ObjectReference[] Property displayObjects_2 auto
ObjectReference Property cheatFlgMarker auto
Quest Property targetQuest_1 auto
Quest Property targetQuest_2 auto
Message Property failMessage auto
Float property waitTime = 1.5 auto

auto State Ready
	Event OnActivate(ObjectReference akActionRef)
		GoToState("Busy")
		If (cheatFlgMarker != None && cheatFlgMarker.IsEnabled())
			If (toggleMarker_1.IsDisabled() && toggleMarker_2.IsDisabled())
				toggleMarker_1.Enable()
				displayEnableAll(displayObjects_1)
				toggleMarker_2.Disable()
				displayDisableAll(displayObjects_2)
			ElseIf (toggleMarker_1.IsEnabled())
				toggleMarker_1.Disable()
				displayDisableAll(displayObjects_1)
				toggleMarker_2.Enable()
				displayEnableAll(displayObjects_2)
			Else
				toggleMarker_1.Disable()
				displayDisableAll(displayObjects_1)
				toggleMarker_2.Disable()
				displayDisableAll(displayObjects_2)
			EndIf
		ElseIf (targetQuest_1.IsCompleted())
			toggleMarker_2.Disable()
			displayDisableAll(displayObjects_2)
			If (toggleMarker_1.IsDisabled())
				toggleMarker_1.Enable()
				displayEnableAll(displayObjects_1)
			Else
				toggleMarker_1.Disable()
				displayDisableAll(displayObjects_1)
			EndIf
		ElseIf (targetQuest_2.IsCompleted())
			toggleMarker_1.Disable()
			displayDisableAll(displayObjects_1)
			If (toggleMarker_2.IsDisabled())
				toggleMarker_2.Enable()
				displayEnableAll(displayObjects_2)
			Else
				toggleMarker_2.Disable()
				displayDisableAll(displayObjects_2)
			EndIf
		Else
			failMessage.Show()
		EndIf
		Utility.Wait(waitTime)
		GoToState("Ready")
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState

Function displayEnableAll(ObjectReference[] akObjectArray)
	Int iElementLength = akObjectArray.Length
	Int i = 0
	While (i < iElementLength)
		akObjectArray[i].EnableNoWait(True)
		i += 1
	EndWhile
EndFunction

Function displayDisableAll(ObjectReference[] akObjectArray)
	Int iElementLength = akObjectArray.Length
	Int i = 0
	While (i < iElementLength)
		akObjectArray[i].DisableNoWait(True)
		i += 1
	EndWhile
EndFunction