Scriptname aaaLanifDisplayMaskMiraakScript extends ObjectReference

ObjectReference Property toggleMarker auto
ObjectReference Property DLC2MKMiraakMask1LMarker auto
ObjectReference Property DLC2MKMiraakMask2LMarker auto
ObjectReference Property DLC2MKMiraakMask3LMarker auto
ObjectReference Property DLC2MKMiraakMask1HMarker auto
ObjectReference Property DLC2MKMiraakMask2HMarker auto
ObjectReference Property DLC2MKMiraakMask3HMarker auto
Armor Property DLC2MKMiraakMask1L auto
Armor Property DLC2MKMiraakMask2L auto
Armor Property DLC2MKMiraakMask3L auto
Armor Property DLC2MKMiraakMask1H auto
Armor Property DLC2MKMiraakMask2H auto
Armor Property DLC2MKMiraakMask3H auto

Message Property failMessage auto
Bool property fadeFlg = False auto
Float property waitTime = 1.0 auto

Event OnInit()
	If (toggleMarker.IsDisabled())
		GoToState("WaitingForPlacement")
	Else
		GoToState("WaitingForPickup")
	EndIf
EndEvent

; Disable -> Enable
auto State WaitingForPlacement
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			If (Game.GetPlayer().GetItemCount(DLC2MKMiraakMask1L) >= 1)
				Game.GetPlayer().RemoveItem(DLC2MKMiraakMask1L, 1)
				DLC2MKMiraakMask1LMarker.Enable()
			ElseIf (Game.GetPlayer().GetItemCount(DLC2MKMiraakMask1H) >= 1)
				Game.GetPlayer().RemoveItem(DLC2MKMiraakMask1H, 1)
				DLC2MKMiraakMask1HMarker.Enable()
			ElseIf (Game.GetPlayer().GetItemCount(DLC2MKMiraakMask2L) >= 1)
				Game.GetPlayer().RemoveItem(DLC2MKMiraakMask2L, 1)
				DLC2MKMiraakMask2LMarker.Enable()
			ElseIf (Game.GetPlayer().GetItemCount(DLC2MKMiraakMask2H) >= 1)
				Game.GetPlayer().RemoveItem(DLC2MKMiraakMask2H, 1)
				DLC2MKMiraakMask2HMarker.Enable()
			ElseIf (Game.GetPlayer().GetItemCount(DLC2MKMiraakMask3L) >= 1)
				Game.GetPlayer().RemoveItem(DLC2MKMiraakMask3L, 1)
				DLC2MKMiraakMask3LMarker.Enable()
			ElseIf (Game.GetPlayer().GetItemCount(DLC2MKMiraakMask3H) >= 1)
				Game.GetPlayer().RemoveItem(DLC2MKMiraakMask3H, 1)
				DLC2MKMiraakMask3HMarker.Enable()
			Else
				failMessage.Show()
				Utility.Wait(waitTime)
				GoToState("WaitingForPlacement")
				Return
			EndIf
			toggleMarker.Enable()
			GetLinkedRef().EnableNoWait(fadeFlg)
			Utility.Wait(waitTime)
			GoToState("WaitingForPickup")
		EndIf
	EndEvent
EndState

; Enable -> Disable
State WaitingForPickup
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			If (DLC2MKMiraakMask1LMarker.IsEnabled())
				Game.GetPlayer().AddItem(DLC2MKMiraakMask1L, 1)
				DLC2MKMiraakMask1LMarker.Disable()
			ElseIf (DLC2MKMiraakMask1HMarker.IsEnabled())
				Game.GetPlayer().AddItem(DLC2MKMiraakMask1H, 1)
				DLC2MKMiraakMask1HMarker.Disable()
			ElseIf (DLC2MKMiraakMask2LMarker.IsEnabled())
				Game.GetPlayer().AddItem(DLC2MKMiraakMask2L, 1)
				DLC2MKMiraakMask2LMarker.Disable()
			ElseIf (DLC2MKMiraakMask2HMarker.IsEnabled())
				Game.GetPlayer().AddItem(DLC2MKMiraakMask2H, 1)
				DLC2MKMiraakMask2HMarker.Disable()
			ElseIf (DLC2MKMiraakMask3LMarker.IsEnabled())
				Game.GetPlayer().AddItem(DLC2MKMiraakMask3L, 1)
				DLC2MKMiraakMask3LMarker.Disable()
			ElseIf (DLC2MKMiraakMask3HMarker.IsEnabled())
				Game.GetPlayer().AddItem(DLC2MKMiraakMask3H, 1)
				DLC2MKMiraakMask3HMarker.Disable()
			EndIf
			toggleMarker.Disable()
			GetLinkedRef().DisableNoWait(fadeFlg)
			Utility.Wait(waitTime)
			GoToState("WaitingForPlacement")
		EndIf
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState