Scriptname aaaLanifDisplayMaskScript extends ObjectReference

ObjectReference Property toggleMarker auto
Armor Property myMask auto
Message Property failMessage auto



Event OnInit()
	If (toggleMarker.IsDisabled())
		GetLinkedRef().PlayAnimation("off")
		GoToState("WaitingForPlacement")
	Else
		GetLinkedRef().PlayAnimation("on")
		GoToState("WaitingForPickup")
	EndIf
EndEvent

; Disable -> Enable
auto State WaitingForPlacement
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			If (Game.GetPlayer().GetItemCount(myMask) >= 1)
				Game.GetPlayer().RemoveItem(myMask, 1)
				toggleMarker.Enable()
				GetLinkedRef().PlayAnimationAndWait("on", "TransOn")
				GoToState("WaitingForPickup")
			Else
				failMessage.Show()
				GoToState("WaitingForPlacement")
			EndIf
		EndIf
	EndEvent
EndState

; Enable -> Disable
State WaitingForPickup
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			Game.GetPlayer().AddItem(myMask, 1)
			toggleMarker.Disable()
			GetLinkedRef().PlayAnimationAndWait("off", "TransOff")
			GoToState("WaitingForPlacement")
		EndIf
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState