Scriptname aaaLanifDisplayParagonScript extends ObjectReference

ObjectReference Property toggleMarker auto
MiscObject Property portalGemKey auto
Message Property failMessage auto
String Property placeString auto
String Property takeString auto

Event OnInit()
	If (toggleMarker.IsDisabled())
		self.PlayAnimation(takeString)
		GoToState("WaitingForPlacement")
	Else
		self.PlayAnimation(placeString)
		GoToState("WaitingForPickup")
	EndIf
EndEvent

; Disable -> Enable
auto State WaitingForPlacement
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			If (Game.GetPlayer().GetItemCount(portalGemKey) >= 1)
				Game.GetPlayer().RemoveItem(portalGemKey, 1)
				toggleMarker.Enable()
				self.PlayAnimationAndWait(placeString, "Done")
				GoToState("WaitingForPickup")
			Else
				failMessage.Show()
				GoToState("WaitingForPlacement")
			EndIf
		EndIf
	EndEvent
EndState

; Enable -> Disable
State WaitingForPickup
	Event OnActivate(ObjectReference akActionRef)
		If (akActionRef == Game.GetPlayer())
			GoToState("Busy")
			Game.GetPlayer().AddItem(portalGemKey, 1)
			toggleMarker.Disable()
			self.PlayAnimationAndWait(takeString, "Done")
			GoToState("WaitingForPlacement")
		EndIf
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState