Scriptname aaaLanifDisplayQuestScript extends ObjectReference

ObjectReference Property toggleMarker auto
ObjectReference[] Property displayObjects auto
ObjectReference Property cheatFlgMarker auto
Quest Property targetQuest auto
Message Property failMessage auto
Float property waitTime = 1.0 auto

auto State Ready
	Event OnActivate(ObjectReference akActionRef)
		GoToState("Busy")
		If (targetQuest == None || targetQuest.IsCompleted() || (cheatFlgMarker != None && cheatFlgMarker.IsEnabled()))
			If (toggleMarker.IsDisabled())
				toggleMarker.Enable()
				If (displayObjects)
					displayEnableAll()
				EndIf
			Else
				toggleMarker.Disable()
				If (displayObjects)
					displayDisableAll()
				EndIf
			EndIf
		Else
			failMessage.Show()
		EndIf
		Utility.Wait(waitTime)
		GoToState("Ready")
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState

Function displayEnableAll()
	Int iElementLength = displayObjects.Length
	Int i = 0
	While (i < iElementLength)
		displayObjects[i].EnableNoWait(True)
		i += 1
	EndWhile
EndFunction

Function displayDisableAll()
	Int iElementLength = displayObjects.Length
	Int i = 0
	While (i < iElementLength)
		displayObjects[i].DisableNoWait(True)
		i += 1
	EndWhile
EndFunction