Scriptname aaaLanifToggleAnimationScript extends ObjectReference

ObjectReference Property toggleMarker auto
ObjectReference[] Property displayObjects auto
Message Property enableMessage auto
Message Property disableMessage auto
String Property triggerOnString auto
String Property triggerOffString auto
String Property transOnString auto
String Property transOffString auto
Bool Property bMagicFirePillar auto

Event OnLoad()
	If (toggleMarker.IsDisabled())
		If (bMagicFirePillar)
			GetLinkedRef().SetAnimationVariableFloat("fmagicburnamount", 0)
		Else
			GetLinkedRef().PlayAnimation(triggerOffString)
		EndIf
		GoToState("ReadyTriggerOff")
	Else
		If (bMagicFirePillar)
			GetLinkedRef().SetAnimationVariableFloat("fmagicburnamount", 1)
		Else
			GetLinkedRef().PlayAnimation(triggerOnString)
		EndIf
		GoToState("ReadyTriggerOn")
	EndIf
EndEvent

State ReadyTriggerOff
	Event OnActivate(ObjectReference akActionRef)
		GoToState("Busy")
		If (enableMessage)
			enableMessage.Show()
		EndIf
		toggleMarker.Enable()
		If (displayObjects)
			displayEnableAll()
		EndIf
		If (bMagicFirePillar)
			GetLinkedRef().SetAnimationVariableFloat("fmagicburnamount", 1)
		Else
			GetLinkedRef().PlayAnimationAndWait(triggerOnString, transOnString)
		EndIf
		GoToState("ReadyTriggerOn")
	EndEvent
EndState

State ReadyTriggerOn
	Event OnActivate(ObjectReference akActionRef)
		GoToState("Busy")
		If (disableMessage)
			disableMessage.Show()
		EndIf
		toggleMarker.Disable()
		If (displayObjects)
			displayDisableAll()
		EndIf
		If (bMagicFirePillar)
			GetLinkedRef().SetAnimationVariableFloat("fmagicburnamount", 0)
		Else
			GetLinkedRef().PlayAnimationAndWait(triggerOffString, transOffString)
		EndIf
		GoToState("ReadyTriggerOff")
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState

Function displayEnableAll()
	Int iElementLength = displayObjects.Length
	Int i = 0
	While (i < iElementLength)
		displayObjects[i].EnableNoWait(True)
		i += 1
	EndWhile
EndFunction

Function displayDisableAll()
	Int iElementLength = displayObjects.Length
	Int i = 0
	While (i < iElementLength)
		displayObjects[i].DisableNoWait(True)
		i += 1
	EndWhile
EndFunction