Scriptname aaaLanifToggleScript extends ObjectReference

ObjectReference Property toggleMarker auto
ObjectReference[] Property displayObjects auto
Message Property enableMessage auto
Message Property disableMessage auto
String Property triggerOnString auto
String Property triggerOffString auto
String Property transOnString auto
String Property transOffString auto
Bool flipFlg

auto State Ready
	Event OnActivate(ObjectReference akActionRef)
		GoToState("Busy")
		If (toggleMarker.IsDisabled())
			If (enableMessage)
				enableMessage.Show()
			EndIf
			toggleMarker.Enable()
			If (displayObjects)
				displayEnableAll()
			EndIf
			Animation()
		Else
			If (disableMessage)
				disableMessage.Show()
			EndIf
			toggleMarker.Disable()
			If (displayObjects)
				displayDisableAll()
			EndIf
			Animation()
		EndIf
		GoToState("Ready")
	EndEvent
EndState

State Busy
	Event OnActivate(ObjectReference akActionRef)
		; Do Nothing
	EndEvent
EndState

Function Animation()
	If (flipFlg)
		If (triggerOffString && transOffString)
			self.PlayAnimationAndWait(triggerOffString, transOffString)
		EndIf
	Else
		If (triggerOnString && transOnString)
			self.PlayAnimationAndWait(triggerOnString, transOnString)
		EndIf
	EndIf
	flipFlg = !flipFlg
EndFunction

Function displayEnableAll()
	Int iElementLength = displayObjects.Length
	Int i = 0
	While (i < iElementLength)
		displayObjects[i].EnableNoWait(True)
		i += 1
	EndWhile
EndFunction

Function displayDisableAll()
	Int iElementLength = displayObjects.Length
	Int i = 0
	While (i < iElementLength)
		displayObjects[i].DisableNoWait(True)
		i += 1
	EndWhile
EndFunction