/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import java.awt.Color;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;
import vazkii.neat.NeatConfig;

public class HealthBarRenderer {
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!NeatConfig.renderInF1 && !Minecraft.func_71382_s()) {
            return;
        }
        Entity cameraEntity = mc.func_175606_aa();
        BlockPos renderingVector = cameraEntity.func_180425_c();
        Frustum frustum = new Frustum();
        double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)event.partialTicks;
        double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)event.partialTicks;
        double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)event.partialTicks;
        frustum.func_78547_a(viewX, viewY, viewZ);
        WorldClient client = mc.field_71441_e;
        Set entities = (Set)ReflectionHelper.getPrivateValue(WorldClient.class, (Object)client, (String[])new String[]{"entityList", "field_73032_d", "J"});
        for (Entity entity : entities) {
            if (entity == null || !(entity instanceof EntityLiving) || !entity.func_145770_h((double)renderingVector.func_177958_n(), (double)renderingVector.func_177956_o(), (double)renderingVector.func_177952_p()) || !entity.field_70158_ak && !frustum.func_78546_a(entity.func_174813_aQ()) || !entity.func_70089_S()) continue;
            this.renderHealthBar((EntityLivingBase)((EntityLiving)entity), event.partialTicks, cameraEntity);
        }
    }

    public void renderHealthBar(EntityLivingBase passedEntity, float partialTicks, Entity viewPoint) {
        if (passedEntity.field_70153_n != null) {
            return;
        }
        EntityLivingBase entity = passedEntity;
        while (entity.field_70154_o != null && entity.field_70154_o instanceof EntityLivingBase) {
            entity = (EntityLivingBase)entity.field_70154_o;
        }
        Minecraft mc = Minecraft.func_71410_x();
        float pastTranslate = 0.0f;
        while (entity != null) {
            Entity riddenBy;
            float distance = passedEntity.func_70032_d(viewPoint);
            if (!(distance > (float)NeatConfig.maxDistance || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || !NeatConfig.showOnBosses && entity instanceof IBossDisplayData || !NeatConfig.showOnPlayers && entity instanceof EntityPlayer)) {
                double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
                double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
                double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
                float scale = 0.026666673f;
                float maxHealth = entity.func_110138_aP();
                float health = Math.min(maxHealth, entity.func_110143_aJ());
                if (!(maxHealth <= 0.0f)) {
                    float namel;
                    boolean useHue;
                    float percent = (int)(health / maxHealth * 100.0f);
                    RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)(x - renderManager.field_78730_l)), (float)((float)(y - renderManager.field_78731_m + (double)passedEntity.field_70131_O + NeatConfig.heightAbove)), (float)((float)(z - renderManager.field_78728_n)));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    WorldRenderer worldRenderer = tessellator.func_178180_c();
                    float padding = NeatConfig.backgroundPadding;
                    int bgHeight = NeatConfig.backgroundHeight;
                    int barHeight = NeatConfig.barHeight;
                    float size = NeatConfig.plateSize;
                    int r = 0;
                    int g = 255;
                    int b = 0;
                    ItemStack stack = null;
                    if (entity instanceof IMob) {
                        r = 255;
                        g = 0;
                        EnumCreatureAttribute attr = entity.func_70668_bt();
                        switch (attr) {
                            case ARTHROPOD: {
                                stack = new ItemStack(Items.field_151070_bp);
                                break;
                            }
                            case UNDEAD: {
                                stack = new ItemStack(Items.field_151078_bh);
                                break;
                            }
                            default: {
                                stack = new ItemStack(Items.field_151144_bL, 1, 4);
                            }
                        }
                    }
                    if (entity instanceof IBossDisplayData) {
                        stack = new ItemStack(Items.field_151144_bL);
                        size = NeatConfig.plateSizeBoss;
                        r = 128;
                        g = 0;
                        b = 128;
                    }
                    int armor = entity.func_70658_aO();
                    boolean bl = useHue = !NeatConfig.colorByType;
                    if (useHue) {
                        float hue = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
                        Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                        r = color.getRed();
                        g = color.getGreen();
                        b = color.getBlue();
                    }
                    GlStateManager.func_179109_b((float)0.0f, (float)pastTranslate, (float)0.0f);
                    float s = 0.5f;
                    String name = StatCollector.func_74838_a((String)("entity." + EntityList.func_75621_b((Entity)entity) + ".name"));
                    if (entity instanceof EntityLiving && ((EntityLiving)entity).func_145818_k_()) {
                        name = EnumChatFormatting.ITALIC + ((EntityLiving)entity).func_95999_t();
                    }
                    if ((namel = (float)mc.field_71466_p.func_78256_a(name) * s) + 20.0f > size * 2.0f) {
                        size = namel / 2.0f + 10.0f;
                    }
                    float healthSize = size * (health / maxHealth);
                    if (NeatConfig.drawBackground) {
                        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                        worldRenderer.func_181662_b((double)(-size - padding), (double)(-bgHeight), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                        worldRenderer.func_181662_b((double)(-size - padding), (double)((float)barHeight + padding), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                        worldRenderer.func_181662_b((double)(size + padding), (double)((float)barHeight + padding), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                        worldRenderer.func_181662_b((double)(size + padding), (double)(-bgHeight), 0.0).func_181669_b(0, 0, 0, 64).func_181675_d();
                        tessellator.func_78381_a();
                    }
                    worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    worldRenderer.func_181662_b((double)(-size), 0.0, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
                    worldRenderer.func_181662_b((double)(-size), (double)barHeight, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
                    worldRenderer.func_181662_b((double)size, (double)barHeight, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
                    worldRenderer.func_181662_b((double)size, 0.0, 0.0).func_181669_b(127, 127, 127, 127).func_181675_d();
                    tessellator.func_78381_a();
                    worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    worldRenderer.func_181662_b((double)(-size), 0.0, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
                    worldRenderer.func_181662_b((double)(-size), (double)barHeight, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
                    worldRenderer.func_181662_b((double)(healthSize * 2.0f - size), (double)barHeight, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
                    worldRenderer.func_181662_b((double)(healthSize * 2.0f - size), 0.0, 0.0).func_181669_b(r, g, b, 127).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(-size), (float)-4.5f, (float)0.0f);
                    GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                    mc.field_71466_p.func_78276_b(name, 0, 0, 0xFFFFFF);
                    GlStateManager.func_179094_E();
                    float s1 = 0.75f;
                    GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
                    int h = NeatConfig.hpTextHeight;
                    String maxHpStr = EnumChatFormatting.BOLD + "" + (double)Math.round((double)maxHealth * 100.0) / 100.0;
                    String hpStr = "" + (double)Math.round((double)health * 100.0) / 100.0;
                    String percStr = (int)percent + "%";
                    if (maxHpStr.endsWith(".0")) {
                        maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 2);
                    }
                    if (hpStr.endsWith(".0")) {
                        hpStr = hpStr.substring(0, hpStr.length() - 2);
                    }
                    if (NeatConfig.showCurrentHP) {
                        mc.field_71466_p.func_78276_b(hpStr, 2, h, 0xFFFFFF);
                    }
                    if (NeatConfig.showMaxHP) {
                        mc.field_71466_p.func_78276_b(maxHpStr, (int)(size / (s * s1) * 2.0f) - 2 - mc.field_71466_p.func_78256_a(maxHpStr), h, 0xFFFFFF);
                    }
                    if (NeatConfig.showPercentage) {
                        mc.field_71466_p.func_78276_b(percStr, (int)(size / (s * s1)) - mc.field_71466_p.func_78256_a(percStr) / 2, h, -1);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int off = 0;
                    s1 = 0.5f;
                    GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
                    GlStateManager.func_179109_b((float)(size / (s * s1) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
                    mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    if (stack != null && NeatConfig.showAttributes) {
                        this.renderIcon(off, 0, stack, 16, 16);
                        off -= 16;
                    }
                    if (armor > 0 && NeatConfig.showArmor) {
                        int i;
                        int ironArmor = armor % 5;
                        int diamondArmor = armor / 5;
                        if (!NeatConfig.groupArmor) {
                            ironArmor = armor;
                            diamondArmor = 0;
                        }
                        stack = new ItemStack((Item)Items.field_151030_Z);
                        for (i = 0; i < ironArmor; ++i) {
                            this.renderIcon(off, 0, stack, 16, 16);
                            off -= 4;
                        }
                        stack = new ItemStack((Item)Items.field_151163_ad);
                        for (i = 0; i < diamondArmor; ++i) {
                            this.renderIcon(off, 0, stack, 16, 16);
                            off -= 4;
                        }
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                    pastTranslate = -((float)(bgHeight + barHeight) + padding);
                }
            }
            if ((riddenBy = entity.field_70153_n) instanceof EntityLivingBase) {
                entity = (EntityLivingBase)riddenBy;
                continue;
            }
            return;
        }
    }

    private void renderIcon(int vertexX, int vertexY, ItemStack stack, int intU, int intV) {
        try {
            IBakedModel iBakedModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
            TextureAtlasSprite textureAtlasSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(iBakedModel.func_177554_e().func_94215_i());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldRenderer = tessellator.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)vertexX, (double)(vertexY + intV), 0.0).func_181673_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
            worldRenderer.func_181662_b((double)(vertexX + intU), (double)(vertexY + intV), 0.0).func_181673_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
            worldRenderer.func_181662_b((double)(vertexX + intU), (double)vertexY, 0.0).func_181673_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
            worldRenderer.func_181662_b((double)vertexX, (double)vertexY, 0.0).func_181673_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

