local metadata = {
"## Interface: FS15 1.1.0.0 RC12",
"## Title: WheelColor",
"## Notes: Specialization fr Anhnger frbt dynamicallyLoaded Reifenfelgen",
"## Author: Marhu",
"## Version: 1.0.0-3",
"## Date: 19.04.2015",
"## Web: http://Marhu.net"
}

WheelColor = {};

function WheelColor.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function WheelColor:load(savegame)
    local color = getXMLString(xmlFile, "vehicle.WheelColor#Color")
    if color then
        local x,y,z,w = Utils.getVectorFromString(color)
        for _, wheel in pairs(self.wheels) do
            local visWheel = getChildAt(wheel.driveNode,0)
            if visWheel and getHasShaderParameter(visWheel,"colorScale") then
                setShaderParameter(visWheel,"colorScale",x,y,z,w,false)
            end;
        end;
    end
end;
function WheelColor:delete()
end;
function WheelColor:mouseEvent(posX, posY, isDown, isUp, button)
end;
function WheelColor:keyEvent(unicode, sym, modifier, isDown)
end;
function WheelColor:update(dt)
end;
function WheelColor:draw()
end;