/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.common;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.domin.DisplayConst;
import com.iflytek.skintool.model.common.StyleData;
import java.util.TreeMap;

public class StyleDataSerializer
extends AbstractBaseSerializer<StyleData> {
    @Override
    public TreeMap<String, String> writeto(StyleData styleData) {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        if (styleData.getTextSize() != 0) {
            attr.put("TEXT_SIZE", String.valueOf(styleData.getTextSize()) + "sp");
        }
        if (styleData.getTextColor() != 0) {
            attr.put("TEXT_COLOR", SerializerUtil.getColorStr(styleData.getTextColor()));
        }
        if (styleData.getTextStyle() != null && styleData.getTextStyle() != StyleData.TextStyle.NORMAL) {
            attr.put("TEXT_STYLE", String.valueOf(styleData.getTextStyle().ordinal()));
        }
        if (styleData.getImageTag() != null) {
            attr.put("IMAGE", this.mListener.redirect(12, styleData.getImageTag(), styleData.getImageData()));
        }
        if (styleData.getBgColor() != DisplayConst.DEFAULT_COLOR) {
            attr.put("BG_COLOR", SerializerUtil.getColorStr(styleData.getBgColor()));
        }
        if (styleData.getImageColor() != 0) {
            attr.put("IMAGE_COLOR", SerializerUtil.getColorStr(styleData.getImageColor()));
        }
        if (styleData.getImageAlpha() != 0) {
            attr.put("ALPHA", Integer.toString(styleData.getImageAlpha()));
        }
        if (styleData.getTextAlign() != null) {
            attr.put("TEXT_ALIGN", Integer.toString(styleData.getTextAlign().ordinal()));
        }
        if (styleData.getTextFloat() != null) {
            attr.put("TEXT_FLOAT", String.valueOf(styleData.getTextFloat().ordinal()));
        }
        if (styleData.getBorderColor() != 0) {
            attr.put("BORDER_COLOR", SerializerUtil.getColorStr(styleData.getBorderColor()));
        }
        return attr;
    }

    @Override
    public boolean isExist(StyleData data) {
        return false;
    }

    @Override
    public String getTag(StyleData data) {
        return data.getTag();
    }
}

