/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.layout;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.interfaces.ISerializerListener;
import com.iflytek.serializer.layout.RowDataSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.RowData;
import com.iflytek.skintool.model.layout.SelectorData;
import com.iflytek.skintool.model.layout.SlidableAreaData;
import java.util.ArrayList;
import java.util.TreeMap;

public class AreaDataSerializer
extends AbstractBaseSerializer<BaseData> {
    private RowDataSerializer mRowDataSerializer = new RowDataSerializer();

    @Override
    public void setListener(ISerializerListener listener) {
        super.setListener(listener);
        this.mRowDataSerializer.setListener(listener);
    }

    @Override
    public TreeMap<String, String> writeto(BaseData object) {
        String tag = object.getTag();
        if (object instanceof SelectorData) {
            ArrayList<String> selectorStr = new ArrayList<String>();
            for (BaseData baseData : ((SelectorData)object).getDataSet()) {
                selectorStr.add(this.serializeData(4, baseData.getTag(), baseData));
            }
            TreeMap<String, String> attr = new TreeMap<String, String>();
            if (selectorStr.size() > 0) {
                attr.put("SELECTOR", SerializerUtil.array2str(selectorStr, ","));
            }
            if (object.getDimensData() != null) {
                attr.put("DIMENS", this.mListener.redirect(8, object.getTag(), object.getDimensData()));
            }
            return attr;
        }
        TreeMap<String, String> attr = new TreeMap<String, String>();
        if (object instanceof AreaData) {
            if (((AreaData)object).getStyle() != null) {
                attr.put("STYLE", this.mListener.redirect(9, "Style_" + object.getTag(), ((AreaData)object).getStyle()));
            }
            if (object.getDimensData() != null) {
                attr.put("DIMENS", this.mListener.redirect(8, "Dimens_" + object.getTag(), object.getDimensData()));
            }
            if (((AreaData)object).getAttrModeStr() != null) {
                attr.put("MODE", ((AreaData)object).getAttrModeStr());
            }
            if (((AreaData)object).getSeparatorStyleData() != null) {
                attr.put("SEPARATOR_STYLE", this.mListener.redirect(9, "Style_" + object.getTag() + "_Separator", ((AreaData)object).getSeparatorStyleData()));
            }
            if (((AreaData)object).getSeparatorDimensData() != null) {
                attr.put("SEPARATOR_DIMENS", this.mListener.redirect(8, "Dimens_" + object.getTag() + "_Separator", ((AreaData)object).getSeparatorDimensData()));
            }
            attr.put("SEPARATOR_LAYOUT", String.valueOf(((AreaData)object).getSeparatorLayoutType().ordinal()));
            attr.put("LAYOUT", String.valueOf(object.getLayoutType().ordinal()));
            if (((AreaData)object).getRowSet() != null) {
                ArrayList<String> rowSetStr = new ArrayList<String>();
                for (RowData rowData : ((AreaData)object).getRowSet()) {
                    rowSetStr.add(this.mRowDataSerializer.serializeData(5, rowData.getTag(), rowData));
                }
                attr.put("ROW_SET", SerializerUtil.array2str(rowSetStr, ","));
            }
            if (((AreaData)object).getContents() != null) {
                attr.put("CONTENT", SerializerUtil.array2str(((AreaData)object).getContents(), ","));
            }
            if (((AreaData)object).getAreaType() != 0) {
                attr.put("AREA_TYPE", String.valueOf(((AreaData)object).getAreaType()));
            }
            if (((AreaData)object).getAnimation() != null) {
                attr.put("ANIMATION", this.mListener.redirect(7, "Anim_" + object.getTag(), ((AreaData)object).getAnimation()));
            }
            if (((AreaData)object).getUp_Fade_Dimens() != null) {
                attr.put("UP_FADE_DIMENS", this.mListener.redirect(8, "Style_Up_Fade_" + tag, ((AreaData)object).getUp_Fade_Dimens()));
            }
            if (((AreaData)object).getUp_Fade_Style() != null) {
                attr.put("UP_FADE_STYLE", this.mListener.redirect(9, "Style_Up_Fade" + tag, ((AreaData)object).getUp_Fade_Style()));
            }
            if (((AreaData)object).getKeyAttribute() != null) {
                attr.put("KEY_TEMPLATE", this.mListener.redirect(6, "Key_" + object.getTag(), ((AreaData)object).getKeyAttribute()));
            }
            attr.put("STYLE_TYPE", String.valueOf(object.getThemeType() & 0xFAFFFFFF));
        }
        if (object instanceof SlidableAreaData) {
            if (((SlidableAreaData)object).getFadeUpStyleData() != null) {
                attr.put("UP_FADE_STYLE", this.mListener.redirect(9, "UP_FADE_STYLE_" + tag, ((SlidableAreaData)object).getFadeUpStyleData()));
            }
            if (((SlidableAreaData)object).getFadeUpDimensData() != null) {
                attr.put("UP_FADE_DIMENS", this.mListener.redirect(8, "UP_FADE_DIMENS_" + tag, ((SlidableAreaData)object).getFadeUpDimensData()));
            }
            if (((SlidableAreaData)object).getFadeDownStyleData() != null) {
                attr.put("DOWN_FADE_STYLE", this.mListener.redirect(9, "DOWN_FADE_STYLE_" + tag, ((SlidableAreaData)object).getFadeDownStyleData()));
            }
            if (((SlidableAreaData)object).getFadeDownDimensData() != null) {
                attr.put("DOWN_FADE_DIMENS", this.mListener.redirect(8, "DOWN_FADE_DIMENS_" + tag, ((SlidableAreaData)object).getFadeDownDimensData()));
            }
            if (((AreaData)object).getAnimation() != null) {
                attr.put("AREA_SLIP_ANIM", this.mListener.redirect(7, "AREA_SLIP_ANIM_" + tag, ((AreaData)object).getAnimation()));
            }
        }
        return attr;
    }

    @Override
    public String toIniString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toIniString());
        sb.append(this.mRowDataSerializer.toIniString());
        return sb.toString();
    }

    @Override
    public boolean isExist(BaseData data) {
        return this.mProps.containsKey(data.getTag());
    }

    @Override
    public String getTag(BaseData data) {
        return "Area_" + this.mProps.size();
    }
}

