/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.theme;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.theme.ThemeAreaData;
import java.util.Collection;
import java.util.TreeMap;

public class ThemeAreaDataSerializer
extends AbstractBaseSerializer<ThemeAreaData> {
    @Override
    public TreeMap<String, String> writeto(ThemeAreaData data) {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        if (data.getTypeAttr() != null) {
            attr.put("TYPE", SerializerUtil.array2str(data.getTypeAttr(), ","));
        }
        if (data.getBackgroundStyle() != null) {
            attr.put("STYLE", this.mListener.redirect(9, data.getBackgroundStyle().getTag(), data.getBackgroundStyle()));
        }
        if (data.getUpFadeStyle() != null) {
            attr.put("UP_FADE_STYLE", this.mListener.redirect(9, data.getUpFadeStyle().getTag(), data.getUpFadeStyle()));
        }
        if (data.getDownFadeStyle() != null) {
            attr.put("DOWN_FADE_STYLE", this.mListener.redirect(9, data.getDownFadeStyle().getTag(), data.getDownFadeStyle()));
        }
        if (data.getSeparatorStyle() != null) {
            attr.put("SEPARATOR_STYLE", this.mListener.redirect(9, data.getSeparatorStyle().getTag(), data.getSeparatorStyle()));
        }
        if (data.getThemeAnimationData() != null) {
            attr.put("ANIMATION", this.mListener.redirect(7, data.getThemeAnimationData().getmAnimationTag(), data.getThemeAnimationData()));
        }
        return attr;
    }

    @Override
    public boolean isExist(ThemeAreaData data) {
        if (this.mProps.size() != 0) {
            Collection values = this.mProps.values();
            String typeStr = SerializerUtil.array2str(data.getTypeAttr(), ",");
            if (typeStr == null) {
                return false;
            }
            for (TreeMap treeMap : values) {
                if (!((String)treeMap.get("TYPE")).equals(typeStr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTag(ThemeAreaData data) {
        if (data.getmThemeAreaTag() != null) {
            return data.getmThemeAreaTag();
        }
        return "Area_" + this.mProps.size();
    }
}

