/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.utils;

import com.iflytek.serializer.common.DimensDataSerializer;
import com.iflytek.serializer.common.ImageDataSerializer;
import com.iflytek.serializer.common.StyleDataSerializer;
import com.iflytek.serializer.interfaces.ISerializerListener;
import com.iflytek.serializer.interfaces.Iniable;
import com.iflytek.serializer.layout.AnimationDataSerializer;
import com.iflytek.serializer.layout.AreaDataSerializer;
import com.iflytek.serializer.layout.BallonDataSerializer;
import com.iflytek.serializer.layout.CandidateDataSerializer;
import com.iflytek.serializer.layout.ComposingDataSerializer;
import com.iflytek.serializer.layout.KeyBoardDataSerializer;
import com.iflytek.serializer.layout.KeyDataSerializer;
import com.iflytek.serializer.layout.LayoutDataSerializer;
import com.iflytek.serializer.theme.ThemeInfoSerializer;
import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.model.layout.LayoutData;
import com.iflytek.skintool.parser.utils.ThemeFileManager;
import com.iflytek.skintool.util.FileUtils;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.PathClass;
import com.iflytek.skintool.util.ThemeUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.TreeMap;

public class LayoutPackageWriter {
    private static final String IL_SUFFIX = ".il";
    private ThemeInfoSerializer mThemeInfoSerializer;
    private AnimationDataSerializer mAnimationSerializer;
    private AreaDataSerializer mAreaDataSerializer;
    private BallonDataSerializer mBallonDataSerializer;
    private CandidateDataSerializer mCandidateDataSerializer;
    private ComposingDataSerializer mComposingDataSerializer;
    private DimensDataSerializer mDimensDataSerializer;
    private ImageDataSerializer mImageDataSerializer;
    private KeyDataSerializer mKeyDataSerializer;
    private KeyBoardDataSerializer mKeyBoardDataSerializer;
    private LayoutDataSerializer mLayoutDataSerializer;
    private StyleDataSerializer mStyleDataSerializer;
    private TreeMap<String, ImageData> mBitmapDatas = ManageUtils.imageDataPoolMap;

    public LayoutPackageWriter() {
        this.init();
        this.setListener(new LayoutPackageListener());
    }

    private void init() {
        this.mThemeInfoSerializer = new ThemeInfoSerializer();
        this.mAnimationSerializer = new AnimationDataSerializer();
        this.mAreaDataSerializer = new AreaDataSerializer();
        this.mBallonDataSerializer = new BallonDataSerializer();
        this.mCandidateDataSerializer = new CandidateDataSerializer();
        this.mComposingDataSerializer = new ComposingDataSerializer();
        this.mDimensDataSerializer = new DimensDataSerializer();
        this.mImageDataSerializer = new ImageDataSerializer();
        this.mKeyDataSerializer = new KeyDataSerializer();
        this.mKeyBoardDataSerializer = new KeyBoardDataSerializer();
        this.mLayoutDataSerializer = new LayoutDataSerializer();
        this.mStyleDataSerializer = new StyleDataSerializer();
    }

    private void setListener(ISerializerListener listener) {
        this.mThemeInfoSerializer.setListener(listener);
        this.mAnimationSerializer.setListener(listener);
        this.mAreaDataSerializer.setListener(listener);
        this.mBallonDataSerializer.setListener(listener);
        this.mCandidateDataSerializer.setListener(listener);
        this.mComposingDataSerializer.setListener(listener);
        this.mDimensDataSerializer.setListener(listener);
        this.mImageDataSerializer.setListener(listener);
        this.mKeyDataSerializer.setListener(listener);
        this.mKeyBoardDataSerializer.setListener(listener);
        this.mLayoutDataSerializer.setListener(listener);
        this.mStyleDataSerializer.setListener(listener);
    }

    public void startParse(LayoutData data) {
        this.mLayoutDataSerializer.serializeData(data);
    }

    public void startParse(List<LayoutData> mLayoutDatas) {
        int i = 0;
        while (i < mLayoutDatas.size()) {
            LayoutData data = mLayoutDatas.get(i);
            this.startParse(data);
            ++i;
        }
        this.mKeyBoardDataSerializer.addOtherProperties("Keyboard_Switch_Menu_Zh", ThemeFileManager.getInstance().getSkinFile(false, "keyboard.ini", 0).get("Keyboard_Switch_Menu_Zh"));
        this.mKeyBoardDataSerializer.addOtherProperties("Keyboard_Switch_Menu_En", ThemeFileManager.getInstance().getSkinFile(false, "keyboard.ini", 0).get("Keyboard_Switch_Menu_En"));
        this.mKeyBoardDataSerializer.addOtherProperties("Keyboard_Switch_Menu_Other", ThemeFileManager.getInstance().getSkinFile(false, "keyboard.ini", 0).get("Keyboard_Switch_Menu_Other"));
        this.mAreaDataSerializer.addOtherProperties("Area_Switch_Menu_Zh", ThemeFileManager.getInstance().getSkinFile(false, "area.ini", 0).get("Area_Switch_Menu_Zh"));
        this.mAreaDataSerializer.addOtherProperties("Area_Switch_Menu_En", ThemeFileManager.getInstance().getSkinFile(false, "area.ini", 0).get("Area_Switch_Menu_En"));
        this.mAreaDataSerializer.addOtherProperties("Area_Switch_Menu_Other", ThemeFileManager.getInstance().getSkinFile(false, "area.ini", 0).get("Area_Switch_Menu_Other"));
        this.mAreaDataSerializer.addOtherProperties("Row_Switch_Menu_Zh_1", ThemeFileManager.getInstance().getSkinFile(false, "area.ini", 0).get("Row_Switch_Menu_Zh_1"));
        this.mAreaDataSerializer.addOtherProperties("Row_Switch_Menu_Zh_2", ThemeFileManager.getInstance().getSkinFile(false, "area.ini", 0).get("Row_Switch_Menu_Zh_2"));
        this.mAreaDataSerializer.addOtherProperties("Row_Switch_Menu_En", ThemeFileManager.getInstance().getSkinFile(false, "area.ini", 0).get("Row_Switch_Menu_En"));
        this.mAreaDataSerializer.addOtherProperties("Row_Switch_Menu_Other", ThemeFileManager.getInstance().getSkinFile(false, "area.ini", 0).get("Row_Switch_Menu_Other"));
        this.mDimensDataSerializer.addOtherProperties("Style_Menu2", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Style_Menu2"));
        this.mDimensDataSerializer.addOtherProperties("Style_Menu", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Style_Menu"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Key_Hcr_Full_Check", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Key_Hcr_Full_Check"));
        this.mDimensDataSerializer.addOtherProperties("Style_Switch_Layout_Menu", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Style_Switch_Layout_Menu"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Switch_Layout_Menu_Area", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Switch_Layout_Menu_Area"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Switch_Layout_Menu_Row", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Switch_Layout_Menu_Row"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Switch_Layout_Menu_Key", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Switch_Layout_Menu_Key"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Switch_Layout_Menu_Text", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Switch_Layout_Menu_Text"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Switch_Layout_Menu_Area", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Switch_Layout_Menu_Area"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Switch_Layout_Menu_Row", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Switch_Layout_Menu_Row"));
        this.mDimensDataSerializer.addOtherProperties("Dimens_Balloon_Amplify_Default", ThemeFileManager.getInstance().getSkinFile(false, "dimens.ini", 0).get("Dimens_Balloon_Amplify_Default"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Py_9", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Py_9"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Py_9_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Py_9_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Py_9_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Py_9_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Py_26", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Py_26"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Py_26_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Py_26_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Py_26_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Py_26_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_BiHua", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_BiHua"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_BiHua_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_BiHua_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_BiHua_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_BiHua_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Hcr_Half", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Hcr_Half"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Hcr_Half_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Hcr_Half_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Hcr_Half_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Hcr_Half_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Hcr_Full", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Hcr_Full"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Hcr_Full_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Hcr_Full_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Hcr_Full_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Hcr_Full_Text"));
        this.mKeyDataSerializer.addOtherProperties("Selector_Key_Menu_En_9", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Selector_Key_Menu_En_9"));
        this.mKeyDataSerializer.addOtherProperties("Selector_Key_Menu_En_26", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Selector_Key_Menu_En_26"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_En_9", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_En_9"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_En_9_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_En_9_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_En_9_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_En_9_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_En_26", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_En_26"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_En_26_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_En_26_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_En_26_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_En_26_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Ab_9", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Ab_9"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Ab_9_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Ab_9_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Ab_9_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Ab_9_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Ab_26", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Ab_26"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Ab_26_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Ab_26_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Ab_26_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Ab_26_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Other", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Other"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Other_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Other_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Other_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Other_Text"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Other_Layout", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Other_Layout"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Other_Layout_Image", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Other_Layout_Image"));
        this.mKeyDataSerializer.addOtherProperties("Key_Menu_Other_Layout_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("Key_Menu_Other_Layout_Text"));
        this.mKeyDataSerializer.addOtherProperties("ForeState_Menu_SubKey_Text", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("ForeState_Menu_SubKey_Text"));
        this.mKeyDataSerializer.addOtherProperties("BackState_Menu_Key", ThemeFileManager.getInstance().getSkinFile(false, "key.ini", 0).get("BackState_Menu_Key"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_Full_Check_Key", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_Full_Check_Key"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_Full_Check_Key_Help", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_Full_Check_Key_Help"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_Full_Check_Key_Press_Help", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_Full_Check_Key_Press_Help"));
        this.mStyleDataSerializer.addOtherProperties("Style_Cand_Menu_Word_1", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Cand_Menu_Word_1"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_Word_Superscript", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_Word_Superscript"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_Word_Superscript2", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_Word_Superscript2"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_SubKey_Text", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_SubKey_Text"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_SubKey_Text_Select", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_SubKey_Text_Select"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_SubKey_Text_Press", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_SubKey_Text_Press"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_Key_Pressed", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_Key_Pressed"));
        this.mStyleDataSerializer.addOtherProperties("Style_Menu_Key_Select", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Menu_Key_Select"));
        this.mStyleDataSerializer.addOtherProperties("Style_Balloon_Amplify", ThemeFileManager.getInstance().getSkinFile(false, "style.ini", 0).get("Style_Balloon_Amplify"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_lenove_delete", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_lenove_delete"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_Py_9", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_Py_9"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_Py_26", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_Py_26"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_BiHua", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_BiHua"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_Hcr_Half", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_Hcr_Half"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_Hcr_Full", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_Hcr_Full"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_En_9", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_En_9"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_En_26", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_En_26"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_Other_Inputmethod", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_Other_Inputmethod"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_Other_Layout", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_Other_Layout"));
        this.mImageDataSerializer.addOtherProperties("Image_Menu_Key_Press_Bg", ThemeFileManager.getInstance().getSkinFile(false, "image.ini", 0).get("Image_Menu_Key_Press_Bg"));
    }

    private void writetoFile(File file, String fileName, Iniable object) {
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            try {
                file = new File(String.valueOf(file.getAbsolutePath()) + File.separator + fileName);
                if (file.exists()) {
                    file.delete();
                } else {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                fos = new FileOutputStream(file.getAbsoluteFile(), true);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"));
                String tempString = object.toIniString();
                bw.write(tempString);
                bw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        fos = null;
                    }
                    fos = null;
                }
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    fos = null;
                }
                fos = null;
            }
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void genPackage(File dir, String fileName) {
        String tmpPath = String.valueOf(dir.getAbsolutePath()) + File.separator + fileName + File.separator;
        File tmpDir = new File(tmpPath);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        this.mThemeInfoSerializer.genThemeInfo();
        this.writetoFile(new File(tmpPath), "layout_info.ini", this.mThemeInfoSerializer);
        try {
            ThemeUtils.copyAllFile(String.valueOf(PathClass.getpath()) + "\\480\\res", String.valueOf(tmpPath) + "\\480" + File.separator + "res", true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "animation.ini", this.mAnimationSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "area.ini", this.mAreaDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "balloon.ini", this.mBallonDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "cand.ini", this.mCandidateDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "composing.ini", this.mComposingDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "dimens.ini", this.mDimensDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "image.ini", this.mImageDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "key.ini", this.mKeyDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "keyboard.ini", this.mKeyBoardDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "layout.ini", this.mLayoutDataSerializer);
        this.writetoFile(new File(String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator), "style.ini", this.mStyleDataSerializer);
        FileUtils.copyFile(String.valueOf(PathClass.getpath()) + "\\480\\layout\\menu.ini", String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator + "menu.ini", true);
        FileUtils.copyFile(String.valueOf(PathClass.getpath()) + "\\480\\layout\\config.ini", String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator + "config.ini", true);
        FileUtils.copyFile(String.valueOf(PathClass.getpath()) + "\\480\\layout\\composing.ini", String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator + "composing.ini", true);
        FileUtils.copyFile(String.valueOf(PathClass.getpath()) + "\\480\\layout\\balloon.ini", String.valueOf(tmpPath) + "480" + File.separator + "layout" + File.separator + "balloon.ini", true);
    }

    class LayoutPackageListener
    implements ISerializerListener {
        LayoutPackageListener() {
        }

        @Override
        public String redirect(int type, String tag, Object object) {
            switch (type) {
                case 9: {
                    tag = LayoutPackageWriter.this.mStyleDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 8: {
                    tag = LayoutPackageWriter.this.mDimensDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 10: {
                    tag = LayoutPackageWriter.this.mComposingDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 6: {
                    tag = LayoutPackageWriter.this.mKeyDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 7: {
                    tag = LayoutPackageWriter.this.mAnimationSerializer.serializeData(type, tag, object);
                    break;
                }
                case 4: {
                    tag = LayoutPackageWriter.this.mAreaDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 12: {
                    ImageData bitmapData = null;
                    bitmapData = (ImageData)LayoutPackageWriter.this.mBitmapDatas.get(tag);
                    if (bitmapData == null) break;
                    tag = LayoutPackageWriter.this.mImageDataSerializer.serializeData(type, tag, bitmapData);
                    break;
                }
                case 2: {
                    tag = LayoutPackageWriter.this.mKeyBoardDataSerializer.serializeData(type, tag, object);
                    break;
                }
                case 3: {
                    tag = LayoutPackageWriter.this.mCandidateDataSerializer.serializeData(type, tag, object);
                    break;
                }
            }
            return tag;
        }
    }
}

