/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.front.view;

import com.iflytek.skintool.domin.DisplayConst;
import com.iflytek.skintool.graphical.high.ComposingPanel;
import com.iflytek.skintool.graphical.high.IMEKeyboardPanel;
import com.iflytek.skintool.graphical.high.IMELayoutPanel;
import com.iflytek.skintool.graphical.low.IMEButton;
import com.iflytek.skintool.graphical.low.IMEPanel;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.KeyboardData;
import com.iflytek.skintool.model.layout.SelectorData;
import com.iflytek.skintool.model.pool.LayoutDataPool;
import com.iflytek.skintool.model.pool.ThemeDataPool;
import com.iflytek.skintool.model.theme.ThemeKeyData;
import com.iflytek.skintool.util.PictureUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class KeyboardView
extends JPanel {
    private HashMap<Integer, IMELayoutPanel> layoutPanels = new HashMap();
    private ComposingPanel composingPanel;
    private IMEKeyboardPanel characterPanel;

    public void loadLayout(Integer tag) {
        this.setLayoutsInvisiable();
        if (this.layoutPanels.get(tag) != null) {
            this.layoutPanels.get(tag).setVisible(true);
        } else {
            IMELayoutPanel layoutPanel = new IMELayoutPanel();
            layoutPanel.setLayoutData(LayoutDataPool.getLayoutDataSetData().get(tag));
            DimensData layoutDimension = LayoutDataPool.getLayoutDataSetData().get(tag).getDimensData();
            layoutDimension.setWidth(DisplayConst.IME_WIDTH);
            layoutDimension.setHeight(DisplayConst.IME_HEIGHT);
            layoutPanel.loadLayoutPanel();
            this.add(layoutPanel);
            layoutPanel.setLocation(0, 60);
            layoutPanel.setID(tag);
            this.layoutPanels.put(tag, layoutPanel);
            if (tag % 19 == 12) {
                layoutPanel.fillSpeechTitle();
            } else if (tag % 19 == 18) {
                layoutPanel.fillExpressionPanel();
            }
            layoutPanel.setVisible(true);
        }
    }

    public KeyboardView() {
        this.setLayout(null);
    }

    public void reload() {
        for (Map.Entry<Integer, IMELayoutPanel> pairs : this.layoutPanels.entrySet()) {
            pairs.getValue().reload();
            this.characterPanel = null;
        }
    }

    public void setAlpha(int alpha) {
        if (this.characterPanel != null) {
            this.characterPanel.setAlpha(alpha);
            if (this.characterPanel.getBackIcon() != null) {
                this.characterPanel.setAlphaedImage(PictureUtil.setImageOpacity(this.characterPanel.getBackIcon(), alpha));
            }
        }
        for (Map.Entry<Integer, IMELayoutPanel> pairs : this.layoutPanels.entrySet()) {
            pairs.getValue().setAlpha(alpha);
        }
    }

    public ComposingPanel getComposingPanel() {
        return this.composingPanel;
    }

    public IMEKeyboardPanel getCharacterCandPanel() {
        return this.characterPanel;
    }

    private void setLayoutsInvisiable() {
        for (Map.Entry<Integer, IMELayoutPanel> pairs : this.layoutPanels.entrySet()) {
            pairs.getValue().setVisible(false);
        }
    }

    public void setKeyboardBackgroundIcon(ImageIcon icon) {
        for (Map.Entry<Integer, IMELayoutPanel> pairs : this.layoutPanels.entrySet()) {
            pairs.getValue().setBackgroundIcon(icon);
        }
    }

    public void setKeyboardBackground(Color color) {
        for (Map.Entry<Integer, IMELayoutPanel> pairs : this.layoutPanels.entrySet()) {
            pairs.getValue().setBackgroudColor(color);
        }
    }

    public HashMap<Integer, IMELayoutPanel> getLayoutPanels() {
        return this.layoutPanels;
    }

    public void addPinyinArea() {
        if (this.composingPanel == null) {
            this.composingPanel = new ComposingPanel(ThemeDataPool.msubjectset.getComposingData());
            this.composingPanel.setSize(DisplayConst.COMPOSING_WIDTH, DisplayConst.COMPOSING_HEIGHT);
            this.composingPanel.setLocation(0, 25);
            this.add(this.composingPanel);
            this.repaint();
        } else {
            this.composingPanel.setVisible(true);
        }
    }

    public void showCharacterArea() {
        if (this.characterPanel == null) {
            this.characterPanel = new IMEKeyboardPanel();
            KeyboardData data = (KeyboardData)((SelectorData)LayoutDataPool.getLayoutDataSetData().get(0).getCandidates()).getChilds().get(1);
            data.getDimensData().setWidth(DisplayConst.IME_WIDTH);
            data.getDimensData().setHeight(72.0f);
            data.loadChild(false);
            this.characterPanel.setKeyboardData(data);
            this.characterPanel.loadKeyboardPanel();
            this.characterPanel.setLocation(0, 0);
            this.initCharacters(this.characterPanel.getSonPanel()[0], ((AreaData)data.getChilds().get(0)).getKeyAttribute());
            this.layoutPanels.get(0).getSonPanel()[0].setVisible(false);
            this.layoutPanels.get(0).add(this.characterPanel);
        } else {
            this.layoutPanels.get(0).getSonPanel()[0].setVisible(false);
            this.characterPanel.setVisible(true);
        }
    }

    public void hideCharacterArea() {
        if (this.characterPanel != null) {
            this.layoutPanels.get(0).getSonPanel()[0].setVisible(true);
            this.characterPanel.setVisible(false);
        }
    }

    public void hidePinyinArea() {
        if (this.composingPanel != null) {
            this.composingPanel.setVisible(false);
        }
    }

    private void initCharacters(IMEPanel panel, KeyData keyData) {
        StyleData themeForeStyleData;
        ThemeKeyData themeKeyData;
        IMEButton[] characterButtons = new IMEButton[4];
        int width = panel.getWidth() / 4;
        int height = panel.getHeight();
        int i = 0;
        while (i < 4) {
            characterButtons[i] = new IMEButton();
            characterButtons[i].setKeyData(keyData);
            characterButtons[i].loadButton();
            characterButtons[i].setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 28));
            characterButtons[i].setSize(width, height);
            characterButtons[i].setLocation(i * width, 0);
            panel.add(characterButtons[i]);
            ++i;
        }
        StyleData foreStyleData = keyData.getForeStyle(4);
        Color layoutTextColor = null;
        if (foreStyleData != null) {
            layoutTextColor = new Color(foreStyleData.getTextColor());
        }
        if ((themeKeyData = ThemeDataPool.msubjectset.getThemeKeyData(keyData.getThemeType())) != null && (themeForeStyleData = themeKeyData.getForegroundStyle(4)) != null) {
            characterButtons[0].setDefaultTextColor(new Color(PictureUtil.getFilteredColor(layoutTextColor.getRGB(), themeForeStyleData.getTextColor())));
            characterButtons[0].setForeground(new Color(PictureUtil.getFilteredColor(layoutTextColor.getRGB(), themeForeStyleData.getTextColor())));
        }
        characterButtons[0].setText("\u4f60\u597d");
        characterButtons[1].setText("\u4f60\u6562");
        characterButtons[2].setText("\u4f60\u5e72");
        characterButtons[3].setText("\u4f60\u53f7");
    }

    public void setFocusdCharColor(Color color) {
        KeyboardData data = (KeyboardData)((SelectorData)LayoutDataPool.getLayoutDataSetData().get(0).getCandidates()).getChilds().get(1);
        KeyData keyData = ((AreaData)data.getChilds().get(0)).getKeyAttribute();
        Color layoutTextColor = null;
        StyleData foreStyleData = keyData.getForeStyle(4);
        if (foreStyleData != null) {
            layoutTextColor = new Color(foreStyleData.getTextColor());
        }
        ((IMEButton)this.characterPanel.getSonPanel()[0].getComponent(0)).setDefaultTextColor(new Color(PictureUtil.getFilteredColor(layoutTextColor.getRGB(), color.getRGB())));
        ((IMEButton)this.characterPanel.getSonPanel()[0].getComponent(0)).setForeground(new Color(PictureUtil.getFilteredColor(layoutTextColor.getRGB(), color.getRGB())));
    }

    public void setNormalCharColor(Color color) {
        KeyboardData data = (KeyboardData)((SelectorData)LayoutDataPool.getLayoutDataSetData().get(0).getCandidates()).getChilds().get(1);
        KeyData keyData = ((AreaData)data.getChilds().get(0)).getKeyAttribute();
        Color layoutTextColor = null;
        StyleData foreStyleData = keyData.getForeStyle(1);
        if (foreStyleData != null) {
            layoutTextColor = new Color(foreStyleData.getTextColor());
        }
        int i = 1;
        while (i < 4) {
            ((IMEButton)this.characterPanel.getSonPanel()[0].getComponent(i)).setDefaultTextColor(new Color(PictureUtil.getFilteredColor(layoutTextColor.getRGB(), color.getRGB())));
            ((IMEButton)this.characterPanel.getSonPanel()[0].getComponent(i)).setForeground(new Color(PictureUtil.getFilteredColor(layoutTextColor.getRGB(), color.getRGB())));
            ++i;
        }
    }

    public void setCandBackgroundIcon(ImageIcon imageIcon) {
        if (this.characterPanel != null) {
            this.characterPanel.setBackgroundIcon(imageIcon);
            if (LayoutDataPool.getThemeInfo().getAlpha() != 255) {
                this.characterPanel.setAlphaedImage(PictureUtil.setImageOpacity(imageIcon, LayoutDataPool.getThemeInfo().getAlpha()));
            }
        }
        for (Map.Entry<Integer, IMELayoutPanel> entry : this.layoutPanels.entrySet()) {
            if (entry.getKey() % 19 == 12 || entry.getKey() % 19 == 8) continue;
            entry.getValue().getSonPanel()[0].setBackgroundIcon(imageIcon);
            if (LayoutDataPool.getThemeInfo().getAlpha() == 255) continue;
            entry.getValue().getSonPanel()[0].setAlphaedImage(PictureUtil.setImageOpacity(imageIcon, LayoutDataPool.getThemeInfo().getAlpha()));
        }
    }

    public void changeKeyForeColor(Color color) {
        for (Map.Entry<Integer, IMELayoutPanel> entry : this.layoutPanels.entrySet()) {
            entry.getValue().changeKeyForeColor(color);
        }
    }

    public void clearLayouts() {
        this.removeAll();
        this.layoutPanels = null;
        this.composingPanel = null;
        this.characterPanel = null;
        this.layoutPanels = new HashMap();
    }
}

