/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.common;

import com.iflytek.skintool.domin.LayoutType;
import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.StyleData;
import java.util.ArrayList;

public abstract class BaseData
implements Cloneable {
    protected String mTag;
    protected DimensData mDimensData;
    protected int mThemeType;

    public abstract LayoutType getLayoutType();

    public abstract StyleData getStyle();

    public abstract ArrayList<BaseData> getChilds();

    public void setDimensData(DimensData dimensdata) {
        this.mDimensData = dimensdata;
    }

    public DimensData getDimensData() {
        if (this.mDimensData == null) {
            this.mDimensData = new DimensData();
        }
        return this.mDimensData;
    }

    public void setThemeType(int themetype) {
        this.mThemeType = themetype;
    }

    public int getThemeType() {
        return this.mThemeType;
    }

    public BaseData clone() {
        BaseData baseData;
        block4: {
            try {
                baseData = (BaseData)super.clone();
                if (baseData != null) break block4;
                return null;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
        if (this.mDimensData != null) {
            baseData.mDimensData = this.mDimensData.clone();
        }
        return baseData;
    }

    protected float getAbsX() {
        return this.getDimensData().getAbsX();
    }

    protected float getAbsY() {
        return this.getDimensData().getAbsY();
    }

    protected float getOffsetXInView() {
        return 0.0f;
    }

    protected float getOffsetYInView() {
        return 0.0f;
    }

    public void measure(float width, float height) {
        DimensData style = this.getDimensData();
        if (!style.measureWidth(width)) {
            style.setWidth(width);
        }
        if (!style.measureHeight(height)) {
            style.setHeight(height);
        }
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setmDimensData(DimensData parentDimensData) {
        this.mDimensData = parentDimensData;
    }

    public boolean loadChild(boolean land) {
        ArrayList<BaseData> dataSet = this.getChilds();
        if (dataSet == null) {
            return false;
        }
        if (dataSet.size() == 0) {
            return false;
        }
        this.layoutChild(land, dataSet);
        return true;
    }

    public void layoutChild(boolean land, ArrayList<BaseData> datas) {
        DimensData dimens = this.getDimensData();
        float layoutWidth = dimens.getWidth();
        float layoutHeight = dimens.getHeight();
        Rectangle padding = dimens.getPadding();
        if (padding != null) {
            layoutWidth = layoutWidth - (float)padding.mX1 - (float)padding.mX2;
            layoutHeight = layoutHeight - (float)padding.mY1 - (float)padding.mY2;
        }
        float totalWidth = layoutWidth;
        float totalHeight = layoutHeight;
        int size = datas.size();
        if (size == 0) {
            return;
        }
        switch (this.getLayoutType()) {
            case VERTICAL: {
                DimensData styleData;
                BaseData data;
                float usedHeight = 0.0f;
                ArrayList<BaseData> undefineHeightDatas = new ArrayList<BaseData>();
                int i = 0;
                while (i < size) {
                    data = datas.get(i);
                    styleData = data.getDimensData();
                    styleData.measureMargin(layoutWidth, layoutHeight);
                    ++i;
                }
                i = 0;
                while (i < size) {
                    data = datas.get(i);
                    styleData = data.getDimensData();
                    layoutHeight -= (float)(styleData.getMargin().mY1 + styleData.getMargin().mY2);
                    ++i;
                }
                i = 0;
                while (i < size) {
                    data = datas.get(i);
                    styleData = data.getDimensData();
                    if (styleData.measureHeight(layoutHeight)) {
                        usedHeight += styleData.getHeight();
                    } else {
                        undefineHeightDatas.add(data);
                    }
                    float leftWidth = layoutWidth;
                    Rectangle margin = styleData.getMargin();
                    if (margin != null) {
                        usedHeight += (float)(margin.mY1 + margin.mY2);
                        leftWidth = layoutWidth - (float)margin.mX1 - (float)margin.mX2;
                    }
                    if (!styleData.measureWidth(layoutWidth)) {
                        styleData.setWidth(leftWidth);
                    } else {
                        styleData.setWidth(styleData.getWidth() - (float)margin.mX1 - (float)margin.mX2);
                    }
                    ++i;
                }
                float remainHeight = totalHeight - usedHeight;
                if (remainHeight > 0.0f && undefineHeightDatas.size() > 0) {
                    float averageHeight = remainHeight / (float)undefineHeightDatas.size();
                    for (BaseData data2 : undefineHeightDatas) {
                        data2.getDimensData().setHeight(averageHeight);
                    }
                }
                float yOffset = this.getOffsetYInView();
                int i2 = 0;
                while (i2 < size) {
                    BaseData data3 = datas.get(i2);
                    DimensData dimensdata = data3.getDimensData();
                    Rectangle margin = dimensdata.getMargin();
                    int mleft = 0;
                    int mtop = 0;
                    int mbottom = 0;
                    int pleft = 0;
                    int ptop = 0;
                    if (margin != null) {
                        mleft = margin.mX1;
                        mtop = margin.mY1;
                        mbottom = margin.mY2;
                    }
                    if (padding != null) {
                        pleft = padding.mX1;
                        ptop = padding.mY1;
                    }
                    dimensdata.setX(mleft + pleft);
                    dimensdata.setY((yOffset += (float)mtop) + (float)ptop);
                    yOffset += dimensdata.getHeight() + (float)mbottom;
                    dimensdata.measurePadding(dimensdata.getWidth(), dimensdata.getHeight());
                    data3.loadChild(land);
                    ++i2;
                }
                break;
            }
            case HORIZONTAL: {
                DimensData dimensdata;
                BaseData data;
                float usedWidth = 0.0f;
                ArrayList<BaseData> undefineWidthDatas = new ArrayList<BaseData>();
                int i = 0;
                while (i < size) {
                    data = datas.get(i);
                    dimensdata = data.getDimensData();
                    dimensdata.measureMargin(layoutWidth, layoutHeight);
                    ++i;
                }
                i = 0;
                while (i < size) {
                    data = datas.get(i);
                    dimensdata = data.getDimensData();
                    layoutWidth -= (float)(dimensdata.getMargin().mX1 + dimensdata.getMargin().mX2);
                    ++i;
                }
                i = 0;
                while (i < size) {
                    data = datas.get(i);
                    dimensdata = data.getDimensData();
                    if (dimensdata.measureWidth(layoutWidth)) {
                        usedWidth += dimensdata.getWidth();
                    } else {
                        undefineWidthDatas.add(data);
                    }
                    float leftHeight = layoutHeight;
                    Rectangle margin = dimensdata.getMargin();
                    if (margin != null) {
                        usedWidth += (float)(margin.mX1 + margin.mX2);
                        leftHeight = layoutHeight - (float)margin.mY1 - (float)margin.mY2;
                    }
                    if (!dimensdata.measureHeight(layoutHeight)) {
                        dimensdata.setHeight(leftHeight);
                    } else {
                        dimensdata.setHeight(dimensdata.getHeight() - (float)margin.mY1 - (float)margin.mY2);
                    }
                    ++i;
                }
                float remainWidth = totalWidth - usedWidth;
                if (remainWidth > 0.0f && undefineWidthDatas.size() > 0) {
                    float averageWidth = remainWidth / (float)undefineWidthDatas.size();
                    for (BaseData data4 : undefineWidthDatas) {
                        data4.getDimensData().setWidth(averageWidth);
                    }
                }
                float xOffset = 0.0f;
                int i3 = 0;
                while (i3 < size) {
                    BaseData data5 = datas.get(i3);
                    DimensData dimensdata2 = data5.getDimensData();
                    Rectangle margin = dimensdata2.getMargin();
                    int mleft = 0;
                    int mtop = 0;
                    int mright = 0;
                    int pleft = 0;
                    int ptop = 0;
                    if (margin != null) {
                        mleft = margin.mX1;
                        mtop = margin.mY1;
                        mright = margin.mX2;
                    }
                    if (padding != null) {
                        pleft = padding.mX1;
                        ptop = padding.mY1;
                    }
                    dimensdata2.setX((xOffset += (float)mleft) + (float)pleft);
                    xOffset += dimensdata2.getWidth() + (float)mright;
                    dimensdata2.setY(mtop + ptop);
                    dimensdata2.measurePadding(dimensdata2.getWidth(), dimensdata2.getHeight());
                    data5.loadChild(land);
                    ++i3;
                }
                break;
            }
            case ABSOLUTE: {
                int i = 0;
                while (i < datas.size()) {
                    BaseData data = datas.get(i);
                    DimensData dimesdata = data.getDimensData();
                    dimesdata.measureMargin(layoutWidth, layoutHeight);
                    if (!dimesdata.measureWidth(layoutWidth)) {
                        dimesdata.setWidth(layoutWidth);
                    }
                    if (!dimesdata.measureHeight(layoutHeight)) {
                        dimesdata.setHeight(layoutHeight);
                    }
                    dimesdata.measureCoordinateX(layoutWidth);
                    dimesdata.measureCoordinateY(layoutHeight);
                    Rectangle margin = dimesdata.getMargin();
                    int mleft = 0;
                    int mtop = 0;
                    int ptop = 0;
                    if (margin != null) {
                        mleft = margin.mX1;
                        mtop = margin.mY1;
                    }
                    if (padding != null) {
                        ptop = padding.mY1;
                    }
                    dimesdata.setX(dimesdata.getX() + (float)mleft);
                    dimesdata.setY(dimesdata.getY() + (float)mtop + (float)ptop);
                    dimesdata.measurePadding(dimesdata.getWidth(), dimesdata.getHeight());
                    data.loadChild(land);
                    ++i;
                }
                break;
            }
        }
    }
}

