/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.pool;

import com.iflytek.skintool.domin.KeyImageData;
import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.parser.utils.ThemeFileManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImagePool {
    private static ImagePool mImagePool = null;
    private static HashMap<String, KeyImageData> mImageMap;
    private static final String SEPERATOR = "#";

    private ImagePool() {
        mImageMap = new HashMap();
    }

    public static ImagePool getInstance() {
        if (mImagePool == null) {
            mImagePool = new ImagePool();
        }
        return mImagePool;
    }

    public HashMap<String, KeyImageData> getImageMap() {
        return mImageMap;
    }

    public KeyImageData getImageByTag(String tag, boolean landscape, int width, int height) {
        String key = null;
        key = landscape ? String.valueOf(tag) + SEPERATOR + 2 + SEPERATOR + width + SEPERATOR + height : String.valueOf(tag) + SEPERATOR + 1 + SEPERATOR + width + SEPERATOR + height;
        KeyImageData image = mImageMap.get(key);
        if (image == null && (image = ThemeFileManager.getInstance().crateImageInstance(tag, landscape, width, height)) != null) {
            mImageMap.put(key, image);
        }
        return image;
    }

    public void removeImage(String tag) {
        Iterator<Map.Entry<String, KeyImageData>> it = mImageMap.entrySet().iterator();
        ArrayList<String> delList = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry<String, KeyImageData> entry = it.next();
            if (!entry.getKey().contains(tag)) continue;
            delList.add(entry.getKey());
        }
        int i = 0;
        while (i < delList.size()) {
            mImageMap.remove(delList.get(i));
            ++i;
        }
    }

    public static void clear() {
        if (mImageMap != null) {
            mImageMap.clear();
        }
    }

    public static void addImage(String tag, boolean landscape, ImageData imageData, int width, int height) {
        String key = null;
        key = landscape ? String.valueOf(tag) + SEPERATOR + 2 + SEPERATOR + width + SEPERATOR + height : String.valueOf(tag) + SEPERATOR + 1 + SEPERATOR + width + SEPERATOR + height;
        KeyImageData image = mImageMap.get(key);
        if (image == null) {
            image = new KeyImageData(null);
            image.setXDivs(imageData.getXDivs());
            image.setYDivs(imageData.getYDivs());
            mImageMap.put(key, image);
        }
    }
}

