/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.theme;

import com.iflytek.skintool.domin.LayoutType;
import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.RowData;
import java.util.HashMap;
import java.util.List;

public class ComposingData {
    private StyleData mBackgroundStyle;
    private HashMap<Integer, StyleData> mForegroundStyles;
    private DimensData mDimens;
    private int mThemeType = 0x20000000;
    private int[] mTypeAttr;
    private String mTag;

    public String getTag() {
        return this.mTag;
    }

    public void setTag(String mTag) {
        this.mTag = mTag;
    }

    public int[] getTypeAttr() {
        return this.mTypeAttr;
    }

    public void setTypeAttr(int[] mTypeAttr) {
        this.mTypeAttr = mTypeAttr;
    }

    public int getThemeType() {
        return this.mThemeType;
    }

    public ComposingData clone() {
        ComposingData data = new ComposingData();
        if (this.mDimens != null) {
            data.mDimens = this.mDimens.clone();
        }
        if (this.mBackgroundStyle != null) {
            data.mBackgroundStyle = this.mBackgroundStyle.clone();
        }
        if (this.mForegroundStyles != null) {
            data.mForegroundStyles = new HashMap();
            int i = 0;
            while (i < this.mForegroundStyles.size()) {
                int key = (Integer)this.mForegroundStyles.keySet().toArray()[i];
                StyleData style = this.mForegroundStyles.get(key);
                data.mForegroundStyles.put(key, style);
                ++i;
            }
        }
        return data;
    }

    public void setThemeType(int themeType) {
        this.mThemeType = themeType;
    }

    public void setForegroundStyle(int state, StyleData style) {
        if (this.mForegroundStyles == null) {
            this.mForegroundStyles = new HashMap();
        }
        this.mForegroundStyles.put(state, style);
    }

    public StyleData getExactForegroundStyle(int state) {
        if (this.mForegroundStyles != null) {
            return this.mForegroundStyles.get(state);
        }
        return null;
    }

    public LayoutType getLayoutType() {
        return null;
    }

    public StyleData getForegroundStyle(int state) {
        if (this.mForegroundStyles != null) {
            StyleData style = this.mForegroundStyles.get(state);
            if (style != null || state == 1) {
                return style;
            }
            return this.getForegroundStyle(1);
        }
        return null;
    }

    public StyleData getStyle() {
        return null;
    }

    public void loadImage(boolean land) {
        if (this.mBackgroundStyle != null) {
            this.mBackgroundStyle.loadImage(land, 0, 0);
        }
    }

    public List<RowData> getRowSet() {
        return null;
    }

    public void setBackgroundStyle(StyleData style) {
        this.mBackgroundStyle = style;
    }

    public StyleData getBackgroundStyle() {
        return this.mBackgroundStyle;
    }

    public void setDimens(DimensData dimensData) {
        this.mDimens = dimensData;
    }

    public DimensData getDimens() {
        return this.mDimens;
    }

    public void loadAll(float width, float height, boolean land) {
        if (this.mBackgroundStyle != null) {
            this.mBackgroundStyle.loadImage(land, (int)this.mDimens.getWidth(), (int)this.mDimens.getHeight());
        }
        if (this.mForegroundStyles != null) {
            int i = 0;
            while (i < this.mForegroundStyles.size()) {
                StyleData style = (StyleData)this.mForegroundStyles.values().toArray()[i];
                if (style != null) {
                    style.loadImage(land, (int)this.mDimens.getWidth(), (int)this.mDimens.getHeight());
                }
                ++i;
            }
        }
        if (this.mDimens != null) {
            this.mDimens.measureMargin(width, height);
            Rectangle margin = this.mDimens.getMargin();
            float leftWidth = width;
            float leftHeight = height;
            if (margin != null) {
                leftWidth = width - (float)margin.mX1 - (float)margin.mY1;
                leftHeight = height - (float)margin.mX2 - (float)margin.mY2;
            }
            this.mDimens.measureWidth(leftWidth);
            this.mDimens.measureHeight(leftHeight);
            this.mDimens.measureCoordinateX(leftWidth);
            this.mDimens.measureCoordinateY(leftHeight);
            this.mDimens.measurePadding(this.mDimens.getWidth(), this.mDimens.getHeight());
        }
    }
}

