/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.common;

import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.ImageParser;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.HashMap;

public class StyleParser
extends BaseParser {
    protected StyleData mStyleData;
    private ImageParser imageParser;

    public StyleParser(Object context) {
        super(context);
        this.mFileName = "style.ini";
        this.imageParser = new ImageParser(null);
    }

    @Override
    public StyleData getParserResult(String tag) {
        String styleTag = String.valueOf(this.mFileName) + this.mLandscape;
        HashMap<String, StyleData> stylePool = (HashMap<String, StyleData>)mAllDataPool.get(styleTag);
        if (stylePool == null) {
            stylePool = new HashMap<String, StyleData>();
            mAllDataPool.put(styleTag, stylePool);
        }
        this.mStyleData = (StyleData)stylePool.get(String.valueOf(tag) + ManageUtils.flag);
        if (this.mStyleData == null) {
            this.mStyleData = new StyleData();
            if (!this.parserProperties(tag)) {
                return null;
            }
            this.mStyleData.setTag(tag);
            stylePool.put(String.valueOf(tag) + ManageUtils.flag, this.mStyleData);
        }
        return this.mStyleData;
    }

    @Override
    public boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("TEXT_SIZE")) {
            this.mStyleData.setTextSize(ThemeUtils.getInt(value), false);
            this.mStyleData.setTextSizeStr(value);
        } else if (key.equalsIgnoreCase("TEXT_COLOR")) {
            this.mStyleData.setTextColor(ThemeUtils.getColor(value));
        } else if (key.equalsIgnoreCase("TEXT_STYLE")) {
            this.mStyleData.setTextStyle(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("IMAGE")) {
            this.mStyleData.setImageTag(value);
            this.imageParser.setParserObject(this.layoutType);
            this.mStyleData.setImageData(this.imageParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("BG_COLOR")) {
            this.mStyleData.setBgColor(ThemeUtils.getColor(value));
        } else if (key.equalsIgnoreCase("TEXT_ALIGN")) {
            this.mStyleData.setTextAlign(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("TEXT_FLOAT")) {
            this.mStyleData.setTextFloat(Integer.valueOf(value));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getFileName() {
        return this.mFileName;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

