/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.model.layout.AnimationData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.ImageParser;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.Properties;
import javax.swing.ImageIcon;

public class AnimationParser
extends BaseParser {
    protected AnimationData mAnimationData;
    private ImageParser mImageParser;

    public AnimationParser(Object context) {
        super(context);
        this.mFileName = "animation.ini";
        this.mImageParser = new ImageParser(context);
    }

    protected void newAnimationData() {
        this.mAnimationData = new AnimationData();
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("ANIM_TYPE")) {
            this.mAnimationData.setAnimationType(ThemeUtils.getInt(value));
        } else if (!key.equalsIgnoreCase("IP_TYPE")) {
            if (key.equalsIgnoreCase("ANIM_IMAGE")) {
                String[] drawableStrings = ThemeUtils.splitString(value, ",");
                int len = drawableStrings.length;
                this.mAnimationData.setAnimationDrawableNum(len);
                this.mImageParser.setParserObject(this.layoutType);
                String mCurrentThemeDir1 = String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultLayoutResFilePath();
                this.mImageParser.setThemeDir(mCurrentThemeDir1);
                ImageIcon[] imageIcons = new ImageIcon[len];
                int k = 0;
                while (k < len) {
                    ImageData imageData = this.mImageParser.getParserResult(drawableStrings[k]);
                    ManageUtils.imageDataPoolMap.put(drawableStrings[k], imageData);
                    imageIcons[k] = new ImageIcon(String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultLayoutResFilePath() + imageData.getImageSrcName());
                    ++k;
                }
                this.mAnimationData.setAnimationDrawables(imageIcons);
            } else if (key.equalsIgnoreCase("ANIM_IMAGE_NUM")) {
                this.mAnimationData.setAnimationDrawableNum(ThemeUtils.getInt(value));
            } else if (key.equalsIgnoreCase("SHARE_IP")) {
                this.mAnimationData.setShareInterpolator(ThemeUtils.getBool(value));
            } else if (key.equalsIgnoreCase("DURATION")) {
                this.mAnimationData.setDuration(ThemeUtils.getInt(value));
            } else if (key.equalsIgnoreCase("REPEAT_CNT")) {
                this.mAnimationData.setRepeatCount(Integer.valueOf(value));
            } else if (key.equalsIgnoreCase("START_OFFSET")) {
                this.mAnimationData.setStartOffset(Integer.valueOf(value).intValue());
            } else if (key.equalsIgnoreCase("FILL_AFTER")) {
                this.mAnimationData.setFillAfter(ThemeUtils.getBool(value));
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getParserResult(String tag) {
        Properties prop = (Properties)this.mPropertiesMap.get(tag);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        if (this.mAnimationData == null) {
            this.mAnimationData = new AnimationData();
        }
        this.mAnimationData.setmAnimationTag(tag);
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            this.parserProperty(string, value, false);
        }
        return this.mAnimationData;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }

    public void setParserObject(boolean landscape, int type) {
        this.layoutType = type;
        this.setParserObject(this.layoutType);
    }
}

