/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.domin.LayoutType;
import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.RowData;
import com.iflytek.skintool.model.layout.SelectorData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.DimensParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.layout.KeyParser;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RowParser
extends BaseParser {
    private RowData mRowSet;
    private StyleParser mStyleParser;
    private DimensParser mDimensParser;
    private KeyParser mKeyParser;
    private List<SelectorData> mKeySelectors;

    public RowParser(Object context) {
        super(context);
        this.mFileName = "area.ini";
        this.mKeyParser = new KeyParser(context);
        this.mKeySelectors = new ArrayList<SelectorData>();
    }

    public void setStyleParser(StyleParser styleParser) {
        this.mStyleParser = styleParser;
        this.mKeyParser.setStyleParser(styleParser);
    }

    public void setDimensParser(DimensParser dimensParser) {
        this.mDimensParser = dimensParser;
        this.mKeyParser.setDimensParser(dimensParser);
    }

    @Override
    public RowData getParserResult(String tag) {
        String rowTag = String.valueOf(this.mFileName) + this.mLandscape + RowParser.class.getName();
        HashMap<String, RowData> rowDataPool = (HashMap<String, RowData>)mAllDataPool.get(rowTag);
        if (rowDataPool == null) {
            rowDataPool = new HashMap<String, RowData>();
            this.mRowSet = null;
        } else {
            this.mRowSet = (RowData)rowDataPool.get(tag);
        }
        rowDataPool = new HashMap();
        this.mRowSet = null;
        if (this.mRowSet == null) {
            this.mRowSet = new RowData();
            this.mRowSet.setTag(tag);
            this.parserProperties(tag);
            LayoutType layoutType = this.mRowSet.getLayoutType();
            for (SelectorData data : this.mKeySelectors) {
                data.setLayoutType(layoutType);
            }
            rowDataPool.put(tag, this.mRowSet);
            mAllDataPool.put(rowTag, rowDataPool);
        }
        return this.mRowSet.clone();
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("LAYOUT")) {
            this.mRowSet.setLayoutType(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("KEY_SET")) {
            String[] stringArray = ThemeUtils.splitString(value, ",");
            this.mKeyParser.setParserObject(this.layoutType);
            ArrayList<BaseData> keyArray = new ArrayList<BaseData>();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyTag = stringArray2[n2];
                BaseData baseData = this.mKeyParser.getParserResult(keyTag);
                if (baseData != null) {
                    boolean cfr_ignored_0 = baseData instanceof KeyData;
                    keyArray.add(baseData);
                }
                ++n2;
            }
            this.mRowSet.setKeySet(keyArray);
        } else if (key.equalsIgnoreCase("STYLE")) {
            this.mRowSet.setStyleData(this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("DIMENS")) {
            this.mRowSet.setDimensData(this.mDimensParser.getParserResult(value));
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

