/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.theme;

import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.ComposingData;
import com.iflytek.skintool.model.theme.SubjectData;
import com.iflytek.skintool.model.theme.ThemeAreaData;
import com.iflytek.skintool.model.theme.ThemeBalloonData;
import com.iflytek.skintool.model.theme.ThemeKeyData;
import com.iflytek.skintool.model.theme.ThemeKeyboardData;
import com.iflytek.skintool.model.theme.ThemeLayoutData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.theme.ThemeAreaParser;
import com.iflytek.skintool.parser.theme.ThemeKeyParser;
import com.iflytek.skintool.parser.theme.ThemeLayoutDataParser;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.Map;
import java.util.Properties;

public class SubjectParser
extends BaseParser {
    private ThemeLayoutDataParser mThemeLayoutDataParser;
    private ThemeAreaParser mThemeAreaParser;
    private ThemeKeyParser mThemeKeyDataParser;
    private SubjectData mSuBjectData = new SubjectData();

    public SubjectParser(Object context) {
        super(context);
    }

    public SubjectData getmSuBjectData() {
        if (this.mPropertiesMap != null) {
            Properties prop = (Properties)this.mPropertiesMap.get("SUBJECT");
            if (prop == null || prop.isEmpty()) {
                return null;
            }
            for (String string : prop.keySet()) {
                String value = prop.getProperty(string);
                this.parserProperty(string, value);
            }
            return this.mSuBjectData;
        }
        return null;
    }

    protected boolean parserProperty(String key, String value) {
        if (key.equalsIgnoreCase("LAYOUT")) {
            this.setLayoutTheme(value);
        } else if (key.equalsIgnoreCase("AREA_SET")) {
            this.setAreaTheme(value);
        } else if (key.equalsIgnoreCase("KEY_SET")) {
            this.setKeyTheme(value);
        } else if (key.equalsIgnoreCase("KEYBOARD")) {
            this.setThemeKeyBoard(value);
        } else if (key.equalsIgnoreCase("COMPOSING")) {
            this.setThemeComposing(value);
        } else if (key.equalsIgnoreCase("BALLOON")) {
            this.setThemeBalloon(value);
        } else if (key.equalsIgnoreCase("THEME_FORE_COLOR_NEW")) {
            this.mSuBjectData.setThemeColor(ThemeUtils.getColor(value));
        } else if (key.equalsIgnoreCase("THEME_FORE_PRESS_COLOR")) {
            this.mSuBjectData.setThemePressColor(ThemeUtils.getColor(value));
        } else {
            return false;
        }
        return true;
    }

    private void setThemeBalloon(String value) {
        ThemeBalloonData data = null;
        data = this.getThemeBalloon(value);
        this.mSuBjectData.setBalloonData(data);
    }

    private ThemeBalloonData getThemeBalloon(String key) {
        ThemeBalloonData data = new ThemeBalloonData();
        data.setTag(key);
        Properties prop = (Properties)this.mPropertiesMap.get(key);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        StyleData style = null;
        StyleParser parser = new StyleParser(null);
        if (prop.get("STYLE") != null) {
            parser.setParserObject(0);
            style = parser.getParserResult(prop.getProperty("STYLE"));
            data.setStyleData(style);
        }
        if (prop.get("TYPE") != null) {
            data.setmTypeAttr(ThemeUtils.splitInt(prop.get("TYPE").toString(), ","));
        }
        return data;
    }

    private void setThemeComposing(String value) {
        ComposingData data = null;
        data = this.getThemeComposing(value);
        this.mSuBjectData.setComposingData(data);
    }

    private ComposingData getThemeComposing(String key) {
        Properties foreStyleProperties;
        ComposingData data = new ComposingData();
        data.setTag(key);
        Properties prop = (Properties)this.mPropertiesMap.get(key);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        StyleData style = null;
        StyleParser parser = new StyleParser(null);
        if (prop.getProperty("STYLE") != null) {
            parser.setParserObject(0);
            style = parser.getParserResult(prop.getProperty("STYLE"));
            data.setBackgroundStyle(style);
        }
        if ((foreStyleProperties = (Properties)this.mPropertiesMap.get(prop.getProperty("FORE_STATE"))) != null) {
            if (foreStyleProperties.get("VALID") != null) {
                data.setForegroundStyle(1, parser.getParserResult(foreStyleProperties.getProperty("VALID")));
            }
            if (foreStyleProperties.get("FIXED") != null) {
                data.setForegroundStyle(2, parser.getParserResult(foreStyleProperties.getProperty("FIXED")));
            }
            if (foreStyleProperties.get("INVALID") != null) {
                data.setForegroundStyle(3, parser.getParserResult(foreStyleProperties.getProperty("INVALID")));
            }
        }
        return data;
    }

    private void setThemeKeyBoard(String value) {
        String[] KeyBoardSet;
        String[] stringArray = KeyBoardSet = ThemeUtils.splitString(value, ",");
        int n = KeyBoardSet.length;
        int n2 = 0;
        while (n2 < n) {
            String keyTag = stringArray[n2];
            ThemeKeyboardData data = null;
            data = this.getCommon(keyTag);
            if (data != null) {
                int[] types = data.getTypeAttr();
                if (types != null && types.length > 0) {
                    int[] nArray = types;
                    int n3 = types.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int type = nArray[n4];
                        this.mSuBjectData.addKeyBoard(type, data);
                        ++n4;
                    }
                } else {
                    this.mSuBjectData.addKeyBoard(0, data);
                }
            }
            ++n2;
        }
    }

    public ThemeKeyboardData getCommon(String key) {
        ThemeKeyboardData common = new ThemeKeyboardData();
        Properties prop = (Properties)this.mPropertiesMap.get(key);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        common.setmTag(key);
        for (String string : prop.keySet()) {
            String value1 = prop.getProperty(string);
            if (string.equalsIgnoreCase("TYPE")) {
                int[] type = ThemeUtils.splitInt(value1, ",");
                common.setTypeAttr(type);
                continue;
            }
            if (!string.equalsIgnoreCase("STYLE")) continue;
            if (value1 != null) {
                common.setStyleTag(value1);
            }
            StyleData style = null;
            StyleParser parser = new StyleParser(null);
            parser.setParserObject(0);
            style = parser.getParserResult(value1);
            common.setStyleData(style);
        }
        return common;
    }

    private void setKeyTheme(String value) {
        String[] layoutSet = ThemeUtils.splitString(value, ",");
        if (layoutSet != null && layoutSet.length > 0) {
            String[] stringArray = layoutSet;
            int n = layoutSet.length;
            int n2 = 0;
            while (n2 < n) {
                String layoutTag = stringArray[n2];
                ThemeKeyData data = this.getThemeKeyData(layoutTag);
                if (data != null) {
                    int[] types = null;
                    types = data.getTypeAttr();
                    if (types != null && types.length > 0) {
                        int[] nArray = types;
                        int n3 = types.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int type = nArray[n4];
                            this.mSuBjectData.addThemeKeyData(type, data);
                            ++n4;
                        }
                    } else {
                        this.mSuBjectData.addThemeKeyData(0, data);
                    }
                }
                ++n2;
            }
        }
    }

    private ThemeKeyData getThemeKeyData(String layoutTag) {
        Map mhash = this.mPropertiesMap;
        Properties prop = (Properties)this.mPropertiesMap.get(layoutTag);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        if (this.mThemeKeyDataParser == null) {
            this.mThemeKeyDataParser = new ThemeKeyParser(null);
        }
        ThemeKeyData keydata = new ThemeKeyData();
        keydata.setkeyTag(layoutTag);
        this.mThemeKeyDataParser.setThemeKeyData(keydata);
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            this.mThemeKeyDataParser.parserProperty(string, value, mhash);
        }
        return this.mThemeKeyDataParser.getThemeKeyData();
    }

    private void setAreaTheme(String value) {
        String[] layoutSet = ThemeUtils.splitString(value, ",");
        if (layoutSet != null && layoutSet.length > 0) {
            String[] stringArray = layoutSet;
            int n = layoutSet.length;
            int n2 = 0;
            while (n2 < n) {
                int[] types;
                String layoutTag = stringArray[n2];
                ThemeAreaData data = null;
                data = this.getThemeAreaData(layoutTag);
                if (data != null && (types = data.getTypeAttr()) != null && types.length > 0) {
                    int[] nArray = types;
                    int n3 = types.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int type = nArray[n4];
                        this.mSuBjectData.addThemeAreaData(type, data);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void setLayoutTheme(String value) {
        String[] layoutSet = ThemeUtils.splitString(value, ",");
        if (layoutSet != null && layoutSet.length > 0) {
            String[] stringArray = layoutSet;
            int n = layoutSet.length;
            int n2 = 0;
            while (n2 < n) {
                String layoutTag = stringArray[n2];
                ThemeLayoutData data = this.getThemeLayoutData(layoutTag);
                data.setmLayoutTag(layoutTag);
                if (data != null) {
                    int[] types = data.getTypeAttr();
                    if (types != null && types.length > 0) {
                        int[] nArray = types;
                        int n3 = types.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int type = nArray[n4];
                            this.mSuBjectData.addThemeLayoutData(type, data);
                            ++n4;
                        }
                    } else {
                        this.mSuBjectData.addThemeLayoutData(0, data);
                    }
                }
                ++n2;
            }
        }
    }

    private ThemeAreaData getThemeAreaData(String layoutTag) {
        Properties prop = (Properties)this.mPropertiesMap.get(layoutTag);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        this.mThemeAreaParser = new ThemeAreaParser(null);
        this.mThemeAreaParser.getmThemeAreaData().setmThemeAreaTag(layoutTag);
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            this.mThemeAreaParser.parserProperty(string, value);
        }
        return this.mThemeAreaParser.getmThemeAreaData();
    }

    public ThemeLayoutData getThemeLayoutData(String layoutTag) {
        Properties prop = (Properties)this.mPropertiesMap.get(layoutTag);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        this.mThemeLayoutDataParser = new ThemeLayoutDataParser(null);
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            this.mThemeLayoutDataParser.parserProperty(string, value);
        }
        return this.mThemeLayoutDataParser.getmThemeLayoutData();
    }

    @Override
    public Object getParserResult(String tag) {
        return null;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        return false;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

