/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.theme;

import com.iflytek.skintool.model.theme.ThemeInfo;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.ImageParser;
import com.iflytek.skintool.parser.utils.ThemeFileManager;
import com.iflytek.skintool.util.ThemeUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class ThemeInfoParser
extends BaseParser {
    private ThemeInfo mThemeInfo;
    private String mThemeDir;
    private ImageParser mImageParser;

    public ThemeInfoParser(Object context) {
        super(context);
        this.mFileName = "theme_info.ini";
        this.mImageParser = new ImageParser(null);
    }

    public void setParserObject(String themeDir, int resType, String fileName, InputStream is) {
        this.mPropertiesMap = is != null ? ThemeFileManager.getInstance().getThemeFile(this.mFileName, is) : ThemeFileManager.getInstance().getThemeFile(themeDir, resType);
        this.mThemeDir = themeDir;
    }

    public String[] getParserAttribute(String tag, String key) {
        Properties properties;
        if (tag == null) {
            tag = "THEME_INFO";
        }
        if ((properties = (Properties)this.mPropertiesMap.get(tag)) != null) {
            return ThemeUtils.splitString((String)properties.get(key), ",");
        }
        return null;
    }

    @Override
    public ThemeInfo getParserResult(String tag) {
        String themeTag;
        HashMap<String, ThemeInfo> themeDataPool;
        if (tag == null) {
            tag = "THEME_INFO";
        }
        if ((themeDataPool = (HashMap<String, ThemeInfo>)mAllDataPool.get(themeTag = String.valueOf(this.mThemeDir) + this.mFileName + this.mLandscape)) == null) {
            themeDataPool = new HashMap<String, ThemeInfo>();
            this.mThemeInfo = null;
        } else {
            this.mThemeInfo = (ThemeInfo)themeDataPool.get(tag);
        }
        if (this.mThemeInfo == null) {
            this.mThemeInfo = new ThemeInfo();
            this.mThemeInfo.setThemeDir(this.mThemeDir);
            this.parserProperties(tag);
            themeDataPool.put(tag, this.mThemeInfo);
            mAllDataPool.put(themeTag, themeDataPool);
        }
        return this.mThemeInfo;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("PLATFORM")) {
            this.mThemeInfo.setPlatform(value);
        } else if (key.equalsIgnoreCase("AUTHOR")) {
            this.mThemeInfo.setAuthor(value);
        } else if (key.equalsIgnoreCase("NAME")) {
            this.mThemeInfo.setName(value);
        } else if (key.equalsIgnoreCase("DESCRIPTION")) {
            this.mThemeInfo.setDescription(value);
        } else if (key.equalsIgnoreCase("VERSION")) {
            this.mThemeInfo.setVersion(ThemeUtils.getFloat(value));
        } else if (key.equalsIgnoreCase("RESOLUTION")) {
            this.mThemeInfo.setResolution(ThemeUtils.splitString(value, ","));
        } else if (key.equalsIgnoreCase("DEFAULT_RES")) {
            this.mThemeInfo.setDefaultRes(value);
        } else if (key.equalsIgnoreCase("PREVIEW")) {
            this.mThemeInfo.setPreviewName(value);
            this.mImageParser.setParserObject(this.layoutType);
            this.mThemeInfo.setPreviewImage(this.mImageParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("ID")) {
            this.mThemeInfo.setID(value);
        } else if (key.equalsIgnoreCase("LAYOUT_SUPPORT")) {
            this.mThemeInfo.setmLayoutSupport(value);
        } else if (key.equalsIgnoreCase("INNER_LAYOUT")) {
            this.mThemeInfo.setmInnerLayout(value);
        } else if (key.equalsIgnoreCase("TYPE")) {
            this.mThemeInfo.setmType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("THEME_ALPHA")) {
            this.mThemeInfo.setAlpha(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("FROM")) {
            this.mThemeInfo.setFrom(value);
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

