/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.theme;

import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.theme.ThemeKeyData;
import com.iflytek.skintool.model.theme.ThemeSubKey;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.theme.ThemeSubKeyParser;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ThemeKeyParser
extends BaseParser {
    private ThemeKeyData mThemeKeyData = new ThemeKeyData();
    private StyleParser mstyleParser = new StyleParser(null);
    private ThemeSubKeyParser mThemeSubKeyParser;

    public ThemeKeyParser(Object context) {
        super(context);
        this.mstyleParser.setParserObject(0);
    }

    public ThemeKeyData getThemeKeyData() {
        return this.mThemeKeyData;
    }

    public void setThemeKeyData(ThemeKeyData keydata) {
        this.mThemeKeyData = keydata;
    }

    protected boolean parserProperty(String key, String value, Map<String, Properties> map) {
        if (key.equalsIgnoreCase("TYPE")) {
            this.mThemeKeyData.setTypeAttr(ThemeUtils.splitInt(value, ","));
        } else if (key.equalsIgnoreCase("BACK_STATE")) {
            Map<Integer, StyleData> styledata = this.getStateStyleDatas(value, map, false);
            if (styledata != null && styledata.size() > 0) {
                this.mThemeKeyData.setBackgroundStyleSet(styledata);
            }
        } else if (key.equalsIgnoreCase("FORE_STATE")) {
            Map<Integer, StyleData> styledata = this.getStateStyleDatas(value, map, true);
            if (styledata != null && styledata.size() > 0) {
                this.mThemeKeyData.setForegroundStyleSet(styledata);
            }
        } else if (key.equalsIgnoreCase("SUB_KEY")) {
            String[] keySet = ThemeUtils.splitString(value, ",");
            if (keySet != null && keySet.length > 0) {
                String[] stringArray = keySet;
                int n = keySet.length;
                int n2 = 0;
                while (n2 < n) {
                    String keyTag = stringArray[n2];
                    ThemeSubKey subkey = this.getThemeSubkey(keyTag);
                    if (subkey != null && subkey.getSubKeyForegroundStyleSet() != null && subkey.getSubKeyForegroundStyleSet().size() > 0) {
                        this.mThemeKeyData.setSubKeyForegroundStyleSet(subkey.getKeyGravity(), subkey.getSubKeyForegroundStyleSet());
                    }
                    ++n2;
                }
            }
        } else if (key.equalsIgnoreCase("SCRIPT_KEY")) {
            String[] keySet = ThemeUtils.splitString(value, ",");
            if (keySet != null && keySet.length > 0) {
                String[] stringArray = keySet;
                int n = keySet.length;
                int n3 = 0;
                while (n3 < n) {
                    String keyTag = stringArray[n3];
                    ThemeSubKey subkey = this.getThemeSubkey(keyTag);
                    if (subkey != null && subkey.getSubKeyForegroundStyleSet() != null && subkey.getSubKeyForegroundStyleSet().size() > 0) {
                        this.mThemeKeyData.setScriptKeyForegroundStyleSet(subkey.getKeyGravity(), subkey.getSubKeyForegroundStyleSet());
                    }
                    ++n3;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private ThemeSubKey getThemeSubkey(String keyTag) {
        Map mhash = this.mPropertiesMap;
        Properties prop = (Properties)this.mPropertiesMap.get(keyTag);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        if (this.mThemeSubKeyParser == null) {
            this.mThemeSubKeyParser = new ThemeSubKeyParser(null);
        }
        ThemeSubKey keydata = new ThemeSubKey();
        keydata.setkeyTag(keyTag);
        this.mThemeSubKeyParser.setThemeSubKeyData(keydata);
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            this.mThemeSubKeyParser.parserProperty(string, value, mhash);
        }
        return this.mThemeSubKeyParser.getThemeSubKeyData();
    }

    public Map<Integer, StyleData> getStateStyleDatas(String key, Map<String, Properties> map, boolean flag) {
        Properties prop = map.get(key);
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        HashMap<Integer, StyleData> styleset = new HashMap<Integer, StyleData>();
        for (String string : prop.keySet()) {
            StyleData style;
            String value1 = prop.getProperty(string);
            if (flag) {
                if (string.equals("NORMAL")) {
                    style = this.mstyleParser.getParserResult(value1);
                    this.mThemeKeyData.addForeTag(1, value1);
                    styleset.put(1, style);
                    continue;
                }
                if (string.equals("PRESSED")) {
                    style = this.mstyleParser.getParserResult(value1);
                    styleset.put(2, style);
                    this.mThemeKeyData.addForeTag(2, value1);
                    continue;
                }
                if (string.equals("FOCUSED")) {
                    style = this.mstyleParser.getParserResult(value1);
                    styleset.put(4, style);
                    this.mThemeKeyData.addForeTag(4, value1);
                    continue;
                }
                if (string.equals("SELECTED")) {
                    style = this.mstyleParser.getParserResult(value1);
                    styleset.put(8, style);
                    this.mThemeKeyData.addForeTag(8, value1);
                    continue;
                }
                if (!string.equals("DISABLED")) continue;
                style = this.mstyleParser.getParserResult(value1);
                styleset.put(16, style);
                this.mThemeKeyData.addForeTag(16, value1);
                continue;
            }
            if (string.equals("NORMAL")) {
                style = this.mstyleParser.getParserResult(value1);
                this.mThemeKeyData.addBacktag(1, value1);
                styleset.put(1, style);
                continue;
            }
            if (string.equals("PRESSED")) {
                style = this.mstyleParser.getParserResult(value1);
                styleset.put(2, style);
                this.mThemeKeyData.addBacktag(2, value1);
                continue;
            }
            if (string.equals("FOCUSED")) {
                style = this.mstyleParser.getParserResult(value1);
                styleset.put(4, style);
                this.mThemeKeyData.addBacktag(4, value1);
                continue;
            }
            if (string.equals("SELECTED")) {
                style = this.mstyleParser.getParserResult(value1);
                styleset.put(8, style);
                this.mThemeKeyData.addBacktag(8, value1);
                continue;
            }
            if (!string.equals("DISABLED")) continue;
            style = this.mstyleParser.getParserResult(value1);
            styleset.put(16, style);
            this.mThemeKeyData.addBacktag(16, value1);
        }
        return styleset;
    }

    @Override
    public Object getParserResult(String tag) {
        return null;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        return false;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

