Scriptname VirtualHolstersQuestScript extends Quest

Actor Property PlayerRef Auto Const
GlobalVariable Property VRH_01Status Auto Const Mandatory
GlobalVariable Property VRH_02Status Auto Const Mandatory
GlobalVariable Property VRH_03Status Auto Const Mandatory
GlobalVariable Property VRH_04Status Auto Const Mandatory
GlobalVariable Property VRH_05Status Auto Const Mandatory
GlobalVariable Property VRH_H01POSX Auto Const Mandatory
GlobalVariable Property VRH_H01POSY Auto Const Mandatory
GlobalVariable Property VRH_H01POSZ Auto Const Mandatory
GlobalVariable Property VRH_H02POSX Auto Const Mandatory
GlobalVariable Property VRH_H02POSY Auto Const Mandatory
GlobalVariable Property VRH_H02POSZ Auto Const Mandatory
GlobalVariable Property VRH_H03POSX Auto Const Mandatory
GlobalVariable Property VRH_H03POSY Auto Const Mandatory
GlobalVariable Property VRH_H03POSZ Auto Const Mandatory
GlobalVariable Property VRH_H04POSX Auto Const Mandatory
GlobalVariable Property VRH_H04POSY Auto Const Mandatory
GlobalVariable Property VRH_H04POSZ Auto Const Mandatory
GlobalVariable Property VRH_H05POSX Auto Const Mandatory
GlobalVariable Property VRH_H05POSY Auto Const Mandatory
GlobalVariable Property VRH_H05POSZ Auto Const Mandatory
GlobalVariable Property VRH_HandMode Auto Const Mandatory
GlobalVariable Property VRH_ControllerButton Auto Const Mandatory
Keyword Property WeaponTypeMelee1H Auto Const Mandatory
MiscObject Property VRH_Holster01 Auto Const Mandatory
MiscObject Property VRH_Holster02 Auto Const Mandatory
MiscObject Property VRH_Holster03 Auto Const Mandatory
MiscObject Property VRH_Holster04 Auto Const Mandatory
MiscObject Property VRH_Holster05 Auto Const Mandatory
ObjectReference Property HolsterChest01 Auto Const Mandatory
ObjectReference Property HolsterChest02 Auto Const Mandatory
ObjectReference Property HolsterChest03 Auto Const Mandatory
ObjectReference Property HolsterChest04 Auto Const Mandatory
ObjectReference Property HolsterChest05 Auto Const Mandatory
ObjectReference Property HolsterChest06 Auto Const Mandatory
Sound Property WPNSwordChineseEquipUp Auto Const Mandatory
Sound Property WPNSwordRevolutionaryEquipUp Auto Const Mandatory
Float WWeight
Int LeftShoulder = 1
Int RightShoulder = 2
Int LeftHip = 3
Int RightHip = 4
Int LowerBack = 5
Int OverLapStatus = 0
Int CurrentSlot
Int CurrentSlot2
Int WeaponRegTimer
Int ButtonPressed
Int SlotinUse
Int EquipState
Int WeaponCount
Int Removeitem
Int Overlap
Int Hand = 1
Int ButtonNumber = 7
Weapon HeldWeapon
Weapon EquipWeapon
ObjectReference HeldWeapon2
Float[] WeightArray
Int[] EquipArray
MiscObject[] HolsterPropArray
ObjectReference[] ChestArray
ObjectReference[] HolsterInstanceArray
String[] EmptyNameArray
String[] FullNameArray
String[] UnassignedArray
Weapon[] WeaponArray
Float[] HMDRot
Float[] HMDRot2
int TimerID = 10

Event Oninit()
    ChestArray = new ObjectReference[5]
    ChestArray[0] = HolsterChest01
    ChestArray[1] = HolsterChest02
    ChestArray[2] = HolsterChest03
    ChestArray[3] = HolsterChest04
    ChestArray[4] = HolsterChest05
    HolsterPropArray = new MiscObject[5]
    HolsterPropArray[0] = VRH_Holster01
    HolsterPropArray[1] = VRH_Holster02
    HolsterPropArray[2] = VRH_Holster03
    HolsterPropArray[3] = VRH_Holster04
    HolsterPropArray[4] = VRH_Holster05
    WeaponArray = new Weapon[5]
    WeightArray = new Float[5]
    EquipArray = new Int[5]
    EquipArray[0] = 3
    EquipArray[1] = 3
    EquipArray[2] = 3
    EquipArray[3] = 3
    EquipArray[4] = 3
    EquipState = 0
    FullNameArray = New String[5]
    FullNameArray[0] = "Holster Shoulder Left - Full"
    FullNameArray[1] = "Holster Shoulder Right - Full"
    FullNameArray[2] = "Holster Hip Left - Full"
    FullNameArray[3] = "Holster Hip Right - Full"
    FullNameArray[4] = "Holster Back Lower - Full"
    EmptyNameArray = New String[5]
    EmptyNameArray[0] = "Holster Shoulder Left - Empty"
    EmptyNameArray[1] = "Holster Shoulder Right - Empty"
    EmptyNameArray[2] = "Holster Hip Left - Empty"
    EmptyNameArray[3] = "Holster Hip Right - Empty"
    EmptyNameArray[4] = "Holster Back Lower - Empty"
    UnassignedArray = New String[5]
    UnassignedArray[0] = "Holster Shoulder Left - Unassigned"
    UnassignedArray[1] = "Holster Shoulder Right - Unassigned"
    UnassignedArray[2] = "Holster Hip Left - Unassigned"
    UnassignedArray[3] = "Holster Hip Right - Unassigned"
    UnassignedArray[4] = "Holster Back Lower - Unassigned"
    ObjectReference Hol1 = PlayerRef.PlaceAtMe(VRH_Holster01 , 1)
    PlayerRef.AddItem(Hol1, 1, true)
    ObjectReference Hol2 = PlayerRef.PlaceAtMe(VRH_Holster02 , 1)
    PlayerRef.AddItem(Hol2, 1, true)
    ObjectReference Hol3 = PlayerRef.PlaceAtMe(VRH_Holster03, 1)
    PlayerRef.AddItem(Hol3, 1, true)
    ObjectReference Hol4 = PlayerRef.PlaceAtMe(VRH_Holster04 , 1)
    PlayerRef.AddItem(Hol4, 1, true)
    ObjectReference Hol5 = PlayerRef.PlaceAtMe(VRH_Holster05 , 1)
    PlayerRef.AddItem(Hol5, 1, true)
    HolsterInstanceArray = new ObjectReference[5]
    HolsterInstanceArray[0] = Hol1
    HolsterInstanceArray[1] = Hol2
    HolsterInstanceArray[2] = Hol3
    HolsterInstanceArray[3] = Hol4
    HolsterInstanceArray[4] = Hol5
    AddInventoryEventFilter(VRH_Holster01)
    AddInventoryEventFilter(VRH_Holster02)
    AddInventoryEventFilter(VRH_Holster03)
    AddInventoryEventFilter(VRH_Holster04)
    AddInventoryEventFilter(VRH_Holster05)
    RegisterForRemoteEvent(PlayerRef, "OnItemRemoved")
    RemoveItem = 0
    ButtonPressed = 0
    Overlap = 0
EndEvent

Event ObjectReference.OnItemRemoved(ObjectReference akSource, Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer)
    If RemoveItem == 0
        ObjectReference ToBDel = akItemReference
        ToBDel.DisableNoWait()
        ToBDel.Delete() 
        if PlayerRef.GetItemCount(akBaseItem) == 0
           PlayerRef.Additem(akBaseItem, 1, true)
        endif      
    Endif
EndEvent

Function SetupHolsters()
    OverlapStatus = 0
    PapyrusVR.RegisterForVROverlapEvents(Self)
    float[] Holster01pos = PapyrusVR.Vector3(VRH_H01POSX.GetValue(), VRH_H01POSY.GetValue(), VRH_H01POSZ.GetValue())
    float[] Holster02pos = PapyrusVR.Vector3(VRH_H02POSX.GetValue(), VRH_H02POSY.GetValue(), VRH_H02POSZ.GetValue())
    float[] Holster03pos = PapyrusVR.Vector3(VRH_H03POSX.GetValue(), VRH_H03POSY.GetValue(), VRH_H03POSZ.GetValue())
    float[] Holster04pos = PapyrusVR.Vector3(VRH_H04POSX.GetValue(), VRH_H04POSY.GetValue(), VRH_H04POSZ.GetValue())
    float[] Holster05pos = PapyrusVR.Vector3(VRH_H05POSX.GetValue(), VRH_H05POSY.GetValue(), VRH_H05POSZ.GetValue())
    float[] rotation = PapyrusVR.Quaternion_Zero()
    LeftShoulder = PapyrusVR.RegisterLocalOverlapSphere(0.15, Holster01pos, rotation, 0)
    RightShoulder = PapyrusVR.RegisterLocalOverlapSphere(0.15, Holster02pos, rotation, 0)
    LeftHip = PapyrusVR.RegisterLocalOverlapSphere(0.20, Holster03pos, rotation, 0)
    RightHip = PapyrusVR.RegisterLocalOverlapSphere(0.20, Holster04pos, rotation, 0)
    LowerBack = PapyrusVR.RegisterLocalOverlapSphere(0.20, Holster05pos, rotation, 0)
    ButtonPressed=0
    RestoreWeight()
Endfunction

Function OnVROverlapEvent(int overlapEventType, int objectHandle, int deviceId)
    if(overlapEventType == 1 && objectHandle == LeftShoulder && deviceId == Hand)
        PapyrusVR.StartHaptics(2, 0.05, 1.0)
        PapyrusVR.RegisterForVRButtonEvents(Self)
        Overlap = 1
        CurrentSlot=0
    endIf
    if(overlapEventType == 1 && objectHandle == RightShoulder && deviceId == Hand)
        PapyrusVR.StartHaptics(2, 0.05, 1.0)
        PapyrusVR.RegisterForVRButtonEvents(Self)
        Overlap = 1
        CurrentSlot=1
    endIf
    if(overlapEventType == 1 && objectHandle == LeftHip && deviceId == Hand)
        PapyrusVR.StartHaptics(2, 0.05, 1.0)
        PapyrusVR.RegisterForVRButtonEvents(Self)
        Overlap = 1
        CurrentSlot=2
    endIf
    if(overlapEventType == 1 && objectHandle == RightHip && deviceId == Hand)
        PapyrusVR.StartHaptics(2, 0.05, 1.0)
        PapyrusVR.RegisterForVRButtonEvents(Self)
        Overlap = 1
        CurrentSlot=3
    endIf
    if(overlapEventType == 1 && objectHandle == LowerBack && deviceId == Hand)
        PapyrusVR.StartHaptics(2, 0.05, 1.0)
        PapyrusVR.RegisterForVRButtonEvents(Self)
        Overlap = 1
        CurrentSlot=4
    endIf
    if (overlapEventType == 2 && (objectHandle == LowerBack || objectHandle == RightHip || objectHandle == LeftHip || objectHandle == RightShoulder || objectHandle == LeftShoulder) && deviceId == Hand)
        PapyrusVR.UnRegisterForVRButtonEvents(Self)
        Overlap = 0
    Endif    
EndFunction


Function OnVRButtonEvent(int buttonEvent, int buttonId, int deviceId)
    if(buttonEvent == 2 && ButtonId == ButtonNumber && deviceId == Hand && ButtonPressed==0 && Overlap == 1)
        SlotAction() 
    Endif 
EndFunction

;========================================================================================================================
; Drawn holstered Weapon 
;========================================================================================================================

Function SlotAction()
    If ChestArray[CurrentSlot].GetItemCount() == 1 && EquipArray[CurrentSlot] == 0 && EquipState == 0
       PapyrusVR.UnRegisterForVRButtonEvents(Self)
       ButtonPressed=3
       CurrentSlot2 = CurrentSlot
       EquipWeapon = WeaponArray[CurrentSlot2]                                                                                                  ; Find out which weapon is stored in holster  
       WeaponCount = PlayerRef.GetItemCount(EquipWeapon)                                                                              ; Find out the count of weapons of the same type the player has in inventory
       If WeaponCount > 0                                                                                                                                         ; If the player has more than 0 move them to temporary storage to avoid accidental equip
           PlayerRef.RemoveItem(EquipWeapon, WeaponCount, true, HolsterChest06)                                           
           While  HolsterChest06.GetItemCount(EquipWeapon) < WeaponCount                                                       ; Wait until removal is complete before continuing
               Utility.Wait(0.1)
           EndWhile
       Endif
       If PlayerRef.GetItemCount(EquipWeapon) == 0                                                                                              ; Only proceed when player has 0 weapons of that type in inventory
            ChestArray[CurrentSlot2].RemoveItem(EquipWeapon, 1, true, PlayerRef)                                               ; Remove holstered weapon from storage container and place in players inventory
            While ChestArray[CurrentSlot2].GetItemCount() > 0 && PlayerRef.GetItemCount(EquipWeapon) < 1    ; Wait until weapon removal / is added to players inventory before continuing
                Utility.Wait(0.1)
            EndWhile
            if (EquipWeapon.HasKeyword(WeaponTypeMelee1H))                                                                                ; Check to see if weapon is sword and play unsheathing sound FX
                 int instanceID =WPNSwordChineseEquipUp.play(PlayerRef)  
            Endif
            PlayerRef.EquipItem(EquipWeapon, true, true)                                                                                            ; Equip weapon which was stored in holster
            Utility.Wait(0.5)                                       
       Endif
       If WeaponCount > 0                                                                                                                                           ; Return any removed weapons from temporary storage to the players inventory
           HolsterChest06.RemoveItem(EquipWeapon, WeaponCount, true, PlayerRef)
       Endif
       If PlayerRef.IsWeaponDrawn() == True && PlayerRef.GetEquippedWeapon() == EquipWeapon                   ; Check that holstered weapon is both drawn and equipped
           RemoveWeight()                                                                                                                                              ; Remove dummy weight from holster as weapon is now back in players inventory
           EquipArray[CurrentSlot2] = 1
           EquipState = 1
        Endif
;========================================================================================================================
; Holster drawn weapon 
;========================================================================================================================
  
  ElseIf ChestArray[CurrentSlot2].GetItemCount() == 0  && EquipArray[CurrentSlot2] == 1 && PlayerRef.IsWeaponDrawn() == True && EquipState == 1 &&  CurrentSlot == CurrentSlot2
        HeldWeapon = PlayerRef.GetEquippedWeapon()                                                                              ; Get current drawn weapon
        If ChestArray[CurrentSlot2].GetItemCount() == 0                                                                           ; See how many other weapons of that type the player has in inventory
            if (HeldWeapon.HasKeyword(WeaponTypeMelee1H))                                                                   ; Play sword sheath sound if weapon is a sword
                 int instanceID =WPNSwordRevolutionaryEquipUp.play(PlayerRef)  
            Endif
            PlayerRef.RemoveItem(HeldWeapon, 1, true, ChestArray[CurrentSlot2])                                   ; Remove current weapon from player and add it to the holsters storage chest
        Endif
        While PlayerRef.GetEquippedWeapon()!=None                                                                                 ; Wait for weapon to be removed from player
            Utility.Wait(0.1)
        EndWhile
        If PlayerRef.GetEquippedWeapon() == None                                                                                    ; Check that weapon = none and then add dummy weight to holster to simulate weapon 
            AddWeight()                                                                                                                                    ; still being in player inventory
            EquipArray[CurrentSlot2] = 0
            EquipState = 0  
        Endif
    Elseif ChestArray[CurrentSlot2].GetItemCount() == 0 && EquipArray[CurrentSlot2] == 3
       ; Debug.Notification("Holster empty! Nothing to draw!")
    Else
        ;Debug.Notification("You already have a holstered weapon in your hand")
    Endif
    ;PapyrusVR.RegisterForVRButtonEvents(Self)
    ButtonPressed=0
EndFunction

;========================================================================================================================
; Register Weapon to Holster functions
;========================================================================================================================

Function Slot01Conf()
   CurrentSlot2=0
    SlotRegistration()
EndFunction

Function Slot02Conf()
    CurrentSlot2=1
    SlotRegistration()
EndFunction

Function Slot03Conf()
   CurrentSlot2=2
    SlotRegistration()
EndFunction

Function Slot04Conf()
    CurrentSlot2=3
    SlotRegistration()
EndFunction

Function Slot05Conf()
    CurrentSlot2=4
    SlotRegistration()
EndFunction

Function SlotRegistration()
    If EquipState==0
        ;PapyrusVR.StartHaptics(2, 1.0, 0.7)
        SlotinUse=0
        If CurrentSlot2==0
            SlotinUse = VRH_01Status.GetValue() as Int
        elseIf CurrentSlot2==1
            SlotinUse = VRH_02Status.GetValue() as Int
        elseIf CurrentSlot2==2
            SlotinUse = VRH_03Status.GetValue() as Int
        elseIf CurrentSlot2==3
            SlotinUse = VRH_04Status.GetValue() as Int
        elseIf CurrentSlot2==4
            SlotinUse = VRH_05Status.GetValue() as Int
        endif
        if SlotinUse == 0
            If CurrentSlot2==0 && VRH_01Status.GetValue()==0.0 && ChestArray[CurrentSlot2].GetItemCount() == 0
                RegisterWeapon()
                VRH_01Status.SetValue(1.0)
            elseIf CurrentSlot2==1 && VRH_02Status.GetValue()==0.0 && ChestArray[CurrentSlot2].GetItemCount() == 0
                RegisterWeapon()
                VRH_02Status.SetValue(1.0)
            elseIf CurrentSlot2==2 && VRH_03Status.GetValue()==0.0 && ChestArray[CurrentSlot2].GetItemCount() == 0
               RegisterWeapon()
               VRH_03Status.SetValue(1.0)
            elseIf CurrentSlot2==3 && VRH_04Status.GetValue()==0.0 && ChestArray[CurrentSlot2].GetItemCount() == 0
                RegisterWeapon()
                VRH_04Status.SetValue(1.0)
            elseIf CurrentSlot2==4 && VRH_05Status.GetValue()==0.0 && ChestArray[CurrentSlot2].GetItemCount() == 0
                RegisterWeapon()
                VRH_05Status.SetValue(1.0)
            endif
            EquipArray[CurrentSlot2] = 0 
        Elseif SlotinUse == 1 
            ChestArray[CurrentSlot2].RemoveItem(WeaponArray[CurrentSlot2], 1, true, PlayerRef)
            RemoveWeight2()
            WeightArray[CurrentSlot2] = 0.0
            WeaponArray[CurrentSlot2] = None
            If CurrentSlot2==0
                VRH_01Status.SetValue(0.0)
            elseIf CurrentSlot2==1
                VRH_02Status.SetValue(0.0)
            elseIf CurrentSlot2==2
               VRH_03Status.SetValue(0.0)
            elseIf CurrentSlot2==3
                VRH_04Status.SetValue(0.0)
            elseIf CurrentSlot2==4
                VRH_05Status.SetValue(0.0)
            endif    
            EquipArray[CurrentSlot2] = 3
        Endif 
    Else
        Debug.Notification("Holster weapon equipped. Return it to its holster and try again")
    Endif   
EndFunction

Function RegisterWeapon()
    If ChestArray[CurrentSlot2].GetItemCount() == 0
        HeldWeapon = Playerref.GetEquippedWeapon()
        WeaponArray[CurrentSlot2] = HeldWeapon
        Playerref.RemoveItem(HeldWeapon, 1, true, ChestArray[CurrentSlot2])
        WWeight = ChestArray[CurrentSlot2].GetInventoryWeight()
        WeightArray[CurrentSlot2] = WWeight
        AddWeight()
    Endif
EndFunction

;========================================================================================================================
; Add / Remove dummy weight functions
;========================================================================================================================

Function AddWeight()
    RemoveItem = 1
    Playerref.RemoveItem(HolsterPropArray[CurrentSlot2], 1, true)
    HolsterInstanceArray[CurrentSlot2].DisableNoWait()
    HolsterInstanceArray[CurrentSlot2].Delete()
   ;WWeight = ChestArray[CurrentSlot2].GetInventoryWeight()
    HolsterPropArray[CurrentSlot2].SetWeight(WeightArray[CurrentSlot2])
    HolsterPropArray[CurrentSlot2].SetName(FullNameArray[CurrentSlot2])
    ObjectReference Holster = PlayerRef.PlaceAtMe(HolsterPropArray[CurrentSlot2] , 1)
    PlayerRef.AddItem(Holster, 1, true)
    HolsterInstanceArray[CurrentSlot2] = Holster
    RemoveItem = 0   
Endfunction

Function RemoveWeight()
    RemoveItem = 1
    Playerref.RemoveItem(HolsterPropArray[CurrentSlot2], 1, true)
    HolsterInstanceArray[CurrentSlot2].DisableNoWait()
    HolsterInstanceArray[CurrentSlot2].Delete()
    HolsterPropArray[CurrentSlot2].SetWeight(0.0)
    HolsterPropArray[CurrentSlot2].SetName(EmptyNameArray[CurrentSlot2])
    ObjectReference Holster = PlayerRef.PlaceAtMe(HolsterPropArray[CurrentSlot2] , 1)
    PlayerRef.AddItem(Holster, 1, true)
    HolsterInstanceArray[CurrentSlot2] = Holster
    RemoveItem = 0
Endfunction

Function RemoveWeight2()
    RemoveItem = 1
    Playerref.RemoveItem(HolsterPropArray[CurrentSlot2], 1, true)
    HolsterInstanceArray[CurrentSlot2].DisableNoWait()
    HolsterInstanceArray[CurrentSlot2].Delete()
    HolsterPropArray[CurrentSlot2].SetWeight(0.0)
    HolsterPropArray[CurrentSlot2].SetName(UnassignedArray[CurrentSlot2])
    ObjectReference Holster = PlayerRef.PlaceAtMe(HolsterPropArray[CurrentSlot2] , 1)
    PlayerRef.AddItem(Holster, 1, true)
    HolsterInstanceArray[CurrentSlot2] = Holster
    RemoveItem = 0
Endfunction

Function RestoreWeight()
    Int HolsterW = 0 
    RemoveItem = 1
    While HolsterW < 5
        If EquipArray[HolsterW] == 0
            Playerref.RemoveItem(HolsterPropArray[HolsterW], 1, true)
            HolsterInstanceArray[HolsterW].DisableNoWait()
            HolsterInstanceArray[HolsterW].Delete()
            HolsterPropArray[HolsterW].SetWeight(WeightArray[HolsterW])
            HolsterPropArray[HolsterW].SetName(FullNameArray[HolsterW])
            ObjectReference Holster = PlayerRef.PlaceAtMe(HolsterPropArray[HolsterW] , 1)
            PlayerRef.AddItem(Holster, 1, true)
            HolsterInstanceArray[HolsterW] = Holster
        Endif
        If EquipArray[HolsterW] == 1
            Playerref.RemoveItem(HolsterPropArray[HolsterW], 1, true)
            HolsterInstanceArray[HolsterW].DisableNoWait()
            HolsterInstanceArray[HolsterW].Delete()
            HolsterPropArray[HolsterW].SetWeight(0.0)
            HolsterPropArray[HolsterW].SetName(EmptyNameArray[HolsterW])
            ObjectReference Holster = PlayerRef.PlaceAtMe(HolsterPropArray[HolsterW] , 1)
            PlayerRef.AddItem(Holster, 1, true)
            HolsterInstanceArray[HolsterW] = Holster
        Endif
        HolsterW +=1
    EndWhile
    RemoveItem = 0   
EndFunction

;========================================================================================================================
; Move Holster Spheres functions
;========================================================================================================================

Function Slot01Move()
    PapyrusVR.DestroyLocalOverlapObject(LeftShoulder)
    float[] Holster01pos = PapyrusVR.Vector3(VRH_H01POSX.GetValue(), VRH_H01POSY.GetValue(), VRH_H01POSZ.GetValue())
    float[] rotation = PapyrusVR.Quaternion_Zero()
    LeftShoulder = PapyrusVR.RegisterLocalOverlapSphere(0.15, Holster01pos, rotation, 0)
EndFunction

Function Slot02Move()
    PapyrusVR.DestroyLocalOverlapObject(RightShoulder)
    float[] Holster02pos = PapyrusVR.Vector3(VRH_H02POSX.GetValue(), VRH_H02POSY.GetValue(), VRH_H02POSZ.GetValue())
    float[] rotation = PapyrusVR.Quaternion_Zero()
    RightShoulder = PapyrusVR.RegisterLocalOverlapSphere(0.15, Holster02pos, rotation, 0)
EndFunction

Function Slot03Move()
    PapyrusVR.DestroyLocalOverlapObject(LeftHip)
    float[] Holster03pos = PapyrusVR.Vector3(VRH_H03POSX.GetValue(), VRH_H03POSY.GetValue(), VRH_H03POSZ.GetValue())
    float[] rotation = PapyrusVR.Quaternion_Zero()
    LeftHip = PapyrusVR.RegisterLocalOverlapSphere(0.20, Holster03pos, rotation, 0)
EndFunction

Function Slot04Move()
    PapyrusVR.DestroyLocalOverlapObject(RightHip)
    float[] Holster04pos = PapyrusVR.Vector3(VRH_H04POSX.GetValue(), VRH_H04POSY.GetValue(), VRH_H04POSZ.GetValue())
    float[] rotation = PapyrusVR.Quaternion_Zero()
    RightHip = PapyrusVR.RegisterLocalOverlapSphere(0.20, Holster04pos, rotation, 0)
EndFunction

Function Slot05Move()
    PapyrusVR.DestroyLocalOverlapObject(LowerBack)
    float[] Holster05pos = PapyrusVR.Vector3(VRH_H05POSX.GetValue(), VRH_H05POSY.GetValue(), VRH_H05POSZ.GetValue())
    float[] rotation = PapyrusVR.Quaternion_Zero()
    LowerBack = PapyrusVR.RegisterLocalOverlapSphere(0.20, Holster05pos, rotation, 0)
EndFunction

Function SetHandMode()
    Hand = VRH_HandMode.GetValue() as int 
EndFunction

Function SetButtonNumber()
    ButtonNumber = VRH_ControllerButton.GetValue() as int
EndFunction


















