/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.options;

import java.util.HashMap;
import java.util.Map;
import net.bitform.oilink.OILinkMessages;

public class MarginText {
    private static final int TOPLEFT = 1;
    private static final int TOPCENTER = 2;
    private static final int TOPRIGHT = 3;
    private static final int BOTTOMLEFT = 4;
    private static final int BOTTOMCENTER = 5;
    private static final int BOTTOMRIGHT = 6;
    private Map<Location, String> m_textList = new HashMap<Location, String>();

    public MarginText(Location location, String string) {
        this.addMarginText(location, string);
    }

    public MarginText(Map<Location, String> map) {
        for (Location location : map.keySet()) {
            this.addMarginText(location, map.get((Object)location));
        }
    }

    public void addMarginText(Location location, String string) {
        this.m_textList.put(location, string);
    }

    public void addMarginText(Map<Location, String> map) {
        this.m_textList.putAll(map);
    }

    public OILinkMessages.MarginText getPBData() {
        OILinkMessages.MarginText.Builder builder = OILinkMessages.MarginText.newBuilder();
        for (Location location : this.m_textList.keySet()) {
            OILinkMessages.MarginTextItem.Builder builder2 = OILinkMessages.MarginTextItem.newBuilder();
            builder2.setLinenum(location.getLine());
            builder2.setLocation(location.getZone());
            builder2.setText(this.m_textList.get((Object)location));
            builder.addMargintexts(builder2);
        }
        return builder.build();
    }

    public static enum Location {
        TOPLEFTLINE1(1, 1),
        TOPLEFTLINE2(1, 2),
        TOPLEFTLINE3(1, 3),
        TOPCENTERLINE1(2, 1),
        TOPCENTERLINE2(2, 2),
        TOPCENTERLINE3(2, 3),
        TOPRIGHTLINE1(3, 1),
        TOPRIGHTLINE2(3, 2),
        TOPRIGHTLINE3(3, 3),
        BOTTOMLEFTLINE1(4, 1),
        BOTTOMLEFTLINE2(4, 2),
        BOTTOMLEFTLINE3(4, 3),
        BOTTOMCENTERLINE1(5, 1),
        BOTTOMCENTERLINE2(5, 2),
        BOTTOMCENTERLINE3(5, 3),
        BOTTOMRIGHTLINE1(6, 1),
        BOTTOMRIGHTLINE2(6, 2),
        BOTTOMRIGHTLINE3(6, 3);

        private int m_zone;
        private int m_line;

        int getZone() {
            return this.m_zone;
        }

        int getLine() {
            return this.m_line;
        }

        private Location(int n2, int n3) {
            this.m_zone = n2;
            this.m_line = n3;
        }
    }
}

