/*
 * Decompiled with CFR 0.152.
 */
package net.bitform.oilink;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.bitform.oilink.BasicIO;
import net.bitform.oilink.OILink;
import net.bitform.oilink.OILinkMessages;

public final class BlockingReadableBasicIO
implements BasicIO {
    private final OILink oil;
    private ByteBuffer recentData = null;
    private boolean closed = false;

    public BlockingReadableBasicIO(OILink oILink) {
        this.oil = oILink;
    }

    @Override
    public void open() {
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public int readAt(long l, ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        while (byteBuffer.remaining() > 0) {
            if (this.recentData != null && this.recentData.remaining() >= byteBuffer.remaining()) {
                n = byteBuffer.remaining();
                int n2 = this.recentData.limit();
                this.recentData.limit(this.recentData.position() + n);
                byteBuffer.put(this.recentData);
                this.recentData.limit(n2);
                if (this.recentData.hasRemaining()) continue;
                this.recentData = null;
                continue;
            }
            if (this.recentData != null) {
                n += this.recentData.remaining();
                byteBuffer.put(this.recentData);
                this.recentData = null;
            }
            if (this.closed) break;
            OILinkMessages.ToClient toClient = this.oil.waitForMessage(OILinkMessages.ToClient.Type.IODATA, "Special readAt");
            if (toClient.getType() == OILinkMessages.ToClient.Type.IODATA) {
                OILinkMessages.IOData iOData = toClient.getIoData();
                if (!this.oil.files.isEmpty() && iOData.getIoId() < this.oil.files.size()) {
                    if (this.oil.files.get(iOData.getIoId()) != this) {
                        throw new IllegalArgumentException("IO id references the incorrect BasicIO object");
                    }
                } else {
                    throw new IllegalArgumentException("IO id of " + iOData.getIoId() + " is invalid");
                }
                this.recentData = this.oil.readBytes(iOData.getCount());
                continue;
            }
            if (toClient.getType() != OILinkMessages.ToClient.Type.IODATAEOF) continue;
            this.closed = true;
            break;
        }
        return n;
    }

    @Override
    public void writeAt(long l, ByteBuffer byteBuffer) throws IOException {
        throw new IllegalArgumentException("Write not allowed");
    }

    @Override
    public long getSize() throws IOException {
        throw new IllegalArgumentException("Get size not allowed");
    }

    @Override
    public void close() {
    }

    @Override
    public File getUnderlyingFile() {
        return null;
    }

    @Override
    public String getUnderlyingFileName() {
        return null;
    }
}

